/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IServiceTimeDAO;
import com.sinba.common.security.dto.ServiceTimeDTO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.ServiceTime;
import com.sinba.common.security.service.IServiceTimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceTimeService
implements IServiceTimeService {
    @Autowired
    private IServiceTimeDAO serviceTimeDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;

    public ServiceTimeDTO findServiceTimeByOrgNo(Long orgNo) {
        ServiceTime entity = this.serviceTimeDAO.findByOrgNo(orgNo);
        ServiceTimeDTO dto = new ServiceTimeDTO();
        if (entity != null) {
            ServiceTimeDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getOrganization() != null) {
                dto.setOrgNo(entity.getOrganization().getOrgNo());
            }
        }
        return dto;
    }

    @Transactional
    public void saveOrUpdateServiceTime(ServiceTimeDTO dto) {
        ServiceTime serviceTime = null;
        Long sid = dto.getSid();
        if (sid != null) {
            serviceTime = (ServiceTime)((Object)this.serviceTimeDAO.findById(sid));
        }
        if (serviceTime == null) {
            serviceTime = new ServiceTime();
        }
        serviceTime.setOrganization((Organization)((Object)this.organizationDAO.findById(dto.getOrgNo())));
        ServiceTimeDTO.dto2entity((Object)((Object)dto), (Object)((Object)serviceTime));
        ServiceTime serviceTimeM = (ServiceTime)((Object)this.serviceTimeDAO.merge((Object)serviceTime));
        dto.setSid(serviceTimeM.getSid());
        Organization org = (Organization)((Object)this.organizationDAO.findById(dto.getOrgNo()));
        org.setServiceTime(serviceTimeM);
        this.organizationDAO.merge((Object)org);
    }
}

