/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.ICompanyDAO;
import com.sinba.common.security.dao.ISupplierDAO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.dto.SupplierDTO;
import com.sinba.common.security.dto.SupplierQueryDTO;
import com.sinba.common.security.entity.Company;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.Supplier;
import com.sinba.common.security.service.ISupplierService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SupplierService
implements ISupplierService {
    @Autowired
    private ISupplierDAO supplierDAO;
    @Autowired
    private ICompanyDAO companyDAO;

    public PageDTO findPagerSupplier(SupplierQueryDTO supplierrQueryDTO, String sidx, String sord) {
        PageDTO p = this.supplierDAO.findPager(supplierrQueryDTO, sidx, sord);
        List entities = p.getData();
        ArrayList<SupplierDTO> dtos = new ArrayList<SupplierDTO>();
        for (Supplier sup : entities) {
            SupplierDTO dto = new SupplierDTO();
            if (sup.getParentOrg() != null) {
                dto.setCompanyNo(sup.getParentOrg().getOrgNo());
            }
            SupplierDTO.entity2dto((Object)((Object)sup), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public void saveSupplier(SupplierDTO dto) {
        Supplier supplier = new Supplier();
        SupplierDTO.dto2entity((Object)((Object)dto), (Object)((Object)supplier));
        if (dto.getCompanyNo() != null) {
            Company company = (Company)((Object)this.companyDAO.findById(dto.getCompanyNo()));
            supplier.setParentOrg(company);
        }
        this.supplierDAO.save((Object)supplier);
        dto.setOrgNo(supplier.getOrgNo());
    }

    @Transactional
    public void mergeSupplier(SupplierDTO dto) {
        Supplier supplier = (Supplier)((Object)this.supplierDAO.findById(dto.getOrgNo()));
        SupplierDTO.dto2entity((Object)((Object)dto), (Object)((Object)supplier));
        if (dto.getCompanyNo() != null) {
            supplier.setParentOrg((Organization)((Object)this.companyDAO.findById(dto.getCompanyNo())));
        }
        this.supplierDAO.merge((Object)supplier);
    }

    public void saveSupplier(OrganizationDTO dto) {
        Supplier supplier = new Supplier();
        supplier.setOrgName(dto.getOrgName());
        supplier.setOfficeFax(dto.getOfficeFax());
        supplier.setOfficePhone(dto.getOfficePhone());
        supplier.setEmail(dto.getEmail());
        supplier.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != -1L) {
            Company company = (Company)((Object)this.companyDAO.findById(dto.getParentOrgNo()));
            supplier.setParentOrg(company);
        }
        this.supplierDAO.save((Object)supplier);
    }

    public void mergeSupplier(OrganizationDTO dto) {
        Supplier supplier = (Supplier)((Object)this.supplierDAO.findById(dto.getOrgNo()));
        supplier.setOrgName(dto.getOrgName());
        supplier.setOfficeFax(dto.getOfficeFax());
        supplier.setOfficePhone(dto.getOfficePhone());
        supplier.setEmail(dto.getEmail());
        supplier.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != -1L) {
            supplier.setParentOrg((Organization)((Object)this.companyDAO.findById(dto.getParentOrgNo())));
        }
        this.supplierDAO.merge((Object)supplier);
    }

    public void deleteSupplier(Long orgNo) {
        this.supplierDAO.delete(this.supplierDAO.findById(orgNo));
    }

    @Transactional
    public void deleteSupplier(Long[] orgNo) {
        this.supplierDAO.deleteByIds(orgNo);
    }

    public Supplier findSupplierById(Long id) {
        return (Supplier)((Object)this.supplierDAO.findById(id));
    }

    @Transactional
    public SupplierDTO findById(Long id) {
        SupplierDTO dto = new SupplierDTO();
        Supplier entity = (Supplier)((Object)this.supplierDAO.findById(id));
        if (entity != null) {
            SupplierDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        }
        if (entity.getParentOrg() != null) {
            dto.setCompanyNo(entity.getParentOrg().getOrgNo());
        }
        return dto;
    }
}

