/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.EditUserPasswordDTO;
import com.sinba.common.security.dto.RoleDTO;
import com.sinba.common.security.dto.UserDTO;
import com.sinba.common.security.dto.UserQueryDTO;
import com.sinba.common.security.dto.UserRoleDTO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.User;
import com.sinba.common.security.service.IRoleService;
import com.sinba.common.security.service.IUserInfoService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfoService
implements IUserInfoService,
UserDetailsService {
    @Autowired
    private JbpmFacade jbpmFacade;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IOrganizationDAO organizationDAO;

    @Transactional(propagation=Propagation.REQUIRED)
    public UserDetails loadUserByUsername(String username) {
        User user = (User)((Object)this.userDAO.findUniqueBy("loginName", username));
        UserDTO userDTO = new UserDTO();
        UserDTO.entity2dto((Object)((Object)user), (Object)((Object)userDTO));
        if (user == null) {
            return null;
        }
        userDTO.setUsername(user.getLoginName());
        userDTO.setEnabled(true);
        Set<Role> roleList = null;
        Set<Role> roleList1 = null;
        Set<Role> roleList2 = user.getRoles();
        if (user.getOrgnization() != null) {
            roleList1 = user.getOrgnization().getOrgRoles();
        }
        roleList = this.getUnionSet(roleList1, roleList2);
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(roleList.size());
        userDTO.setAuthorities(authorities);
        for (Role role : roleList) {
            RoleDTO roleDTO = new RoleDTO();
            RoleDTO.entity2dto((Object)((Object)role), (Object)((Object)roleDTO));
            roleDTO.setAuthority(role.getRoleCode());
            authorities.add(roleDTO);
        }
        return userDTO;
    }

    public Set<Role> getUnionSet(Set<Role> ... sets) {
        HashSet<Role> unionSet = new HashSet<Role>();
        for (Set<Role> set : sets) {
            unionSet.addAll(set);
        }
        return unionSet;
    }

    public Set<Role> geDifferenceSet(Set<Role> setSrc, Set<Role> ... sets) {
        HashSet<Role> unionSet = new HashSet<Role>();
        unionSet.addAll(setSrc);
        for (Set<Role> set : sets) {
            unionSet.removeAll(set);
        }
        return unionSet;
    }

    public Set<Role> getSameSet(Set<Role> ... sets) {
        Set<Role> unionSet;
        Set<Role> sameSet = null;
        sameSet = unionSet = this.getUnionSet(sets);
        for (Set<Role> set : sets) {
            sameSet = this.geDifferenceSet(sameSet, this.geDifferenceSet(unionSet, set));
        }
        return sameSet;
    }

    @Override
    public Set<Role> getRoleByIds(Long[] roleIds) {
        HashSet<Role> roles = new HashSet<Role>();
        if (roleIds != null) {
            for (Long roleId : roleIds) {
                Role role = this.roleService.findRoleById(roleId);
                roles.add(role);
            }
        }
        return roles;
    }

    @Override
    @Transactional
    public void saveUser(UserDTO userDto) {
        User user = new User();
        UserDTO.dto2entity((Object)((Object)userDto), (Object)((Object)user));
        Set<Role> roles = this.getRoleByIds(userDto.getRoleIds());
        user.setRoles(roles);
        Organization org = (Organization)((Object)this.organizationDAO.findById(Long.valueOf(userDto.getOrgNo())));
        user.setOrgnization(org);
        user.setCreateTime(new Date(new java.util.Date().getTime()));
        this.userDAO.save((Object)user);
        userDto.setUserId(user.getUserId());
        this.jbpmFacade.createUser(user.getLoginName(), user.getFirstName(), user.getLastName(), user.getEmail());
        String[] userIds = new String[]{user.getLoginName()};
        this.jbpmFacade.createMembership(user.getOrgnization().getOrgName(), userIds);
    }

    public void getOrgChildren(Long parentNo, List<Organization> orgs) {
        List<Organization> childrens = this.organizationDAO.findByParent(parentNo);
        if (childrens != null) {
            for (Organization og : childrens) {
                orgs.add(og);
                this.getOrgChildren(og.getOrgNo(), orgs);
            }
        }
    }

    @Override
    @Transactional
    public PageDTO findPagerUser(UserQueryDTO userQueryDto, String sord, String sidx) {
        if (userQueryDto.getOrgNo() > 0L) {
            ArrayList<Organization> childrens = new ArrayList<Organization>();
            childrens.add((Organization)((Object)this.organizationDAO.findById(Long.valueOf(userQueryDto.getOrgNo()))));
            this.getOrgChildren(userQueryDto.getOrgNo(), childrens);
            if (childrens.size() > 0) {
                Long[] orgsArr = new Long[childrens.size()];
                int i = 0;
                for (Organization og : childrens) {
                    orgsArr[i] = og.getOrgNo();
                    ++i;
                }
                userQueryDto.setOrgNos(orgsArr);
            }
        }
        PageDTO p = this.userDAO.findPager(userQueryDto, sord, sidx);
        List entities = p.getData();
        ArrayList<UserDTO> dtos = new ArrayList<UserDTO>(entities.size());
        for (User entity : entities) {
            UserDTO dto = new UserDTO();
            UserDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getOrgnization() != null) {
                dto.setOrgNo(entity.getOrgnization().getOrgNo());
                dto.setOrgName(entity.getOrgnization().getOrgName());
            }
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public boolean delUser(Long[] userId) {
        boolean result = true;
        Byte delete = 1;
        for (Long id : userId) {
            User user = (User)((Object)this.userDAO.findById(id));
            if (!user.getDataFlag().equals(delete)) continue;
            result = false;
        }
        if (result) {
            this.userDAO.deleteByIds(userId);
        }
        return result;
    }

    @Override
    public void editUser(UserDTO userDto) {
        User user = (User)((Object)this.userDAO.findById(Long.valueOf(userDto.getUserId())));
        UserDTO.dto2entity((Object)((Object)userDto), (Object)((Object)user));
        Set<Role> roles = this.getRoleByIds(userDto.getRoleIds());
        user.setRoles(roles);
        Organization org = (Organization)((Object)this.organizationDAO.findById(Long.valueOf(userDto.getOrgNo())));
        user.setOrgnization(org);
        user.setLastUpdateTime(new Date(new java.util.Date().getTime()));
        this.userDAO.merge((Object)user);
        this.jbpmFacade.modifyUser(user.getLoginName(), user.getFirstName(), user.getLastName(), user.getEmail());
    }

    @Override
    public void mergeAllUser(Long[] ids, Long[] roleIds) {
        HashSet<User> users = new HashSet<User>();
        for (Long id : ids) {
            User user = this.findUserById(id);
            HashSet<Role> roleSet = new HashSet<Role>();
            for (Long roleId : roleIds) {
                Role role = this.roleService.findRoleById(roleId);
                roleSet.add(role);
            }
            user.setRoles(roleSet);
            user.setLastUpdateTime(new Date(new java.util.Date().getTime()));
            users.add(user);
        }
        this.userDAO.mergeAll(users);
    }

    @Override
    public List<User> findAllUser() {
        List list = this.userDAO.findAll();
        return list;
    }

    @Override
    @Transactional
    public User findUserById(long id) {
        return (User)((Object)this.userDAO.findById(Long.valueOf(id)));
    }

    @Override
    @Transactional
    public List<UserRoleDTO> getUserRoleByUserId(long id) {
        ArrayList<UserRoleDTO> list = new ArrayList<UserRoleDTO>();
        User user = (User)((Object)this.userDAO.findById(Long.valueOf(id)));
        Set<Role> roleSet = user.getRoles();
        Iterator<Role> iterator = roleSet.iterator();
        while (iterator.hasNext()) {
            UserRoleDTO userRoleDto = new UserRoleDTO();
            Role role1 = iterator.next();
            userRoleDto.setRoleId(role1.getRoleId());
            userRoleDto.setRoleName(role1.getRoleName());
            list.add(userRoleDto);
        }
        return list;
    }

    @Override
    public boolean userExist(String loginName) {
        User user = (User)((Object)this.userDAO.findUniqueBy("loginName", loginName));
        boolean result = true;
        if (user != null) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean mergeByOrg(String[] ids, long orgNo) {
        boolean result = false;
        if (ids != null) {
            ArrayList<User> users = new ArrayList<User>();
            Organization org = (Organization)((Object)this.organizationDAO.findById(Long.valueOf(orgNo)));
            for (int i = 0; i < ids.length; ++i) {
                User user = this.findUserById(Integer.parseInt(ids[i]));
                user.setOrgnization(org);
                users.add(user);
            }
            try {
                this.userDAO.mergeAll(users);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    @Override
    @Transactional
    public UserDTO findUserByName(String uname) {
        User user = (User)((Object)this.userDAO.findUniqueBy("loginName", uname));
        if (user != null) {
            UserDTO dto = new UserDTO();
            dto.setLoginName(uname);
            dto.setUserId(user.getUserId());
            dto.setPassword(user.getPassword());
            return dto;
        }
        return null;
    }

    @Override
    @Transactional
    public String findDisable(String uname, String pwd) {
        return this.userDAO.findDisable(uname, pwd);
    }

    @Override
    @Transactional
    public InputStream exportUserItems(UserQueryDTO userQueryDTO, String sord, String sidx) throws Exception {
        String sheetName = "\u7528\u6237\u7ba1\u7406";
        String[] colNames = new String[]{"\u767b\u5f55\u540d", "\u59d3", "\u540d\u5b57", "\u6240\u5c5e\u673a\u6784", "\u7535\u8bdd", "\u624b\u673a", "Email", "\u72b6\u6001", "\u7528\u6237\u804c\u79f0", "\u529e\u516c\u5730\u5740"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        this.searchOrganization(userQueryDTO);
        PageDTO p = this.userDAO.findPager(userQueryDTO, sord, sidx);
        if (p != null) {
            if (p.getData() != null && p.getData().size() > 0) {
                List entities = p.getData();
                for (User item : entities) {
                    this.convertChangeToStringArray(item, data);
                }
                try {
                    return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    public void convertChangeToStringArray(User item, List<String[]> data) {
        UserDTO dto = new UserDTO();
        String userStatus = "\u7981\u7528";
        UserDTO.entity2dto((Object)((Object)item), (Object)((Object)dto));
        if (item.getOrgnization() != null) {
            dto.setOrgName(item.getOrgnization().getOrgName());
        }
        if (item.getUserState()) {
            userStatus = "\u542f\u7528";
        }
        data.add(new String[]{dto.getLoginName(), dto.getFirstName(), dto.getLastName(), dto.getOrgName(), dto.getPhone(), dto.getMoblie(), dto.getEmail(), userStatus, dto.getJob(), dto.getOfficeAddress()});
    }

    public void searchOrganization(UserQueryDTO userQueryDTO) {
        if (userQueryDTO.getOrgNo() > 0L) {
            ArrayList<Organization> childrens = new ArrayList<Organization>();
            childrens.add((Organization)((Object)this.organizationDAO.findById(Long.valueOf(userQueryDTO.getOrgNo()))));
            this.getOrgChildren(userQueryDTO.getOrgNo(), childrens);
            if (childrens.size() > 0) {
                Long[] orgsArr = new Long[childrens.size()];
                int i = 0;
                for (Organization og : childrens) {
                    orgsArr[i] = og.getOrgNo();
                    ++i;
                }
                userQueryDTO.setOrgNos(orgsArr);
            }
        }
    }

    @Override
    @Transactional
    public Integer importUserItems(UserQueryDTO userQueryDTO) {
        File importFile = userQueryDTO.getImportFile();
        String sheetName = "\u7528\u6237\u7ba1\u7406";
        List data = null;
        try {
            data = ExcelUtil.readSheet((String)sheetName, (InputStream)new FileInputStream(importFile));
        }
        catch (Exception e) {
            return -1;
        }
        if (data != null && data.size() > 0) {
            int count = 0;
            try {
                for (String[] rowData : data) {
                    if (!rowData[0].toString().equals("") && rowData[0] != null) {
                        this.saveUserItems(rowData);
                        ++count;
                        continue;
                    }
                    return -1;
                }
            }
            catch (Exception e) {
                return -2;
            }
            return count;
        }
        return 0;
    }

    @Transactional
    public void saveUserItems(String[] rowData) {
        UserDTO dto = new UserDTO();
        boolean userStatus = false;
        if (rowData[7].toString().equals("\u542f\u7528")) {
            userStatus = true;
        }
        dto.setLoginName(rowData[0].toString());
        dto.setFirstName(rowData[1].toString());
        dto.setLastName(rowData[2].toString());
        dto.setOrgName(rowData[3].toString());
        dto.setPhone(rowData[4].toString());
        dto.setMoblie(rowData[5].toString());
        dto.setEmail(rowData[6].toString());
        dto.setUserState(userStatus);
        dto.setJob(rowData[8].toString());
        dto.setOfficeAddress(rowData[9].toString());
        User entity = new User();
        UserDTO.entity2dto((Object)((Object)dto), (Object)((Object)entity));
        this.userDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public boolean resetPassword(EditUserPasswordDTO dto) {
        boolean result = true;
        if (dto != null && dto.getLoginName() != null) {
            User user = (User)((Object)this.userDAO.findUniqueBy("loginName", dto.getLoginName()));
            if (dto.getResetPassword() != null && dto.getResetPassword().equals("resetPassword")) {
                user.setPassword("Password123");
            } else if (!user.getPassword().equals(dto.getOldPassword())) {
                result = false;
            } else {
                user.setPassword(dto.getNewPassword());
            }
            if (result) {
                this.userDAO.merge((Object)user);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public UserDTO findById(Long id) {
        UserDTO dto = new UserDTO();
        User entity = (User)((Object)this.userDAO.findById(id));
        UserDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        if (entity.getRoles() != null) {
            int i = 0;
            Long[] roleIds = new Long[entity.getRoles().size()];
            for (Role role : entity.getRoles()) {
                roleIds[i] = role.getRoleId();
                ++i;
            }
            dto.setRoleIds(roleIds);
        }
        if (entity.getOrgnization() != null) {
            dto.setOrgNo(entity.getOrgnization().getOrgNo());
        }
        return dto;
    }
}

