/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.validatecode;

import com.sinba.common.exception.ApplicationException;
import com.sinba.common.security.validatecode.ValidateCode;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CaptchaFilter
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = -5838154525730151323L;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        String servletPath = request.getServletPath();
        if (servletPath.matches("/security/captcha.jpg")) {
            response.setContentType("image/jpeg");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            ValidateCode vCode = new ValidateCode(64, 22, 4, 200);
            session.setAttribute("captcha", (Object)vCode.getCode());
            vCode.write((OutputStream)response.getOutputStream());
            return;
        }
        String code = request.getParameter("j_validate");
        String realCode = (String)session.getAttribute("captcha");
        if (code == null || realCode == null || !code.equals(realCode)) {
            session.setAttribute("captcha", (Object)new Double(Math.random()).toString());
            throw new ApplicationException("validate_error_verificationCode");
        }
        session.setAttribute("captcha", (Object)new Double(Math.random()).toString());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

