/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.request.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.config.attachment.entity.Attachment;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.tools.dto.HistoryRecordDTO;
import com.sinba.itsm.request.dto.RequestCountResultDTO;
import com.sinba.itsm.request.dto.RequestDTO;
import com.sinba.itsm.request.dto.RequestDetailDTO;
import com.sinba.itsm.request.dto.RequestGridDTO;
import com.sinba.itsm.request.dto.RequestQueryDTO;
import com.sinba.itsm.request.dto.RequestSimpleDTO;
import com.sinba.itsm.request.service.IRequestService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAction
extends ActionSupport {
    @Autowired
    private IRequestService requestService;
    private RequestDTO requestDTO = new RequestDTO();
    private RequestDetailDTO requestDetailDTO = new RequestDetailDTO();
    private RequestGridDTO requestGridDTO = new RequestGridDTO();
    private RequestQueryDTO requestQueryDTO = new RequestQueryDTO();
    private int page = 1;
    private int rows = 10;
    private PageDTO requests;
    private Long eno;
    private Long[] enos;
    private Integer countRequest;
    private RequestCountResultDTO rcrd;
    private Set<String> outcomesSet = new HashSet<String>();
    private String taskId;
    private String closeNumber;
    private String sidx;
    private String sord;
    private Long aid;
    private List<Attachment> attachment;
    private String fileName = "";
    private InputStream exportStream;
    private String effect = "";
    private HistoryRecordDTO historyRecordDto;
    private CompassQueryDTO compassQueryDTO = new CompassQueryDTO();
    private List<RequestSimpleDTO> simples = new ArrayList<RequestSimpleDTO>();

    public CompassQueryDTO getCompassQueryDTO() {
        return this.compassQueryDTO;
    }

    public void setCompassQueryDTO(CompassQueryDTO compassQueryDTO) {
        this.compassQueryDTO = compassQueryDTO;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InputStream getExportStream() {
        return this.exportStream;
    }

    public void setExportStream(InputStream exportStream) {
        this.exportStream = exportStream;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public List<RequestSimpleDTO> getSimples() {
        return this.simples;
    }

    public void setSimples(List<RequestSimpleDTO> simples) {
        this.simples = simples;
    }

    public Integer getCountRequest() {
        return this.countRequest;
    }

    public void setCountRequest(Integer countRequest) {
        this.countRequest = countRequest;
    }

    public RequestCountResultDTO getRcrd() {
        return this.rcrd;
    }

    public void setRcrd(RequestCountResultDTO rcrd) {
        this.rcrd = rcrd;
    }

    public Long getEno() {
        return this.eno;
    }

    public void setEno(Long eno) {
        this.eno = eno;
    }

    public Long[] getEnos() {
        return this.enos;
    }

    public void setEnos(Long[] enos) {
        this.enos = enos;
    }

    public RequestDetailDTO getRequestDetailDTO() {
        return this.requestDetailDTO;
    }

    public void setRequestDetailDTO(RequestDetailDTO requestDetailDTO) {
        this.requestDetailDTO = requestDetailDTO;
    }

    public IRequestService getRequestService() {
        return this.requestService;
    }

    public void setRequestService(IRequestService requestService) {
        this.requestService = requestService;
    }

    public RequestDTO getRequestDTO() {
        return this.requestDTO;
    }

    public void setRequestDTO(RequestDTO requestDTO) {
        this.requestDTO = requestDTO;
    }

    public RequestQueryDTO getRequestQueryDTO() {
        return this.requestQueryDTO;
    }

    public void setRequestQueryDTO(RequestQueryDTO requestQueryDTO) {
        this.requestQueryDTO = requestQueryDTO;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public PageDTO getRequests() {
        return this.requests;
    }

    public void setRequests(PageDTO requests) {
        this.requests = requests;
    }

    public RequestGridDTO getRequestGridDTO() {
        return this.requestGridDTO;
    }

    public void setRequestGridDTO(RequestGridDTO requestGridDTO) {
        this.requestGridDTO = requestGridDTO;
    }

    public Set<String> getOutcomesSet() {
        return this.outcomesSet;
    }

    public void setOutcomesSet(Set<String> outcomesSet) {
        this.outcomesSet = outcomesSet;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getCloseNumber() {
        return this.closeNumber;
    }

    public void setCloseNumber(String closeNumber) {
        this.closeNumber = closeNumber;
    }

    public Long getAid() {
        return this.aid;
    }

    public void setAid(Long aid) {
        this.aid = aid;
    }

    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<Attachment> attachment) {
        this.attachment = attachment;
    }

    public HistoryRecordDTO getHistoryRecordDto() {
        return this.historyRecordDto;
    }

    public void setHistoryRecordDto(HistoryRecordDTO historyRecordDto) {
        this.historyRecordDto = historyRecordDto;
    }

    public String findRequests() {
        int start = (this.page - 1) * this.rows;
        this.requestQueryDTO.setStart(start);
        this.requestQueryDTO.setLimit(this.rows);
        this.requests = this.requestService.findRequestByPage(this.requestQueryDTO, this.sidx, this.sord);
        this.requests.setPage(this.page);
        this.requests.setRows(this.rows);
        return "requests";
    }

    public String findRequestForPortal() {
        this.simples = this.requestService.findRequestPortal(this.requestQueryDTO);
        return "portalRequest";
    }

    public String saveRequest() {
        this.eno = this.requestService.saveRequest(this.requestDTO);
        return "eno";
    }

    public String updateRequest() {
        this.requestService.updateRequest(this.requestDTO);
        return "success";
    }

    public String saveSolutions() {
        this.requestService.saveSolutions(this.requestDTO);
        return "success";
    }

    public String findRequestById() {
        this.requestDetailDTO = this.requestService.findRequestById(this.requestQueryDTO.getEno());
        return "singleRequest";
    }

    public String deleteRequests() {
        this.requestService.deleteRequests(this.enos);
        return "success";
    }

    public String countRequest() {
        this.rcrd = this.requestService.countRequest(this.requestQueryDTO);
        return "rcrd";
    }

    public String requestAction() {
        if (this.requestDTO.getOptType().equals("requestVisit")) {
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = "";
            url = request.getScheme() + "://";
            url = url + request.getHeader("host");
            String str = request.getRequestURI();
            url = url + str.substring(0, str.lastIndexOf("/")) + "/requestVisit.jsp";
            this.requestDTO.setVisitPath(url);
        }
        this.requestService.requestAction(this.requestDTO, this.historyRecordDto);
        return "success";
    }

    public String requestDetails() {
        if (this.eno != null) {
            this.requestDetailDTO = this.requestService.findRequestById(this.eno);
            if (this.requestDetailDTO.getPid() != null) {
                this.outcomesSet = this.requestService.getOutcomes(this.requestDetailDTO.getPid());
            }
        }
        return "requestDetails";
    }

    public String requestDetails1() {
        if (this.eno != null) {
            this.requestDetailDTO = this.requestService.findRequestById(this.eno);
            if (this.requestDetailDTO.getPid() != null) {
                this.outcomesSet = this.requestService.getOutcomes(this.requestDetailDTO.getPid());
            }
        }
        return "requestDetails1";
    }

    public String showRequestInfo() {
        if (this.eno != null) {
            this.requestDetailDTO = this.requestService.findRequestById(this.eno);
        }
        return "requestDetailDTO";
    }

    public String emailToRequest() throws UnsupportedEncodingException {
        RequestDTO requestDtos = new RequestDTO();
        String etitle = new String(this.requestDetailDTO.getEtitle().getBytes("ISO-8859-1"), "UTF-8");
        requestDtos.setEtitle(etitle);
        this.requestDTO = requestDtos;
        return "requestAdd";
    }

    public String jumpToAddKnowledge() {
        this.requestDetailDTO = this.requestService.findRequestById(this.eno);
        return "addKnowledgePage";
    }

    public String exportRequest() {
        this.fileName = new Date().getTime() + ".xls";
        int start = (this.page - 1) * this.rows;
        this.requestQueryDTO.setStart(start);
        this.requestQueryDTO.setLimit(this.rows);
        try {
            this.exportStream = this.requestService.exportRequestItems(this.requestQueryDTO, this.sidx, this.sord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "exportFileSuccessful";
    }

    public String analogousRequest() {
        this.requests = this.requestService.fullSearch(this.compassQueryDTO, this.page, this.rows);
        return "requests";
    }
}

