/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.request.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.request.dao.IRequestDAO;
import com.sinba.itsm.request.dto.RequestCountResultDTO;
import com.sinba.itsm.request.dto.RequestQueryDTO;
import com.sinba.itsm.request.entity.Request;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDAO
extends BaseDAOImplHibernate<Request>
implements IRequestDAO {
    @Override
    public PageDTO findPager(RequestQueryDTO qdto, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(Request.class);
        int start = 0;
        int limit = 0;
        if (qdto != null) {
            GregorianCalendar endTimeCl;
            start = qdto.getStart();
            limit = qdto.getLimit();
            if (StringUtils.hasText((String)qdto.getRequestCode())) {
                dc.add((Criterion)Restrictions.like((String)"requestCode", (String)qdto.getRequestCode(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getKeyWord())) {
                dc.add((Criterion)Restrictions.like((String)"keyWord", (String)qdto.getKeyWord(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.getEtitle() != null) {
                dc.add((Criterion)Restrictions.like((String)"etitle", (String)qdto.getEtitle(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.getCategoryNos() != null && qdto.getCategoryNos().length > 0) {
                dc.createAlias("requestCategory", "rc").add(Restrictions.in((String)"rc.eventId", (Object[])qdto.getCategoryNos()));
            }
            if (qdto.getStatusNo() != null && qdto.getStatusNo() != 0L) {
                dc.createAlias("status", "st").add((Criterion)Restrictions.eq((String)"st.dcode", (Object)qdto.getStatusNo()));
            }
            if (qdto.getCreatedByName() != null) {
                dc.createAlias("createdBy", "cb").add((Criterion)Restrictions.eq((String)"cb.loginName", (Object)qdto.getCreatedByName()));
            }
            if (qdto.getTechnicianName() != null) {
                dc.createAlias("technician", "tc").add((Criterion)Restrictions.eq((String)"tc.loginName", (Object)qdto.getTechnicianName()));
            }
            if (qdto.getCiId() != null && qdto.getCiId() != 0L) {
                dc.createAlias("ci", "config").add((Criterion)Restrictions.eq((String)"config.ciId", (Object)qdto.getCiId()));
            }
            if (qdto.getStartTime() != null && qdto.getEndTime() == null) {
                dc.add((Criterion)Restrictions.ge((String)"createdOn", (Object)qdto.getStartTime()));
            }
            if (qdto.getStartTime() == null && qdto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(qdto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.le((String)"createdOn", (Object)endTimeCl.getTime()));
            }
            if (qdto.getStartTime() != null && qdto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(qdto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"createdOn", (Object)endTimeCl.getTime()), (Criterion)Restrictions.ge((String)"createdOn", (Object)qdto.getStartTime())));
            }
            if (qdto.getCountQueryType() != null && !qdto.getCountQueryType().equals("")) {
                if (qdto.getCountQueryType().equals("myProposedRequest") && qdto.getCurrentUser() != null) {
                    dc.createAlias("createdBy", "cb").add((Criterion)Restrictions.eq((String)"cb.loginName", (Object)qdto.getCurrentUser()));
                }
                if (qdto.getCountQueryType().equals("myGroupProposedRequest") && qdto.getOrgNo() != null && qdto.getOrgNo() != 0L) {
                    dc.createAlias("createdBy", "cb").add((Criterion)Restrictions.eq((String)"cb.orgnization.orgNo", (Object)qdto.getOrgNo()));
                }
                if (qdto.getCountQueryType().equals("assigneeGroupRequest") && qdto.getOrgNo() != null && qdto.getOrgNo() != 0L) {
                    dc.createAlias("assigneeGroup", "ag").add((Criterion)Restrictions.eq((String)"ag.orgNo", (Object)qdto.getOrgNo()));
                }
                if (qdto.getCountQueryType().equals("assigneeToMyRequest") && qdto.getCurrentUser() != null && !qdto.getCurrentUser().equals("")) {
                    dc.createAlias("assignee", "asg").add((Criterion)Restrictions.eq((String)"asg.loginName", (Object)qdto.getCurrentUser()));
                }
                if (qdto.getCountQueryType().equals("myOwnerRequest") && qdto.getCurrentUser() != null && !qdto.getCurrentUser().equals("")) {
                    dc.createAlias("owner", "ow").add((Criterion)Restrictions.eq((String)"ow.loginName", (Object)qdto.getCurrentUser()));
                }
            }
            if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
                if (sord.equals("desc")) {
                    dc.addOrder(Order.desc((String)sidx));
                } else {
                    dc.addOrder(Order.asc((String)sidx));
                }
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public void saveRequest(Request request) {
        super.save((Object)request);
    }

    @Override
    public RequestCountResultDTO countRequest(RequestQueryDTO qdto) {
        RequestCountResultDTO rcrd = new RequestCountResultDTO();
        String hql = " from Request rq where rq.dataFlag not in(99)";
        rcrd.setCountAllRquest(super.getHibernateTemplate().find(hql).size());
        if (qdto.getCreatedByName() != null) {
            hql = " from Request rq where rq.dataFlag not in(99) and rq.createdBy.loginName=?";
            rcrd.setCountMyRquest(super.getHibernateTemplate().find(hql, (Object)qdto.getCreatedByName()).size());
        }
        if (qdto.getOrgNo() != null) {
            hql = " from Request rq where rq.dataFlag not in(99) and rq.createdBy.orgnization.orgNo=?";
            rcrd.setCountMyGroupProposedRequest(super.getHibernateTemplate().find(hql, (Object)qdto.getOrgNo()).size());
        }
        if (qdto.getOrgNo() != null) {
            hql = " from Request rq where rq.dataFlag not in(99) and rq.assigneeGroup.orgNo=?";
            rcrd.setCountMyGrRquest(super.getHibernateTemplate().find(hql, (Object)qdto.getOrgNo()).size());
        }
        if (qdto.getUserName() != null) {
            hql = " from Request rq where rq.dataFlag not in(99) and rq.assignee.loginName=?";
            rcrd.setCountMyPeRquest(super.getHibernateTemplate().find(hql, (Object)qdto.getUserName()).size());
        }
        if (qdto.getOwnerName() != null) {
            hql = " from Request rq where rq.dataFlag not in(99) and rq.owner.loginName=?";
            rcrd.setCountMyOwRquest(super.getHibernateTemplate().find(hql, (Object)qdto.getOwnerName()).size());
        }
        return rcrd;
    }

    @Override
    public String dayRequestCoun() {
        java.sql.Date date = new java.sql.Date(new Date().getTime());
        String hql = " from Request rq where rq.createdOn like '" + date + "%'";
        Integer count = this.getHibernateTemplate().find(hql).size() + 1;
        String counts = String.format("%04d", count);
        return counts;
    }

    @Override
    public List<Request> findRequestPortal(RequestQueryDTO qdto) {
        DetachedCriteria dc = DetachedCriteria.forClass(Request.class);
        if (qdto.getLoginName() != null) {
            dc.createAlias("createdBy", "cb").add((Criterion)Restrictions.eq((String)"cb.loginName", (Object)qdto.getCreatedByName()));
        }
        if (qdto.getTechnicianName() != null) {
            dc.createAlias("assignee", "as").add((Criterion)Restrictions.eq((String)"as.loginName", (Object)qdto.getTechnicianName()));
        }
        if (!qdto.getQueryTag().equals("") && "unAssign".equals(qdto.getQueryTag())) {
            dc.add(Restrictions.isNull((String)"assignee"));
            dc.add(Restrictions.isNull((String)"closeTime"));
        }
        dc.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"dataFlag", (Object)Byte.parseByte("0")), (Criterion)Restrictions.eq((String)"dataFlag", (Object)Byte.parseByte("1"))));
        dc.addOrder(Order.desc((String)"eno"));
        return this.getHibernateTemplate().findByCriteria(dc, 0, 8);
    }

    @Override
    public List<Request> findAutoupdateRequest() {
        String hql = " from Request rq where rq.requestResolvedTime=null and rq.dataFlag!=99";
        return this.getHibernateTemplate().find(hql);
    }
}

