/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.request.service;

import com.sinba.common.noticeRule.dto.NoticeInfoDTO;
import com.sinba.common.noticeRule.service.INoticeRuleService;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.ServiceTime;
import com.sinba.common.security.entity.User;
import com.sinba.common.sla.entity.PromoteRule;
import com.sinba.itsm.request.dao.IRequestDAO;
import com.sinba.itsm.request.entity.Request;
import com.sinba.itsm.request.utils.CalcPredictTimeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoUpdateRequestService {
    public static final Logger LOGGER = Logger.getLogger(AutoUpdateRequestService.class);
    private CalcPredictTimeUtils calcPredictTimeUtils = new CalcPredictTimeUtils();
    @Autowired
    private IRequestDAO requestDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private INoticeRuleService noticeRuleService;

    @Transactional
    public void autoUpdateRequest() throws Exception {
        List<Request> requests = this.requestDAO.findAutoupdateRequest();
        for (Request rq : requests) {
            Long ownerId = this.autoUpdatefitOwner(rq);
            if (ownerId == 0L || rq.getOwner() != null && ownerId.longValue() == rq.getOwner().getUserId()) continue;
            rq.setOwner((User)this.userDAO.findById((Serializable)ownerId));
            rq.setUpgradeApplySign(2L);
            this.autoAupdateNotice(rq);
        }
    }

    public Long autoUpdatefitOwner(Request rq) {
        if (rq.getMaxCompleteTime() != null && rq.getServicesOrg() != null && rq.getSlaContract() != null) {
            Long currentTime = new Date().getTime();
            List prlist = rq.getSlaContract().getPromoteRule();
            List Holidays = rq.getServicesOrg().getHolidays();
            ServiceTime serviceTime = rq.getServicesOrg().getServiceTime();
            List<Date> holidays = this.calcPredictTimeUtils.getOffDays(serviceTime, Holidays);
            if (prlist != null && prlist.size() > 0) {
                for (PromoteRule p : prlist) {
                    Long updateTime = p.getTime() * 1000L;
                    if (!p.getIsIncludeHoliday().booleanValue()) {
                        this.calcTime(rq, updateTime, currentTime, p);
                        continue;
                    }
                    if (p.getBeforeOrAfter().booleanValue()) {
                        return this.calcAfterUpdate(rq, updateTime, currentTime, holidays, serviceTime, p);
                    }
                    return this.calcBeforeUpdate(rq, updateTime, currentTime, holidays, serviceTime, p);
                }
            }
        }
        return 0L;
    }

    public Long calcTime(Request rq, Long updateTime, Long currentTime, PromoteRule p) {
        Long trueUpdateTime = rq.getMaxCompleteTime() + updateTime;
        if (currentTime >= trueUpdateTime) {
            return p.getAssignee().getUserId();
        }
        return 0L;
    }

    public Long calcBeforeUpdate(Request rq, Long updateTime, Long currentTime, List<Date> holidays, ServiceTime serviceTime, PromoteRule p) {
        Long calcAutoUpdate;
        Long slaMaxCompleteTime = rq.getMaxCompleteTimeBack();
        if (slaMaxCompleteTime != null && slaMaxCompleteTime >= updateTime && holidays != null && serviceTime != null && (calcAutoUpdate = this.calcPredictTimeUtils.calcPredictTime(slaMaxCompleteTime - updateTime, rq.getCreatedOn().getTime(), holidays, serviceTime)) < rq.getCreatedOn().getTime() && currentTime >= calcAutoUpdate) {
            return p.getAssignee().getUserId();
        }
        return 0L;
    }

    public Long calcAfterUpdate(Request rq, Long updateTime, Long currentTime, List<Date> holidays, ServiceTime serviceTime, PromoteRule p) {
        Long maxCompleteTimeLong = new Date(rq.getMaxCompleteTime()).getTime();
        if (maxCompleteTimeLong != null && updateTime != null && currentTime != null && holidays != null && serviceTime != null && p != null) {
            Long calcAutoUpdate = this.calcPredictTimeUtils.calcPredictTime(updateTime, maxCompleteTimeLong, holidays, serviceTime);
            if (currentTime >= calcAutoUpdate) {
                return p.getAssignee().getUserId();
            }
        }
        return 0L;
    }

    public void autoAupdateNotice(Request rq) {
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(rq.getCreatedBy().getLoginName());
        noticeInfoDto.setLoginName(userList);
        noticeInfoDto.setEno(rq.getEno());
    }
}

