/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.request.service;

import com.sinba.common.config.dictionary.dao.IDataDictionaryItemsDAO;
import com.sinba.common.config.dictionary.entity.DataDictionaryItems;
import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.noticeRule.dto.NoticeInfoDTO;
import com.sinba.common.noticeRule.service.INoticeRuleService;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.User;
import com.sinba.itsm.request.dao.IRequestDAO;
import com.sinba.itsm.request.dto.JbpmTaskVariablesEventDTO;
import com.sinba.itsm.request.dto.RequestDTO;
import com.sinba.itsm.request.entity.Request;
import com.sinba.itsm.request.service.IRequestActionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class RequestActionService
implements IRequestActionService {
    @Autowired
    private IRequestDAO requestDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IDataDictionaryItemsDAO dataDictionaryItemsDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private JbpmFacade jbpmFacade;
    @Autowired
    private INoticeRuleService noticeRuleService;

    @Transactional
    public void requestAssgin(RequestDTO requestDTO) {
        Organization inner;
        User assignee;
        JbpmTaskVariablesEventDTO jbpmTaskVariablesEventDTO = new JbpmTaskVariablesEventDTO();
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        noticeInfoDto.setEno(requestDTO.getEno());
        noticeInfoDto.setRequestCode(request.getRequestCode());
        if (requestDTO.getAssigneeNo() != null) {
            noticeInfoDto.setUserNo(requestDTO.getAssigneeNo());
            User user = (User)this.userDAO.findById((Serializable)requestDTO.getAssigneeNo());
            jbpmTaskVariablesEventDTO.setAssigneeName(user.getLoginName());
        }
        if (requestDTO.getAssigneeGroupNo() != null) {
            noticeInfoDto.setOrgNo(requestDTO.getAssigneeGroupNo());
            Organization org = (Organization)this.organizationDAO.findById((Serializable)requestDTO.getAssigneeGroupNo());
            jbpmTaskVariablesEventDTO.setAssigneeGroupName(org.getOrgName());
        }
        jbpmTaskVariablesEventDTO.setEno(request.getEno());
        jbpmTaskVariablesEventDTO.setEcode(request.getRequestCode());
        jbpmTaskVariablesEventDTO.setEtitle(request.getEtitle());
        HashMap<String, JbpmTaskVariablesEventDTO> variables = new HashMap<String, JbpmTaskVariablesEventDTO>();
        variables.put("dto", jbpmTaskVariablesEventDTO);
        this.jbpmFacade.reSetVariablesByPid(requestDTO.getPid(), variables);
        if (requestDTO.getAssigneeNo() != null && (assignee = (User)this.userDAO.findById((Serializable)requestDTO.getAssigneeNo())) != null) {
            request.setAssignee(assignee);
        }
        if (requestDTO.getAssigneeGroupNo() != null && (inner = (Organization)this.organizationDAO.findById((Serializable)requestDTO.getAssigneeGroupNo())) != null) {
            request.setAssigneeGroup(inner);
        }
        if (requestDTO.getPid() != null) {
            if (requestDTO.getOptType().equals("requestAssgin")) {
                request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_one"));
                this.processNext(requestDTO.getPid(), "\u8bf7\u6c42\u6307\u6d3e");
            }
            if (requestDTO.getOptType().equals("requestAssginTwo")) {
                request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_two"));
                this.processNext(requestDTO.getPid(), "\u6307\u6d3e\u4e8c\u7ebf");
            }
            if (requestDTO.getOptType().equals("requestAssginThree")) {
                request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_three"));
                this.processNext(requestDTO.getPid(), "\u6307\u6d3e\u4e09\u7ebf");
            }
            if (requestDTO.getOptType().equals("requestAssginFour")) {
                request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_four"));
                this.processNext(requestDTO.getPid(), "\u6307\u6d3e\u56db\u7ebf");
            }
        }
        this.requestDAO.merge((Object)request);
        noticeInfoDto.setNoticeRuleNo("notice_request_06");
        this.noticeRuleService.requestNotice(noticeInfoDto);
        noticeInfoDto.setNoticeRuleNo("notice_request_09");
        this.noticeRuleService.requestNotice(noticeInfoDto);
    }

    @Transactional
    public void requestApproval(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        if (requestDTO.getPid() != null && requestDTO.getApprovalResult() != null) {
            this.processNext(requestDTO.getPid(), requestDTO.getApprovalResult());
            if (requestDTO.getApprovalResult().equals("\u540c\u610f")) {
                request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_one"));
            } else {
                request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_close"));
                request.setResponsesTime(new Date());
                request.setRequestResolvedTime(new Date());
                request.setCloseTime(new Date());
            }
            request.setApprovalState("\u5df2\u5ba1\u6279");
        }
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestGet(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        if (requestDTO.getCurrentUser() != null) {
            if (requestDTO.getPid() != null) {
                this.assignTask(requestDTO.getPid(), requestDTO.getCurrentUser());
            }
            request.setAssignee((User)this.userDAO.findUniqueBy("loginName", (Object)requestDTO.getCurrentUser()));
        }
        this.requestDAO.merge((Object)request);
    }

    public void requestAgainAssgin(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        if (requestDTO.getAssigneeName() != null) {
            if (requestDTO.getPid() != null) {
                this.assignTask(requestDTO.getPid(), requestDTO.getCurrentUser());
            }
            request.setAssignee((User)this.userDAO.findUniqueBy("loginName", (Object)requestDTO.getCurrentUser()));
        }
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestBackGroup(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        request.setAssignee(null);
        if (requestDTO.getPid() != null) {
            this.assignTask(requestDTO.getPid(), null);
        }
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestBack(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        request.setAssignee(null);
        request.setAssigneeGroup(null);
        if (requestDTO.getPid() != null) {
            request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_one"));
            this.processNext(requestDTO.getPid(), "\u8bf7\u6c42\u9000\u56de");
        }
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestDealComplete(RequestDTO requestDTO) {
        User user;
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        if (requestDTO.getPid() != null) {
            this.processNext(requestDTO.getPid(), "\u5904\u7406\u5b8c\u6210");
        }
        if (requestDTO.getRequestResolvedUserNo() != null && (user = (User)this.userDAO.findById((Serializable)requestDTO.getRequestResolvedUserNo())) != null) {
            request.setRequestResolvedUser(user);
        }
        request.setRequestResolvedTime(new Date());
        request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_complete"));
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        noticeInfoDto.setNoticeRuleNo("notice_request_10");
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(requestDTO.getCreatedByName());
        noticeInfoDto.setLoginName(userList);
        noticeInfoDto.setEno(requestDTO.getEno());
        noticeInfoDto.setRequestCode(request.getRequestCode());
        this.noticeRuleService.requestNotice(noticeInfoDto);
        noticeInfoDto.setNoticeRuleNo("notice_request_11");
        this.noticeRuleService.requestNotice(noticeInfoDto);
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestClose(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        if (requestDTO.isFCR()) {
            request.setFCR(requestDTO.isFCR());
        }
        request.setCloseTime(requestDTO.getCloseTime());
        request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_close"));
        if (requestDTO.getPid() != null) {
            this.processNext(requestDTO.getPid(), "\u8bf7\u6c42\u5173\u95ed");
        }
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        noticeInfoDto.setNoticeRuleNo("notice_request_04");
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(requestDTO.getCreatedByName());
        noticeInfoDto.setLoginName(userList);
        noticeInfoDto.setEno(requestDTO.getEno());
        noticeInfoDto.setRequestCode(request.getRequestCode());
        this.noticeRuleService.requestNotice(noticeInfoDto);
        noticeInfoDto.setNoticeRuleNo("notice_request_08");
        this.noticeRuleService.requestNotice(noticeInfoDto);
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestUpgrade(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        request.setUpgradeApplySign(2L);
        if (requestDTO.getOwnerNo() != null) {
            User user = (User)this.userDAO.findById((Serializable)requestDTO.getOwnerNo());
            if (user != null) {
                request.setOwner(user);
            }
            NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
            noticeInfoDto.setRequestCode(request.getRequestCode());
            noticeInfoDto.setEno(request.getEno());
            noticeInfoDto.setNoticeRuleNo("notice_request_18");
            noticeInfoDto.setUserNo(requestDTO.getOwnerNo());
            this.noticeRuleService.requestNotice(noticeInfoDto);
            this.requestDAO.merge((Object)request);
        }
    }

    @Transactional
    public void requestReOpen(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_one"));
        request.setRequestResolvedTime(null);
        request.setRequestResolvedUser(null);
        request.setAssignee(null);
        request.setAssigneeGroup(null);
        if (requestDTO.getPid() != null) {
            this.processNext(requestDTO.getPid(), "\u91cd\u65b0\u5f00\u542f");
        }
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        noticeInfoDto.setRequestCode(request.getRequestCode());
        noticeInfoDto.setEno(request.getEno());
        noticeInfoDto.setNoticeRuleNo("notice_request_07");
        this.noticeRuleService.requestNotice(noticeInfoDto);
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void requestVisit(RequestDTO requestDTO) {
        Request request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
        if (requestDTO.getVisitState() != null && requestDTO.getVisitState() == 1L) {
            request.setVisitRecord(requestDTO.getVisitRecord());
        }
        if (requestDTO.getVisitState() != null && requestDTO.getVisitState() == 2L) {
            request.setVisitRecord("\u5df2\u901a\u8fc7\u90ae\u4ef6\u53d1\u9001\u56de\u8bbf\u8bbf\u95ee\u94fe\u63a5\u7ed9\u8bf7\u6c42\u7528\u6237!");
        }
        this.requestDAO.merge((Object)request);
    }

    @Transactional
    public void processNext(String pid, String toNext) {
        try {
            ProcessInstance pi = this.jbpmFacade.getInstanceById(pid);
            String nextActivityName = (String)this.jbpmFacade.getActivityNamesByInstance(pi).iterator().next();
            this.jbpmFacade.takeTask(pid, nextActivityName, "", toNext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void assignTask(String pid, String userName) {
        ProcessInstance pi = this.jbpmFacade.getInstanceById(pid);
        String nextActivityName = (String)this.jbpmFacade.getActivityNamesByInstance(pi).iterator().next();
        String taskId = this.jbpmFacade.getTaskId(pid, nextActivityName);
        this.jbpmFacade.assignTask(taskId, userName);
    }
}

