/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.request.service;

import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.compass.service.ICompassSearchService;
import com.sinba.common.config.category.dao.IEventCategoryDAO;
import com.sinba.common.config.category.entity.EventCategory;
import com.sinba.common.config.dictionary.dao.IDataDictionaryItemsDAO;
import com.sinba.common.config.dictionary.entity.DataDictionaryItems;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.jbpm.dao.IProcessUseDAO;
import com.sinba.common.jbpm.entity.ProcessUse;
import com.sinba.common.noticeRule.dto.NoticeInfoDTO;
import com.sinba.common.noticeRule.service.INoticeRuleService;
import com.sinba.common.rules.DroolsFacade;
import com.sinba.common.security.dao.HolidayDAO;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IOrganizationServicesDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dao.ServiceTimeDAO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.OrganizationServices;
import com.sinba.common.security.entity.ServiceTime;
import com.sinba.common.security.entity.User;
import com.sinba.common.sla.dao.ISLAContractDAO;
import com.sinba.common.sla.dao.ISLARuleDAO;
import com.sinba.common.sla.entity.SLAContract;
import com.sinba.common.sla.entity.SLARule;
import com.sinba.common.tools.dao.IEmailDAO;
import com.sinba.common.tools.dto.EventEavDTO;
import com.sinba.common.tools.dto.HistoryRecordDTO;
import com.sinba.common.tools.entity.EmailMessage;
import com.sinba.common.tools.service.IEventAttachmentService;
import com.sinba.common.tools.service.IEventEavService;
import com.sinba.common.tools.service.IHistoryRecordService;
import com.sinba.itsm.cim.dao.ICIDAO;
import com.sinba.itsm.cim.entity.CI;
import com.sinba.itsm.request.dao.IRequestDAO;
import com.sinba.itsm.request.dto.JbpmTaskVariablesEventDTO;
import com.sinba.itsm.request.dto.RequestCountResultDTO;
import com.sinba.itsm.request.dto.RequestDTO;
import com.sinba.itsm.request.dto.RequestDetailDTO;
import com.sinba.itsm.request.dto.RequestGridDTO;
import com.sinba.itsm.request.dto.RequestQueryDTO;
import com.sinba.itsm.request.dto.RequestSimpleDTO;
import com.sinba.itsm.request.entity.Request;
import com.sinba.itsm.request.service.IRequestActionService;
import com.sinba.itsm.request.service.IRequestService;
import com.sinba.itsm.request.utils.CalcPredictTimeUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.compass.core.CompassHit;
import org.compass.core.support.search.CompassSearchResults;
import org.drools.KnowledgeBase;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.AgendaFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestService
implements IRequestService {
    private DroolsFacade droolsFacade = new DroolsFacade();
    private CalcPredictTimeUtils calcPredictTimeUtils = new CalcPredictTimeUtils();
    @Autowired
    private JbpmFacade jbpmFacade;
    @Autowired
    private IRequestDAO requestDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IDataDictionaryItemsDAO dataDictionaryItemsDAO;
    @Autowired
    private ISLAContractDAO slaContractDAO;
    @Autowired
    private IOrganizationServicesDAO organizationServicesDAO;
    @Autowired
    private HolidayDAO holidayDAO;
    @Autowired
    private ServiceTimeDAO serviceTimeDAO;
    @Autowired
    private INoticeRuleService noticeRuleService;
    @Autowired
    private ISLARuleDAO slaRuleDAO;
    @Autowired
    private IProcessUseDAO processUseDAO;
    @Autowired
    private IEventCategoryDAO categoryDAO;
    @Autowired
    private ICIDAO ciDAO;
    @Autowired
    private IHistoryRecordService historyRecordService;
    @Autowired
    private IRequestActionService requestActionService;
    @Autowired
    private IEmailDAO emailDAO;
    @Autowired
    private IEventAttachmentService eventAttachmentService;
    @Autowired
    private IEventCategoryDAO eventCategoryDAO;
    @Autowired
    private IEventEavService eventEavService;
    private static String requestCode = "";
    @Autowired
    private ICompassSearchService compassSearchService;

    @Override
    @Transactional
    public PageDTO findRequestByPage(RequestQueryDTO qdto, String sidx, String sord) {
        if (qdto != null && qdto.getEcategoryNo() != null) {
            ArrayList<Long> longList = new ArrayList<Long>();
            this.findEventCategorys(qdto.getEcategoryNo(), longList);
            Long[] cnos = new Long[longList.size()];
            for (int i = 0; i < longList.size(); ++i) {
                cnos[i] = (Long)longList.get(i);
            }
            qdto.setCategoryNos(cnos);
        }
        if (qdto.getCurrentUser() != null && !qdto.getCurrentUser().equals("")) {
            User user = (User)this.userDAO.findUniqueBy("loginName", (Object)qdto.getCurrentUser());
            qdto.setOrgNo(user.getOrgnization().getOrgNo());
        }
        PageDTO p = this.requestDAO.findPager(qdto, sidx, sord);
        List entities = p.getData();
        ArrayList<RequestGridDTO> dtos = new ArrayList<RequestGridDTO>();
        for (Request req : entities) {
            RequestGridDTO dto = new RequestGridDTO();
            this.findRequestEntity2Dto(req, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    public void findEventCategorys(Long eventId, List<Long> longList) {
        EventCategory eventCategory = (EventCategory)this.eventCategoryDAO.findById((Serializable)eventId);
        longList.add(eventCategory.getEventId());
        if (eventCategory != null && eventCategory.getParentChildren() != null && eventCategory.getParentChildren().size() > 0) {
            for (EventCategory c : eventCategory.getParentChildren()) {
                longList.add(c.getEventId());
                this.findEventCategorys(c.getEventId(), longList);
            }
        }
    }

    @Transactional
    public void findRequestEntity2Dto(Request req, RequestGridDTO dto) {
        RequestGridDTO.entity2dto((Object)((Object)req), (Object)((Object)dto));
        if (req != null) {
            if (req.getPid() != null) {
                dto.setPid(req.getPid());
            }
            if (req.getCreatedBy() != null) {
                dto.setCreatedByName(req.getCreatedBy().getLoginName());
            }
            if (req.getAssigneeGroup() != null) {
                dto.setAssigneeGroupName(req.getAssigneeGroup().getOrgName());
                dto.setAssigneeGroupNo(req.getAssigneeGroup().getOrgNo());
            }
            if (req.getAssignee() != null) {
                dto.setAssigneeName(req.getAssignee().getLoginName());
            }
            if (req.getPriority() != null) {
                dto.setPriorityName(req.getPriority().getDname());
            }
            if (req.getOwner() != null) {
                dto.setOwnerName(req.getOwner().getLoginName());
                dto.setOwnerNo(req.getOwner().getUserId());
            }
            if (req.getStatus() != null) {
                dto.setStatusName(req.getStatus().getDname());
            }
            if (req.getCi() != null) {
                dto.setCiName(req.getCi().getCiname());
            }
            if (req.getRequestCategory() != null) {
                dto.setRequestCategoryName(req.getRequestCategory().getEventName());
            }
            if (req.getMaxResponseTime() != null) {
                dto.setSlaState(this.getSlaStatus(req));
            }
        }
    }

    @Override
    @Transactional
    public RequestDetailDTO findRequestById(Long id) {
        RequestDetailDTO dto = new RequestDetailDTO();
        Request req = (Request)((Object)this.requestDAO.findById(id));
        if (req != null) {
            this.findRequestEntity2Dto(req, dto);
        }
        return dto;
    }

    public void findRequestEntity2Dto(Request req, RequestDetailDTO dto) {
        GregorianCalendar offTime;
        SimpleDateFormat fmt;
        RequestDetailDTO.entity2dto((Object)((Object)req), (Object)((Object)dto));
        dto.setPid(req.getPid());
        if (req.getStatus() != null) {
            dto.setStatusNo(req.getStatus().getDcode());
            dto.setStatusName(req.getStatus().getDname());
            dto.setStatusCode(req.getStatus().getDno());
        }
        if (req.getEffectRange() != null) {
            dto.setEffectRangeNo(req.getEffectRange().getDcode());
            dto.setEffectRangeName(req.getEffectRange().getDname());
        }
        if (req.getSeriousness() != null) {
            dto.setSeriousnessNo(req.getSeriousness().getDcode());
            dto.setSeriousnessName(req.getSeriousness().getDname());
        }
        if (req.getPriority() != null) {
            dto.setPriorityNo(req.getPriority().getDcode());
            dto.setPriorityName(req.getPriority().getDname());
        }
        if (req.getImode() != null) {
            dto.setImodeNo(req.getImode().getDcode());
            dto.setImodeName(req.getImode().getDname());
        }
        if (req.getLevel() != null) {
            dto.setLevelNo(req.getLevel().getDcode());
            dto.setLevelName(req.getLevel().getDname());
        }
        if (req.getCreatedBy() != null) {
            dto.setCreatedByName(req.getCreatedBy().getLoginName());
            dto.setCreatedByNo(req.getCreatedBy().getUserId());
            dto.setCreatedByPhone(req.getCreatedBy().getMoblie());
            dto.setCreatedByEmail(req.getCreatedBy().getEmail());
        }
        if (req.getAssigneeGroup() != null) {
            dto.setAssigneeGroupNo(req.getAssigneeGroup().getOrgNo());
            dto.setAssigneeGroupName(req.getAssigneeGroup().getOrgName());
        }
        if (req.getAssignee() != null) {
            dto.setAssigneeNo(req.getAssignee().getUserId());
            dto.setAssigneeName(req.getAssignee().getLoginName());
        }
        if (req.getCi() != null) {
            dto.setCiId(req.getCi().getCiId());
            dto.setCiName(req.getCi().getCiname());
        }
        if (req.getRequestCategory() != null) {
            dto.setRequestCategoryNo(req.getRequestCategory().getEventId());
            dto.setRequestCategoryName(req.getRequestCategory().getEventName());
        }
        if (req.getMaxResponseTime() != null) {
            fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            offTime = new GregorianCalendar();
            offTime.setTimeInMillis(req.getMaxResponseTime());
            dto.setMaxResponsesTime(fmt.format(offTime.getTime()));
        }
        if (req.getMaxCompleteTime() != null) {
            fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            offTime = new GregorianCalendar();
            offTime.setTimeInMillis(req.getMaxCompleteTime());
            dto.setMaxCompletesTime(fmt.format(offTime.getTime()));
        }
        if (req.getOwner() != null) {
            dto.setOwnerName(req.getOwner().getLoginName());
        }
    }

    @Override
    @Transactional
    public Long saveRequest(RequestDTO dto) throws NullPointerException {
        EmailMessage emailMessage;
        User users;
        Request request = new Request();
        if (dto.getCreatedByName() != null && dto.getCreatedByNo() == null && (users = (User)this.userDAO.findUniqueBy("loginName", (Object)dto.getCreatedByName())) != null) {
            dto.setCreatedByNo(users.getUserId());
        }
        this.requestFitServiceOrg(dto);
        if (dto.getServicesNo() != null) {
            this.requestFitRuleName(dto);
            this.calcRequestSLATime(dto);
        }
        this.addRequestDTO2Entity(dto, request);
        request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_new"));
        this.requestDAO.save((Object)request);
        if (dto.getAttrVals() != null) {
            EventEavDTO eventEavDto = new EventEavDTO();
            eventEavDto.setEno(request.getEno());
            eventEavDto.setEventType("itsm.request");
            eventEavDto.setAttrVals(dto.getAttrVals());
            this.eventEavService.saveEventEav(eventEavDto);
        }
        if (dto.getAttachmentStr() != null) {
            this.eventAttachmentService.saveEventAttachment(dto.getAttachmentStr(), request.getEno(), "itsm.request");
        }
        if (dto.getEmailMessage() != null && (emailMessage = (EmailMessage)this.emailDAO.findById((Serializable)dto.getEmailMessage())) != null) {
            emailMessage.setToRequest(true);
            emailMessage.setKeyword(request.getRequestCode());
            this.emailDAO.merge((Object)emailMessage);
        }
        this.startRequestProcess(request, dto);
        HistoryRecordDTO historyRecordDto = new HistoryRecordDTO();
        historyRecordDto.setEno(request.getEno());
        historyRecordDto.setEventType("itsm.request");
        historyRecordDto.setCreatedTime(new java.util.Date());
        historyRecordDto.setOperator(dto.getCreatedByName());
        historyRecordDto.setLogTitle("Request Create");
        this.historyRecordService.saveHistoryRecord(historyRecordDto);
        this.addRequestNotice(request, dto);
        return request.getEno();
    }

    @Override
    @Transactional
    public void updateRequest(RequestDTO dto) {
        User user;
        Request request = (Request)((Object)this.requestDAO.findById(dto.getEno()));
        this.dto2entity(dto, request);
        request.setSolutions(dto.getSolutions());
        if (dto.getStatusNo() != null) {
            request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getStatusNo()));
        } else {
            request.setStatus(null);
        }
        if (dto.getCreatedByNo() != null && (user = (User)this.userDAO.findById((Serializable)dto.getCreatedByNo())) != null) {
            request.setCreatedBy(user);
        }
        HistoryRecordDTO historyRecordDto = new HistoryRecordDTO();
        historyRecordDto.setEno(request.getEno());
        historyRecordDto.setEventType("itsm.request");
        historyRecordDto.setCreatedTime(new java.util.Date());
        historyRecordDto.setOperator(dto.getCreatedByName());
        historyRecordDto.setLogTitle("Request Update");
        this.historyRecordService.saveHistoryRecord(historyRecordDto);
        this.requestDAO.merge((Object)request);
        if (dto.getAttrVals() != null) {
            EventEavDTO eventEavDto = new EventEavDTO();
            eventEavDto.setEno(request.getEno());
            eventEavDto.setEventType("itsm.request");
            eventEavDto.setAttrVals(dto.getAttrVals());
            this.eventEavService.editEventEav(eventEavDto);
        }
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        noticeInfoDto.setNoticeRuleNo("notice_request_03");
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(dto.getCreatedByName());
        noticeInfoDto.setLoginName(userList);
        noticeInfoDto.setEno(request.getEno());
        noticeInfoDto.setRequestCode(request.getRequestCode());
        this.noticeRuleService.requestNotice(noticeInfoDto);
    }

    @Override
    @Transactional
    public void deleteRequests(Long[] ids) {
        this.requestDAO.deleteByIds(ids);
    }

    @Override
    @Transactional
    public RequestCountResultDTO countRequest(RequestQueryDTO qdto) {
        if (qdto.getLoginName() != null) {
            User user = (User)this.userDAO.findUniqueBy("loginName", (Object)qdto.getLoginName());
            qdto.setOrgNo(user.getOrgnization().getOrgNo());
        }
        RequestCountResultDTO rcrd = this.requestDAO.countRequest(qdto);
        if (qdto.getLoginName() != null) {
            rcrd.setCountMyRequestTask(this.jbpmFacade.findTaskDtos(qdto.getLoginName(), 0, 10).getTotalSize());
            rcrd.setCountMyGroupRequestTask(this.jbpmFacade.findGroupTaskDtos(qdto.getLoginName(), 0, 10).getTotalSize());
        }
        return rcrd;
    }

    public void dto2entity(RequestDTO dto, Request request) {
        Organization inner;
        User assignee;
        CI ci;
        EventCategory eventCategory;
        request.setPid(dto.getPid());
        request.setEtitle(dto.getEtitle());
        request.setEdesc(dto.getEdesc());
        request.setAddress(dto.getAddress());
        request.setRequestCode(dto.getRequestCode());
        request.setEffectRemark(dto.getEffectRemark());
        if (dto.getEffectRangeNo() != null) {
            request.setEffectRange((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getEffectRangeNo()));
        }
        if (dto.getSeriousnessNo() != null) {
            request.setSeriousness((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getSeriousnessNo()));
        }
        if (dto.getPriorityNo() != null) {
            request.setPriority((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getPriorityNo()));
        }
        if (dto.getImodeNo() != null) {
            request.setImode((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getImodeNo()));
        }
        if (dto.getLevelNo() != null) {
            request.setLevel((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getLevelNo()));
        }
        if (dto.getRequestCategoryNo() != null && (eventCategory = (EventCategory)this.categoryDAO.findById((Serializable)dto.getRequestCategoryNo())) != null) {
            request.setRequestCategory(eventCategory);
        }
        if (dto.getCiId() != null && (ci = (CI)this.ciDAO.findById((Serializable)dto.getCiId())) != null) {
            request.setCi(ci);
        }
        if (dto.getAssigneeNo() != null && (assignee = (User)this.userDAO.findById((Serializable)dto.getAssigneeNo())) != null) {
            request.setAssignee(assignee);
        }
        if (dto.getAssigneeGroupNo() != null && (inner = (Organization)this.organizationDAO.findById((Serializable)dto.getAssigneeGroupNo())) != null) {
            request.setAssigneeGroup(inner);
        }
    }

    @Override
    @Transactional
    public List<RequestSimpleDTO> findRequestPortal(RequestQueryDTO qdto) {
        List<Request> requests = this.requestDAO.findRequestPortal(qdto);
        if (requests != null && requests.size() > 0) {
            ArrayList<RequestSimpleDTO> rsdto = new ArrayList<RequestSimpleDTO>();
            for (Request rq : requests) {
                RequestSimpleDTO dto = new RequestSimpleDTO();
                dto.setEno(rq.getEno());
                dto.setEtitle(rq.getEtitle());
                if (rq.getCreatedBy() != null) {
                    dto.setCreatedByName(rq.getCreatedBy().getLoginName());
                }
                rsdto.add(dto);
            }
            return rsdto;
        }
        return null;
    }

    @Transactional
    public void addRequestNotice(Request request, RequestDTO dto) {
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(dto.getCreatedByName());
        noticeInfoDto.setLoginName(userList);
        noticeInfoDto.setEno(request.getEno());
        noticeInfoDto.setRequestCode(request.getRequestCode());
        noticeInfoDto.setNoticeRuleNo("notice_request_01");
        this.noticeRuleService.requestNotice(noticeInfoDto);
        noticeInfoDto.setNoticeRuleNo("notice_request_02");
        this.noticeRuleService.requestNotice(noticeInfoDto);
        noticeInfoDto.setNoticeRuleNo("notice_request_05");
        this.noticeRuleService.requestNotice(noticeInfoDto);
    }

    @Transactional
    public void requestFitServiceOrg(RequestDTO dto) throws NullPointerException {
        List sers;
        KnowledgeBase kbase = this.droolsFacade.getKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)dto);
        String rulePackageName = "com.drools.drl.requestfitservices";
        ksession.fireAllRules((AgendaFilter)new RequestRuleFilter(rulePackageName));
        ksession.dispose();
        if (dto.getServicesNo() == 0L && (sers = this.organizationServicesDAO.findBy("orgName", (Object)"Helpdesk")) != null && sers.size() > 0) {
            dto.setServicesNo(((OrganizationServices)sers.get(0)).getOrgNo());
        }
    }

    @Transactional
    public void requestFitRuleName(RequestDTO dto) {
        try {
            Long userOrgNo = ((User)this.userDAO.findById((Serializable)dto.getCreatedByNo())).getOrgnization().getOrgNo();
            SLAContract sc = this.slaContractDAO.findByServicesNo(dto.getServicesNo(), userOrgNo);
            String rulePackageName = sc.getRulePackage().getPackageName();
            KnowledgeBase kbase = this.droolsFacade.getKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            ksession.insert((Object)dto);
            ksession.fireAllRules((AgendaFilter)new RequestRuleFilter(rulePackageName));
            ksession.dispose();
            dto.setSlaNo(sc.getContractNo());
        }
        catch (Exception ex) {
            throw new ApplicationException("ERROR_FITSLA_BY_SERVICERS_AND_BYSERVICES\n" + ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calcRequestSLATime(RequestDTO dto) {
        SLARule slaRule = (SLARule)this.slaRuleDAO.findUniqueBy("ruleName", (Object)dto.getMatchRuleName());
        if (slaRule == null) throw new ApplicationException("ERROR_SLA_RULENAME_IS_NULL");
        dto.setResponseTime((long)slaRule.getRespondTime() * 1000L);
        dto.setCompleteTime((long)slaRule.getFinishTime() * 1000L);
        dto.setCreateTime(new java.util.Date().getTime());
        if (slaRule.getIncludeHoliday().booleanValue()) {
            dto.setMaxResponseTime(dto.getCreateTime() + dto.getResponseTime());
            dto.setMaxCompleteTime(dto.getCreateTime() + dto.getCompleteTime());
            return;
        } else {
            List holidays = this.holidayDAO.findHolidayByServicesNo(dto.getServicesNo());
            ServiceTime serviceTime = this.serviceTimeDAO.findByOrgNo(dto.getServicesNo());
            if (serviceTime == null) throw new ApplicationException("ERROR_SLA_SERVICETIME_IS_NULL");
            List<java.util.Date> offDays = this.calcPredictTimeUtils.getOffDays(serviceTime, holidays);
            Long trueResponseTime = this.calcPredictTimeUtils.calcPredictTime(dto.getResponseTime(), new java.util.Date().getTime(), offDays, serviceTime);
            Long trueCompleteTime = this.calcPredictTimeUtils.calcPredictTime(dto.getCompleteTime(), new java.util.Date().getTime(), offDays, serviceTime);
            dto.setMaxResponseTime(trueResponseTime);
            dto.setMaxCompleteTime(trueCompleteTime);
        }
    }

    public void addRequestDTO2Entity(RequestDTO dto, Request request) {
        User user;
        this.dto2entity(dto, request);
        request.setMaxResponseTime(dto.getMaxResponseTime());
        request.setMaxCompleteTime(dto.getMaxCompleteTime());
        if (dto.getApprovalNo() != 0L && (user = (User)this.userDAO.findById((Serializable)dto.getApprovalNo())) != null) {
            dto.setApprovalName(user.getLoginName());
        }
        if (dto.getCompleteTime() != null) {
            request.setMaxCompleteTimeBack(dto.getCompleteTime());
        }
        if (dto.getServicesNo() != null) {
            request.setServicesOrg((OrganizationServices)this.organizationServicesDAO.findById((Serializable)dto.getServicesNo()));
        }
        if (dto.getSlaNo() != null) {
            request.setSlaContract((SLAContract)this.slaContractDAO.findById((Serializable)dto.getSlaNo()));
        }
        if (dto.getApprovalNo() != 0L) {
            request.setApprovalState("\u5f85\u5ba1\u6279");
            request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_approval"));
        } else {
            request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_one"));
        }
        if (dto.getCreatedByNo() != null) {
            user = (User)this.userDAO.findById((Serializable)dto.getCreatedByNo());
            if (user != null) {
                request.setCreatedBy(user);
            }
        } else if (dto.getCreatedByName() != null && (user = (User)this.userDAO.findUniqueBy("loginName", (Object)dto.getCreatedByName())) != null) {
            request.setCreatedBy(user);
        }
        request.setCreatedOn(new Date(new java.util.Date().getTime()));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String today = fmt.format(new java.util.Date());
        requestCode = "Ref-" + today + this.requestDAO.dayRequestCoun();
        request.setRequestCode("Ref-" + today + this.requestDAO.dayRequestCoun());
    }

    public void startRequestProcess(Request request, RequestDTO dto) {
        ProcessUse pree = (ProcessUse)this.processUseDAO.findUniqueBy("useName", (Object)"\u8bf7\u6c42\u6d41\u7a0b");
        JbpmTaskVariablesEventDTO jbpmTaskVariablesEventDTO = new JbpmTaskVariablesEventDTO();
        if (pree.getProcessKey() != null) {
            jbpmTaskVariablesEventDTO.setEno(request.getEno());
            jbpmTaskVariablesEventDTO.setEcode(request.getRequestCode());
            jbpmTaskVariablesEventDTO.setEtitle(request.getEtitle());
            jbpmTaskVariablesEventDTO.setApprovalNo(dto.getApprovalNo());
            jbpmTaskVariablesEventDTO.setApprovalName(dto.getApprovalName());
            HashMap<String, JbpmTaskVariablesEventDTO> variables = new HashMap<String, JbpmTaskVariablesEventDTO>();
            variables.put("dto", jbpmTaskVariablesEventDTO);
            String pid = this.jbpmFacade.startProcessAndNext(pree.getProcessKey(), variables);
            request.setPid(pid);
        }
    }

    @Override
    @Transactional
    public void saveSolutions(RequestDTO dto) {
        Request request = (Request)((Object)this.requestDAO.findById(dto.getEno()));
        request.setSolutions(dto.getSolutions());
        this.requestDAO.save((Object)request);
    }

    @Override
    @Transactional
    public void requestAction(RequestDTO requestDTO, HistoryRecordDTO hrDTO) {
        Request request;
        String optType = requestDTO.getOptType();
        if ("requestDeal".equals(optType)) {
            request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
            request.setResponsesTime(new java.util.Date());
            request.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"request_one"));
        }
        if ("requestAssgin".equals(optType) || "requestAssginTwo".equals(optType) || "requestAssginThree".equals(optType) || "requestAssginFour".equals(optType)) {
            this.requestActionService.requestAssgin(requestDTO);
        }
        if ("requestApproval".equals(optType)) {
            this.requestActionService.requestApproval(requestDTO);
        }
        if ("requestGet".equals(optType)) {
            this.requestActionService.requestGet(requestDTO);
        }
        if ("requestBackGroup".equals(optType)) {
            this.requestActionService.requestBackGroup(requestDTO);
        }
        if ("requestBack".equals(optType)) {
            this.requestActionService.requestBack(requestDTO);
        }
        if ("requestDealComplete".equals(optType)) {
            this.requestActionService.requestDealComplete(requestDTO);
        }
        if ("requestClose".equals(optType)) {
            this.requestActionService.requestClose(requestDTO);
        }
        if ("requestReOpen".equals(optType)) {
            this.requestActionService.requestReOpen(requestDTO);
        }
        if ("requestUpgradeApply".equals(optType)) {
            request = (Request)((Object)this.requestDAO.findById(requestDTO.getEno()));
            request.setUpgradeApplySign(1L);
            this.requestDAO.merge((Object)request);
        }
        if ("requestUpgrade".equals(optType)) {
            this.requestActionService.requestUpgrade(requestDTO);
        }
        if ("requestVisit".equals(optType)) {
            this.requestActionService.requestVisit(requestDTO);
        }
        if ("requestAgainAssgin".equals(optType)) {
            this.requestActionService.requestAssgin(requestDTO);
        }
        this.saveHistoryRecord(requestDTO.getEno(), hrDTO);
    }

    @Transactional
    public void saveHistoryRecord(Long eno, HistoryRecordDTO historyRecordDTO) {
        historyRecordDTO.setCreatedTime(new java.util.Date());
        historyRecordDTO.setEno(eno);
        historyRecordDTO.setEventType("itsm.request");
        this.historyRecordService.saveHistoryRecord(historyRecordDTO);
    }

    @Override
    public Set<String> getOutcomes(String pid) {
        Set outcomes = this.jbpmFacade.getOutcomes(pid);
        return outcomes;
    }

    @Override
    @Transactional
    public InputStream exportRequestItems(RequestQueryDTO requestQueryDTO, String sidx, String sord) {
        String sheetName = "\u6240\u6709\u8bf7\u6c42";
        String[] colNames = new String[]{"\u7f16\u53f7", "\u6807\u9898", "\u5206\u7c7b", "\u8bf7\u6c42\u4eba", "\u8d1f\u8d23\u4eba", "\u6307\u6d3e\u5230\u7ec4", "\u6307\u6d3e\u5230\u6280\u672f\u5458", "\u4f18\u5148\u7ea7", "\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4", "\u5173\u8054\u914d\u7f6e\u9879", "\u89e3\u51b3\u65b9\u6848", "SLA\u72b6\u6001"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        PageDTO p = this.requestDAO.findPager(requestQueryDTO, sidx, sord);
        if (p != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            for (Request item : entities) {
                this.convertChangeToStringArray(item, data);
            }
            try {
                return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
            }
            catch (Exception e) {
                throw new ApplicationException("Excel File not found:" + e);
            }
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    public void convertChangeToStringArray(Request item, List<String[]> data) {
        String category = "";
        String createdBy = "";
        String owner = "";
        String assigneeGroup = "";
        String assignee = "";
        String priority = "";
        String status = "";
        String createTime = "";
        String ci = "";
        if (item.getRequestCategory() != null) {
            category = item.getRequestCategory().getEventName();
        }
        if (item.getCreatedBy() != null) {
            createdBy = item.getCreatedBy().getLoginName();
        }
        if (item.getOwner() != null) {
            owner = item.getOwner().getLoginName();
        }
        if (item.getAssigneeGroup() != null) {
            assigneeGroup = item.getAssigneeGroup().getOrgName();
        }
        if (item.getAssignee() != null) {
            assignee = item.getAssignee().getLoginName();
        }
        if (item.getPriority() != null) {
            priority = item.getPriority().getDname();
        }
        if (item.getStatus() != null) {
            status = item.getStatus().getDname();
        }
        if (item.getCreatedOn() != null) {
            createTime = RequestService.dateToStr(item.getCreatedOn());
        }
        if (item.getCi() != null) {
            ci = item.getCi().getCiname();
        }
        data.add(new String[]{item.getRequestCode(), item.getEtitle(), category, createdBy, owner, assigneeGroup, assignee, priority, status, createTime, ci, item.getSolutions(), this.getSlaStatus(item)});
    }

    public String getSlaStatus(Request req) {
        if (req.getMaxResponseTime() != null) {
            Long currentTime = new java.util.Date().getTime();
            if (req.getResponsesTime() != null) {
                if (currentTime >= req.getResponsesTime().getTime()) {
                    return "\u6b63\u5728\u5904\u7406";
                }
            } else {
                if (currentTime < req.getMaxResponseTime()) {
                    return "\u7b49\u5f85\u54cd\u5e94";
                }
                return "\u8d85\u65f6\u672a\u54cd\u5e94";
            }
            if (req.getRequestResolvedTime() != null && req.getMaxCompleteTime() != null) {
                if (req.getRequestResolvedTime().getTime() > req.getMaxCompleteTime()) {
                    return "\u8d85\u65f6\u672a\u5b8c\u6210";
                }
                return "\u5904\u7406\u6210\u529f";
            }
            if (currentTime >= req.getMaxCompleteTime()) {
                return "\u8d85\u65f6\u672a\u5b8c\u6210";
            }
        }
        return "";
    }

    @Override
    @Transactional
    public PageDTO fullSearch(CompassQueryDTO compassQueryDTO, int page, int rows) {
        CompassSearchResults csr = this.compassSearchService.doSearch(compassQueryDTO, page, rows);
        PageDTO requests = new PageDTO();
        requests.setPage(page);
        requests.setRows(rows);
        requests.setTotalSize(csr.getTotalHits());
        ArrayList<RequestGridDTO> data = new ArrayList<RequestGridDTO>();
        CompassHit[] hit = csr.getHits();
        for (int i = 0; i < hit.length; ++i) {
            Request entity = (Request)((Object)hit[i].data());
            Request req = (Request)((Object)this.requestDAO.findById(entity.getEno()));
            if (req == null) continue;
            RequestGridDTO dto = new RequestGridDTO();
            this.findRequestEntity2Dto(req, dto);
            data.add(dto);
        }
        requests.setData(data);
        return requests;
    }

    public static String dateToStr(java.util.Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = format.format(date);
        return str;
    }

    static class RequestRuleFilter
    implements AgendaFilter {
        private String rulePackageName = "";

        public RequestRuleFilter(String rulePackageName) {
            this.rulePackageName = rulePackageName;
        }

        public boolean accept(Activation activation) {
            return activation.getRule().getPackageName().trim().equals(this.rulePackageName);
        }
    }
}

