/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.request.utils;

import com.sinba.common.security.entity.Holiday;
import com.sinba.common.security.entity.ServiceTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalcPredictTimeUtils {
    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Long getTimeOfDay(Date theDate) {
        GregorianCalendar theDateCl = new GregorianCalendar();
        theDateCl.setTime(theDate);
        return (long)theDateCl.get(11) * 3600000L + (long)theDateCl.get(12) * 60000L;
    }

    public Long calcPredictTime(Long slaRawTime, Long createdTime, List<Date> holidays, ServiceTime serviceTime) {
        Long finalTime;
        if (holidays != null && holidays.size() > 0) {
            Collections.sort(holidays);
        }
        Long predictTime = 0L;
        Long realStartServiceTime = 0L;
        GregorianCalendar clCreateTime = new GregorianCalendar();
        clCreateTime.setTimeInMillis(createdTime);
        Long timeOfDay_createdTime = this.getTimeOfDay(new Date(createdTime));
        if (holidays != null && serviceTime != null && serviceTime.getStartTime() != null && serviceTime.getEndTime() != null && (this.isHoliday(clCreateTime.getTime(), holidays) || timeOfDay_createdTime > serviceTime.getEndTime())) {
            GregorianCalendar c1 = new GregorianCalendar(clCreateTime.get(1), clCreateTime.get(2), clCreateTime.get(5) + 1, serviceTime.getStartHour(), serviceTime.getStartMinute(), 0);
            realStartServiceTime = c1.getTimeInMillis();
        } else if (timeOfDay_createdTime < serviceTime.getStartTime()) {
            GregorianCalendar c1r = new GregorianCalendar(clCreateTime.get(1), clCreateTime.get(2), clCreateTime.get(5), 0, 0, 0);
            realStartServiceTime = c1r.getTimeInMillis() + serviceTime.getStartTime();
        } else {
            realStartServiceTime = clCreateTime.getTimeInMillis();
        }
        GregorianCalendar realStartCl = new GregorianCalendar();
        realStartCl.setTimeInMillis(realStartServiceTime);
        Long workTimes = serviceTime.getEndTime() - serviceTime.getStartTime();
        GregorianCalendar offTime = new GregorianCalendar(realStartCl.get(1), realStartCl.get(2), realStartCl.get(5), serviceTime.getEndHour(), serviceTime.getEndMinute(), 0);
        Long leftTime = serviceTime.getStartTime() + (86400000L - serviceTime.getEndTime());
        if (realStartCl.getTimeInMillis() + slaRawTime < offTime.getTimeInMillis()) {
            predictTime = predictTime + slaRawTime;
        } else {
            if (slaRawTime > workTimes - timeOfDay_createdTime) {
                predictTime = predictTime + leftTime;
            }
            Long slaDays = slaRawTime / workTimes;
            Long slaTimes = slaRawTime % workTimes;
            if (slaDays > 0L) {
                predictTime = slaDays * 86400000L;
            }
            if (slaTimes > 0L) {
                predictTime = predictTime + slaTimes;
            }
            for (Date holiday : holidays) {
                if (holiday.getTime() < realStartServiceTime || holiday.getTime() > predictTime + realStartServiceTime) continue;
                predictTime = predictTime + 86400000L;
            }
        }
        if (this.isHoliday(new Date(predictTime + realStartServiceTime), holidays)) {
            predictTime = predictTime + 86400000L;
        }
        if ((finalTime = this.getTimeOfDay(new Date(predictTime + realStartServiceTime))) > serviceTime.getEndTime() && this.isHoliday(new Date((predictTime = Long.valueOf(predictTime + leftTime)) + realStartServiceTime), holidays)) {
            predictTime = predictTime + 86400000L;
        }
        return predictTime + realStartServiceTime;
    }

    public boolean isHoliday(Date theDate, List<Date> holidays) {
        GregorianCalendar theDateCl = new GregorianCalendar();
        theDateCl.setTime(theDate);
        if (holidays != null && holidays.size() > 0) {
            for (Date holiday : holidays) {
                GregorianCalendar holidayCl = new GregorianCalendar();
                holidayCl.setTime(holiday);
                if (holidayCl.get(1) != theDateCl.get(1) || holidayCl.get(2) != theDateCl.get(2) || holidayCl.get(5) != theDateCl.get(5)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Date> getOffDays(ServiceTime serviceTime, List<Holiday> holidays) {
        ArrayList<Integer> rawOffDays = null;
        if (serviceTime != null) {
            rawOffDays = new ArrayList<Integer>();
            if (!serviceTime.getMonday().booleanValue()) {
                rawOffDays.add(2);
            }
            if (!serviceTime.getTuesday().booleanValue()) {
                rawOffDays.add(3);
            }
            if (!serviceTime.getWednesday().booleanValue()) {
                rawOffDays.add(4);
            }
            if (!serviceTime.getThursday().booleanValue()) {
                rawOffDays.add(5);
            }
            if (!serviceTime.getFriday().booleanValue()) {
                rawOffDays.add(6);
            }
            if (!serviceTime.getSaturday().booleanValue()) {
                rawOffDays.add(7);
            }
            if (!serviceTime.getSunday().booleanValue()) {
                rawOffDays.add(1);
            }
        }
        ArrayList<Date> offDays = null;
        if (rawOffDays != null) {
            offDays = new ArrayList<Date>();
            for (Integer offday : rawOffDays) {
                GregorianCalendar c = new GregorianCalendar();
                for (int i = 0; i < 2; ++i) {
                    Long nextWeek = (long)i * 604800000L;
                    c.setTime(new Date(new Date().getTime() + nextWeek));
                    c.set(7, offday);
                    c.set(10, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    if (offDays.contains(c.getTime())) continue;
                    offDays.add(c.getTime());
                }
            }
        }
        if (holidays != null && holidays.size() > 0) {
            for (Holiday hd : holidays) {
                offDays.add(hd.getHdate());
            }
        }
        return offDays;
    }
}

