/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.jbpm;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.jbpm.dto.ProcessDefinitionDTO;
import com.sinba.common.jbpm.dto.ProcessHistoriesDTO;
import com.sinba.common.jbpm.dto.ProcessHistoriesQueryDTO;
import com.sinba.common.jbpm.dto.ProcessInstanceDTO;
import com.sinba.common.jbpm.dto.TaskDTO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.IdentityService;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.TaskService;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.history.HistoryProcessInstanceQuery;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.api.model.ActivityCoordinates;
import org.jbpm.api.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmFacade {
    @Autowired
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected ExecutionService executionService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    public void setProcessEngine(ProcessEngine pe) {
        this.processEngine = pe;
        this.init();
    }

    protected void init() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.executionService = this.processEngine.getExecutionService();
        this.historyService = this.processEngine.getHistoryService();
        this.managementService = this.processEngine.getManagementService();
        this.taskService = this.processEngine.getTaskService();
        this.identityService = this.processEngine.getIdentityService();
    }

    public String deployJpdl(InputStream fis) {
        String deploymentId = this.repositoryService.createDeployment().addResourcesFromZipInputStream(new ZipInputStream(fis)).deploy();
        return deploymentId;
    }

    public String deployJpdl(File file) {
        String deploymentId = null;
        try {
            deploymentId = this.deployJpdl(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return deploymentId;
    }

    public void undeployJpdl(String deploymentId) {
        this.repositoryService.deleteDeploymentCascade(deploymentId);
    }

    public void undeployJpdlById(String pid) {
        ProcessDefinition pd = this.getDefinitionById(pid);
        if (pd != null) {
            this.repositoryService.deleteDeploymentCascade(pd.getDeploymentId());
        }
    }

    public List<ProcessDefinition> findLatestProcessDefinitions() {
        List<ProcessDefinition> processDefinitions = this.findAllProcessDefinitions();
        LinkedHashMap<String, ProcessDefinition> map = new LinkedHashMap<String, ProcessDefinition>();
        for (ProcessDefinition pd : processDefinitions) {
            String key = pd.getKey();
            ProcessDefinition definition = (ProcessDefinition)map.get(key);
            if (definition != null && definition.getVersion() >= pd.getVersion()) continue;
            map.put(key, pd);
        }
        return new ArrayList<ProcessDefinition>(map.values());
    }

    public PageDTO findLatestProcessDefinitions(int start, int limit) {
        ProcessDefinitionQuery pdQuery = this.repositoryService.createProcessDefinitionQuery();
        int totalSize = (int)pdQuery.count();
        pdQuery = pdQuery.orderAsc("idProperty.objectName").page(start, limit);
        List processDefinitions = pdQuery.list();
        LinkedHashMap<String, ProcessDefinition> map = new LinkedHashMap<String, ProcessDefinition>();
        ArrayList<ProcessDefinitionDTO> dtos = new ArrayList<ProcessDefinitionDTO>(processDefinitions.size());
        for (ProcessDefinition pd : processDefinitions) {
            ProcessDefinitionDTO pdto = this.processDefinition2Dto(pd);
            String key = pd.getKey();
            ProcessDefinition definition = (ProcessDefinition)map.get(key);
            if (definition == null || definition.getVersion() < pd.getVersion()) {
                map.put(key, pd);
            }
            dtos.add(pdto);
        }
        PageDTO page = new PageDTO();
        page.setTotalSize(totalSize);
        page.setData(dtos);
        return page;
    }

    public ProcessDefinitionDTO processDefinition2Dto(ProcessDefinition entity) {
        ProcessDefinitionDTO dto = new ProcessDefinitionDTO();
        dto.setId(entity.getId());
        dto.setKey(entity.getKey());
        dto.setName(entity.getName());
        dto.setDescription(entity.getDeploymentId());
        dto.setVersion(entity.getVersion());
        dto.setDeploymentId(entity.getDeploymentId());
        dto.setImageResourceName(entity.getImageResourceName());
        return dto;
    }

    public InputStream getProcessImage(String processId) {
        ProcessDefinition processDefinition = this.getDefinitionById(processId);
        return this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getImageResourceName());
    }

    public List<ProcessInstance> findInstancesByProcessId(String pid) {
        ProcessInstanceQuery query = this.executionService.createProcessInstanceQuery();
        if (StringUtils.hasText((String)pid)) {
            query.processDefinitionId(pid);
        }
        return query.list();
    }

    public PageDTO findInstances(String pid, int start, int limit) {
        if (!StringUtils.hasText((String)pid)) {
            return null;
        }
        ProcessInstanceQuery query = this.executionService.createProcessInstanceQuery();
        query.processDefinitionId(pid);
        int totalSize = (int)query.count();
        List data = query.page(start, limit).list();
        PageDTO p = new PageDTO();
        p.setTotalSize(totalSize);
        ArrayList<ProcessInstanceDTO> dtos = new ArrayList<ProcessInstanceDTO>(data.size());
        for (ProcessInstance entity : data) {
            ProcessInstanceDTO adto = this.processInstance2Dto(entity);
            dtos.add(adto);
        }
        p.setData(dtos);
        return p;
    }

    public ProcessInstanceDTO processInstance2Dto(ProcessInstance entity) {
        ProcessInstanceDTO dto = new ProcessInstanceDTO();
        dto.setId(entity.getId());
        dto.setKey(entity.getKey());
        dto.setPriority(entity.getPriority());
        dto.setProcessDefinitionId(entity.getProcessDefinitionId());
        dto.setState(entity.getState());
        return dto;
    }

    public ProcessInstance getInstanceById(String instanceId) {
        return this.executionService.findProcessInstanceById(instanceId);
    }

    public ProcessInstance startProcessByKey(String key, Map<String, Object> variables) {
        ProcessInstance pi = this.executionService.startProcessInstanceByKey(key, variables);
        return pi;
    }

    public String startProcessAndNext(String key, Map<String, Object> variables) {
        ProcessInstance pi = this.startProcessByKey(key, variables);
        this.signalNextExecution(pi);
        return pi.getId();
    }

    public void signalNextExecution(ProcessInstance pi) {
        String nextActivityName = this.getActivityNamesByInstance(pi).iterator().next();
        Execution nextExecution = pi.findActiveExecutionIn(nextActivityName);
        pi = this.executionService.signalExecutionById(nextExecution.getId());
    }

    public Set<String> getActivityNamesByInstance(ProcessInstance processInstance) {
        return processInstance.findActiveActivityNames();
    }

    public ActivityCoordinates getActivityCoordinatesByInstance(ProcessInstance processInstance) {
        ActivityCoordinates ac = this.repositoryService.getActivityCoordinates(processInstance.getProcessDefinitionId(), (String)processInstance.findActiveActivityNames().iterator().next());
        return ac;
    }

    public List<HistoryProcessInstance> findHistories() {
        List histories = this.historyService.createHistoryProcessInstanceQuery().list();
        return histories;
    }

    public PageDTO findPageHistories(ProcessHistoriesQueryDTO dto, int start, int limit) {
        HistoryProcessInstanceQuery query = this.historyService.createHistoryProcessInstanceQuery();
        if (dto != null) {
            if (dto.getKey() != null && !dto.getKey().equals("")) {
                query.processInstanceKey(dto.getKey());
            }
            if (dto.getProcessDefinitionId() != null && !dto.getProcessDefinitionId().equals("")) {
                query.processDefinitionId(dto.getProcessDefinitionId());
            }
            if (dto.getProcessInstanceId() != null && !dto.getProcessInstanceId().equals("")) {
                query.processInstanceId(dto.getProcessInstanceId());
            }
            if (dto.getState() != null && !dto.getState().equals("")) {
                query.state(dto.getState());
            }
        }
        PageDTO p = new PageDTO();
        int totalSize = (int)query.count();
        p.setTotalSize(totalSize);
        query.orderDesc("startTime");
        List data = query.page(start, limit).list();
        ArrayList<ProcessHistoriesDTO> dtos = new ArrayList<ProcessHistoriesDTO>(data.size());
        for (HistoryProcessInstance entity : data) {
            ProcessHistoriesDTO adto = this.processHistories2Dto(entity);
            dtos.add(adto);
        }
        p.setData(dtos);
        return p;
    }

    public ProcessHistoriesDTO processHistories2Dto(HistoryProcessInstance entity) {
        ProcessHistoriesDTO dto = new ProcessHistoriesDTO();
        dto.setKey(entity.getKey());
        dto.setDuration(entity.getDuration());
        dto.setEndActivityName(entity.getEndActivityName());
        dto.setEndTime(entity.getEndTime());
        dto.setProcessDefinitionId(entity.getProcessDefinitionId());
        dto.setProcessInstanceId(entity.getProcessInstanceId());
        dto.setStartTime(entity.getStartTime());
        dto.setState(entity.getState());
        return dto;
    }

    public List<Task> findTasks(String username) {
        List groupTasks = this.taskService.findGroupTasks(username);
        List personTasks = this.taskService.findPersonalTasks(username);
        List assigneeTasks = this.taskService.createTaskQuery().assignee(username).list();
        List tasks = (List)CollectionUtils.union((Collection)groupTasks, (Collection)personTasks);
        tasks = (List)CollectionUtils.union((Collection)tasks, (Collection)assigneeTasks);
        return tasks;
    }

    public TaskDTO task2Dto(Task task) {
        TaskDTO taskDto = new TaskDTO();
        taskDto.setActivityName(task.getActivityName());
        taskDto.setAssignee(task.getAssignee());
        taskDto.setCreateTime(task.getCreateTime());
        taskDto.setDescription(task.getDescription());
        taskDto.setDuedate(task.getDuedate());
        taskDto.setExecutionId(task.getExecutionId());
        taskDto.setFormResourceName(task.getFormResourceName());
        taskDto.setId(task.getId());
        taskDto.setName(task.getName());
        taskDto.setPriority(task.getPriority());
        taskDto.setProgress(task.getProgress());
        Map<String, Object> variables = this.getVariablesByTaskId(task.getId());
        if (variables != null) {
            taskDto.setVariables(variables);
        }
        return taskDto;
    }

    public List<TaskDTO> findTaskDtos(String username) {
        List<Task> tasks = this.findTasks(username);
        ArrayList<TaskDTO> taskDtos = new ArrayList<TaskDTO>();
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                taskDtos.add(this.task2Dto(task));
            }
        }
        return taskDtos;
    }

    public PageDTO findTaskDtos(String username, int start, int limit) {
        TaskQuery query = this.taskService.createTaskQuery().assignee(username);
        query.orderDesc("createTime");
        int totalSize = (int)query.count();
        List data = query.page(start, limit).list();
        PageDTO p = new PageDTO();
        p.setTotalSize(totalSize);
        ArrayList<TaskDTO> dtos = new ArrayList<TaskDTO>(data.size());
        for (Task entity : data) {
            TaskDTO dto = this.task2Dto(entity);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    public PageDTO findGroupTaskDtos(String username, int start, int limit) {
        List query = this.taskService.findGroupTasks(username);
        int totalSize = query.size();
        List data = new ArrayList();
        data = query;
        PageDTO p = new PageDTO();
        p.setTotalSize(totalSize);
        ArrayList<TaskDTO> dtos = new ArrayList<TaskDTO>(data.size());
        for (Task entity : data) {
            TaskDTO dto = this.task2Dto(entity);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    public void takeTask(String taskId, String username, String to) {
        Task task = this.taskService.getTask(taskId);
        this.taskService.completeTask(task.getId(), to);
    }

    public void takeTask(String pid, String activityName, String username, String to) {
        String taskId = this.getTaskId(pid, activityName);
        Task task = this.taskService.getTask(taskId);
        this.taskService.completeTask(task.getId(), to);
    }

    public void taskTask(String taskId, String username) {
        this.taskService.takeTask(taskId, username);
    }

    public void assignTask(String taskId, String username) {
        this.taskService.assignTask(taskId, username);
    }

    public String getTaskId(String pid, String activityName) {
        List tasks = this.taskService.createTaskQuery().processInstanceId(pid).activityName(activityName).list();
        if (tasks.size() >= 1) {
            String taskId = "";
            for (Task t : tasks) {
                taskId = t.getId();
            }
            return taskId;
        }
        Task task = this.taskService.createTaskQuery().processInstanceId(pid).activityName(activityName).uniqueResult();
        if (task != null) {
            return task.getId();
        }
        return null;
    }

    public List<TaskDTO> getCurrentPiMyTask(String pid, String userName) {
        String nextActivityName = this.getActivityNamesByInstance(this.getInstanceById(pid)).iterator().next();
        List tasks = this.taskService.createTaskQuery().processInstanceId(pid).activityName(nextActivityName).assignee(userName).list();
        ArrayList<TaskDTO> dtos = new ArrayList<TaskDTO>(tasks.size());
        if (tasks != null && tasks.size() > 0) {
            for (Task entity : tasks) {
                TaskDTO dto = this.task2Dto(entity);
                dtos.add(dto);
            }
        } else {
            dtos = null;
        }
        return dtos;
    }

    public List<TaskDTO> findCurrentTaskByPid(String pid) {
        String nextActivityName = this.getActivityNamesByInstance(this.getInstanceById(pid)).iterator().next();
        List tasks = this.taskService.createTaskQuery().processInstanceId(pid).activityName(nextActivityName).list();
        ArrayList<TaskDTO> dtos = new ArrayList<TaskDTO>(tasks.size());
        for (Task entity : tasks) {
            TaskDTO dto = this.task2Dto(entity);
            dtos.add(dto);
        }
        return dtos;
    }

    public void assignActivity(String pid, String activityName, String username) {
        Task task = this.taskService.createTaskQuery().processInstanceId(pid).activityName(activityName).uniqueResult();
        this.taskService.assignTask(task.getId(), username);
    }

    public Object getVariableByTaskId(String taskId, String variableName) {
        try {
            return this.taskService.getVariable(taskId, variableName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> getVariablesByTaskId(String taskId) {
        Set variableNames = this.taskService.getVariableNames(taskId);
        return this.taskService.getVariables(taskId, variableNames);
    }

    public void reSetVariablesByPid(String pid, Map<String, Object> map) {
        Task task = this.getTaskByPid(pid);
        this.taskService.setVariables(task.getId(), map);
    }

    public Map<String, Object> getVariablesByExecutionId(String taskId, String executionId) throws Exception {
        Set variableNames = this.taskService.getVariableNames(taskId);
        Map variables = this.executionService.getVariables(executionId, variableNames);
        return variables;
    }

    public Task getTask(String taskId) {
        return this.taskService.getTask(taskId);
    }

    public List<User> findUsers() {
        return this.identityService.findUsers();
    }

    @Transactional
    public void createGroup(String groupName, String parentGroupId) {
        Group group;
        if (parentGroupId != null && (group = this.identityService.findGroupById(parentGroupId)) == null) {
            this.identityService.createGroup(parentGroupId);
        }
        this.identityService.createGroup(groupName);
    }

    public void createUser(String id, String familyName, String givenName, String businessEmail) {
        this.identityService.createUser(id, familyName, givenName, businessEmail);
    }

    public void modifyUser(String id, String familyName, String givenName, String businessEmail) {
        if (null != this.identityService.findUserById(id)) {
            this.identityService.deleteUser(id);
        }
        this.createUser(id, familyName, givenName, businessEmail);
    }

    @Transactional
    public void createMembership(String groupId, String[] userIds) {
        Group g = this.identityService.findGroupById(groupId);
        if (g == null) {
            this.identityService.createGroup(groupId);
        }
        for (String userId : userIds) {
            this.identityService.createMembership(userId, groupId);
        }
    }

    protected List<ProcessDefinition> findAllProcessDefinitions() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().orderAsc("idProperty.objectName").list();
        return processDefinitions;
    }

    protected ProcessDefinition getDefinitionById(String processId) {
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processId).uniqueResult();
        return processDefinition;
    }

    public Set<String> getOutcomes(String pid) {
        String nextActivityName;
        String taskId;
        ProcessInstance pi;
        HashSet<String> outcomesSet = new HashSet<String>();
        if (pid != null && (pi = this.getInstanceById(pid)) != null && (taskId = this.getTaskId(pid, nextActivityName = this.getActivityNamesByInstance(pi).iterator().next())) != null) {
            Task task = this.taskService.getTask(taskId);
            Set outcomme = this.taskService.getOutcomes(task.getId());
            for (String omme : outcomme) {
                outcomesSet.add(omme);
            }
        }
        return outcomesSet;
    }

    public Task getTaskByPid(String pid) {
        ProcessInstance pi = this.getInstanceById(pid);
        String nextActivityName = this.getActivityNamesByInstance(pi).iterator().next();
        Task task = this.taskService.createTaskQuery().processInstanceId(pid).activityName(nextActivityName).uniqueResult();
        return this.taskService.createTaskQuery().processInstanceId(pid).activityName(nextActivityName).uniqueResult();
    }

    public void completeTask(String taskId, String next, Map<String, Object> variables) {
        this.taskService.completeTask(taskId, next, variables);
    }

    public void completeTask(String taskId, Map<String, Object> variables) {
        this.taskService.completeTask(taskId, variables);
    }

    public void completeTask(String taskId, String next) {
        this.taskService.completeTask(taskId, next);
    }

    public void completeTask(String taskId) {
        this.taskService.completeTask(taskId);
    }
}

