/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.jbpm.action;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.jbpm.dto.ProcessHistoriesQueryDTO;
import com.sinba.common.jbpm.dto.ProcessUseDTO;
import com.sinba.common.jbpm.dto.TaskDTO;
import com.sinba.common.jbpm.service.IProcessUseService;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.identity.User;
import org.jbpm.api.model.ActivityCoordinates;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmAction
extends ActionSupport {
    @Autowired
    protected JbpmFacade jbpmFacade;
    private File jpdlFile;
    private String jpdlFileFileName;
    private String jpdlFileContentType;
    private String deploymentId;
    private String processId;
    private String instanceId;
    private String taskId;
    private List<ProcessDefinition> process;
    private List<ProcessInstance> processInstances;
    private List<HistoryProcessInstance> histories;
    private InputStream processImageInputStream;
    private ActivityCoordinates activityCoordinates;
    private List<TaskDTO> tasks;
    private List<User> users;
    private String groupId;
    private String[] userIds;
    private String toTaskName;
    private PageDTO processPageDto;
    private PageDTO processInstancesDto;
    private int page = 1;
    private int rows = 10;
    private IProcessUseService processUseService;
    private ProcessUseDTO processUseDTO;
    private ProcessHistoriesQueryDTO dto;

    public PageDTO getProcessInstancesDto() {
        return this.processInstancesDto;
    }

    public void setProcessInstancesDto(PageDTO processInstancesDto) {
        this.processInstancesDto = processInstancesDto;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public ActivityCoordinates getActivityCoordinates() {
        return this.activityCoordinates;
    }

    public void setActivityCoordinates(ActivityCoordinates activityCoordinates) {
        this.activityCoordinates = activityCoordinates;
    }

    public List<TaskDTO> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskDTO> tasks) {
        this.tasks = tasks;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String[] userIds) {
        this.userIds = userIds;
    }

    public String getToTaskName() {
        return this.toTaskName;
    }

    public void setToTaskName(String toTaskName) {
        this.toTaskName = toTaskName;
    }

    public PageDTO getProcessPageDto() {
        return this.processPageDto;
    }

    public void setProcessPageDto(PageDTO processPageDto) {
        this.processPageDto = processPageDto;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public File getJpdlFile() {
        return this.jpdlFile;
    }

    public void setJpdlFile(File jpdlFile) {
        this.jpdlFile = jpdlFile;
    }

    public String getJpdlFileFileName() {
        return this.jpdlFileFileName;
    }

    public void setJpdlFileFileName(String jpdlFileFileName) {
        this.jpdlFileFileName = jpdlFileFileName;
    }

    public String getJpdlFileContentType() {
        return this.jpdlFileContentType;
    }

    public void setJpdlFileContentType(String jpdlFileContentType) {
        this.jpdlFileContentType = jpdlFileContentType;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public List<ProcessDefinition> getProcess() {
        return this.process;
    }

    public void setProcess(List<ProcessDefinition> process) {
        this.process = process;
    }

    public List<ProcessInstance> getProcessInstances() {
        return this.processInstances;
    }

    public void setProcessInstances(List<ProcessInstance> processInstances) {
        this.processInstances = processInstances;
    }

    public List<HistoryProcessInstance> getHistories() {
        return this.histories;
    }

    public void setHistories(List<HistoryProcessInstance> histories) {
        this.histories = histories;
    }

    public InputStream getProcessImageInputStream() {
        return this.processImageInputStream;
    }

    public void setProcessImageInputStream(InputStream processImageInputStream) {
        this.processImageInputStream = processImageInputStream;
    }

    public IProcessUseService getProcessUseService() {
        return this.processUseService;
    }

    public void setProcessUseService(IProcessUseService processUseService) {
        this.processUseService = processUseService;
    }

    public ProcessUseDTO getProcessUseDTO() {
        return this.processUseDTO;
    }

    public void setProcessUseDTO(ProcessUseDTO processUseDTO) {
        this.processUseDTO = processUseDTO;
    }

    public ProcessHistoriesQueryDTO getDto() {
        return this.dto;
    }

    public void setDto(ProcessHistoriesQueryDTO dto) {
        this.dto = dto;
    }

    public String deployProcess() throws Exception {
        String deployId = this.jbpmFacade.deployJpdl(this.jpdlFile);
        return "success";
    }

    public String findProcessDefinitions() throws Exception {
        int start = (this.page - 1) * this.rows;
        this.processPageDto = this.jbpmFacade.findLatestProcessDefinitions(start, this.rows);
        this.processPageDto.setPage(this.page);
        this.processPageDto.setRows(this.rows);
        return "findProcessDefinitions";
    }

    public String undeployProcess() throws Exception {
        this.jbpmFacade.undeployJpdlById(this.deploymentId);
        return "success";
    }

    public String showProcessImage() throws Exception {
        this.processImageInputStream = this.jbpmFacade.getProcessImage(this.processId);
        return "showProcessImage";
    }

    public String showHistories() throws Exception {
        int start = (this.page - 1) * this.rows;
        this.processPageDto = this.jbpmFacade.findPageHistories(this.dto, start, this.rows);
        this.processPageDto.setPage(this.page);
        this.processPageDto.setRows(this.rows);
        return "histories";
    }

    public String showProcessInstances() throws Exception {
        int start = (this.page - 1) * this.rows;
        this.processInstancesDto = this.jbpmFacade.findInstances(this.processId, start, this.rows);
        this.processInstancesDto.setPage(this.page);
        this.processInstancesDto.setRows(this.rows);
        return "showProcessInstances";
    }

    public String traceInstance() throws Exception {
        ProcessInstance processInstance = this.jbpmFacade.getInstanceById(this.instanceId);
        if (processInstance != null) {
            this.processId = processInstance.getProcessDefinitionId();
            this.activityCoordinates = this.jbpmFacade.getActivityCoordinatesByInstance(processInstance);
        }
        return "traceInstance";
    }

    public String showMyTasks() throws Exception {
        String loginUser = (String)ActionContext.getContext().getSession().get("SPRING_SECURITY_LAST_USERNAME");
        int start = (this.page - 1) * this.rows;
        this.processInstancesDto = this.jbpmFacade.findTaskDtos(loginUser, start, this.rows);
        this.processInstancesDto.setPage(this.page);
        this.processInstancesDto.setRows(this.rows);
        return "showMyTasks";
    }

    public String showMyGroupTasks() throws Exception {
        String loginUser = (String)ActionContext.getContext().getSession().get("SPRING_SECURITY_LAST_USERNAME");
        int start = (this.page - 1) * this.rows;
        this.processInstancesDto = this.jbpmFacade.findGroupTaskDtos(loginUser, start, this.rows);
        this.processInstancesDto.setPage(this.page);
        this.processInstancesDto.setRows(this.rows);
        return "showMyTasks";
    }

    public String takeTask() throws Exception {
        String loginUser = (String)ActionContext.getContext().getSession().get("loginUser");
        this.jbpmFacade.takeTask(this.taskId, loginUser, this.toTaskName);
        return "takeTask";
    }

    public String findUsers() throws Exception {
        this.users = this.jbpmFacade.findUsers();
        return "showUsers";
    }

    public String viewApply() throws Exception {
        Map<String, Object> variables = this.jbpmFacade.getVariablesByTaskId(this.taskId);
        ActionContext.getContext().put("variables", variables);
        return "view_overtime";
    }

    public String viewRequest() throws Exception {
        Map<String, Object> variables = this.jbpmFacade.getVariablesByTaskId(this.taskId);
        for (String string : variables.entrySet()) {
        }
        return "success";
    }

    public String pricessUseSet() {
        this.processUseService.processUseSave(this.processUseDTO);
        return "success";
    }

    public String pricessUseById() {
        if (this.processUseDTO.getProcessUseNo() != null) {
            this.processUseDTO = this.processUseService.findById(this.processUseDTO.getProcessUseNo());
        }
        return "processUseDTO";
    }

    public String getCurrentPiMyTask() {
        String loginUser = (String)ActionContext.getContext().getSession().get("SPRING_SECURITY_LAST_USERNAME");
        this.tasks = this.jbpmFacade.getCurrentPiMyTask(this.processId, loginUser);
        return "tasks";
    }
}

