/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.tools.dao.IAfficheDAO;
import com.sinba.common.tools.dto.AfficheQueryDTO;
import com.sinba.common.tools.entity.AfficheInfo;
import com.sinba.common.util.StringUtils;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AfficheDAO
extends BaseDAOImplHibernate<AfficheInfo>
implements IAfficheDAO {
    @Override
    public PageDTO findPager(AfficheQueryDTO dto, int start, int limit, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(AfficheInfo.class);
        if (dto != null) {
            GregorianCalendar endTimeCl;
            if (dto.getAffstart() != null && dto.getAffEnd() == null) {
                dc.add((Criterion)Restrictions.ge((String)"affStart", (Object)dto.getAffstart()));
            }
            if (dto.getAffstart() == null && dto.getAffEnd() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(dto.getAffEnd());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.le((String)"affStart", (Object)endTimeCl.getTime()));
            }
            if (dto.getAffstart() != null && dto.getAffEnd() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(dto.getAffEnd());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"affStart", (Object)endTimeCl.getTime()), (Criterion)Restrictions.ge((String)"affStart", (Object)dto.getAffstart())));
            }
            if (StringUtils.hasText((String)dto.getAffTitle())) {
                dc.add((Criterion)Restrictions.like((String)"affTitle", (String)dto.getAffTitle(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (dto.getVisibleState() == 1) {
                dc.add((Criterion)Restrictions.eq((String)"visibleState", (Object)dto.getVisibleState()));
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if (sord.equals("desc")) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public List<AfficheInfo> findByName(String affTitle) {
        return this.getHibernateTemplate().find("from AfficheInfo where affTitle like ?", (Object)("%" + affTitle + "%"));
    }
}

