/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.tools.dao.EmailMessageQueryDTO;
import com.sinba.common.tools.dao.IEmailDAO;
import com.sinba.common.tools.entity.EmailMessage;
import com.sinba.common.util.StringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailDAO
extends BaseDAOImplHibernate<EmailMessage>
implements IEmailDAO {
    @Override
    public EmailMessage findLastestReceiveDate() {
        String hql = "From EmailMessage where folderName='INBOX' and dataFlag=0 order by receiveDate desc";
        List list = this.getHibernateTemplate().find(hql);
        if (list.size() > 0) {
            return (EmailMessage)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public PageDTO findPager(EmailMessageQueryDTO dto, int start, int limit, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(EmailMessage.class);
        if (dto != null) {
            if (StringUtils.hasText((String)dto.getSubject())) {
                dc.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"subject", (String)dto.getSubject(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.like((String)"content", (String)dto.getSubject(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.like((String)"keyword", (String)dto.getSubject(), (MatchMode)MatchMode.ANYWHERE))));
            }
            if (StringUtils.hasText((String)dto.getFolderName())) {
                dc.add((Criterion)Restrictions.eq((String)"folderName", (Object)dto.getFolderName()));
            }
            if (dto.getKeyword() != null) {
                dc.add((Criterion)Restrictions.like((String)"keyword", (String)dto.getKeyword(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (dto.getToUser() != null) {
                dc.add((Criterion)Restrictions.like((String)"toUser", (String)dto.getToUser(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (dto.getFromUser() != null) {
                dc.add((Criterion)Restrictions.like((String)"fromUser", (String)dto.getFromUser(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (dto.getReceiveStartDate() != null && dto.getReceiveEndDate() != null) {
                dc.add(Restrictions.between((String)"receiveDate", (Object)dto.getReceiveStartDate(), (Object)dto.getReceiveEndDate()));
            }
            if (dto.getSendStartDate() != null && dto.getSendEndDate() != null) {
                dc.add(Restrictions.between((String)"sendDate", (Object)dto.getSendStartDate(), (Object)dto.getSendEndDate()));
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if (sord.equals("desc")) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }
}

