/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.tools.dao.IAfficheDAO;
import com.sinba.common.tools.dto.AfficheDTO;
import com.sinba.common.tools.dto.AfficheQueryDTO;
import com.sinba.common.tools.entity.AfficheInfo;
import com.sinba.common.tools.service.IAfficheService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AfficheService
implements IAfficheService {
    @Autowired
    private IAfficheDAO afficheDAO;

    @Override
    public List<AfficheDTO> findAllAffiche() {
        return null;
    }

    @Override
    public PageDTO findPagerAffiche(AfficheQueryDTO dto, int start, int limit, String sidx, String sord) {
        PageDTO p = this.afficheDAO.findPager(dto, start, limit, sidx, sord);
        List entities = p.getData();
        ArrayList<AfficheDTO> dtos = new ArrayList<AfficheDTO>(entities.size());
        for (AfficheInfo entity : entities) {
            AfficheDTO adto = this.entity2dto(entity);
            dtos.add(adto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    private AfficheDTO entity2dto(AfficheInfo entity) {
        AfficheDTO dto = new AfficheDTO();
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dto;
    }

    @Transactional
    private void dto2entity(AfficheDTO dto, AfficheInfo entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void saveAffiche(AfficheDTO dto) {
        Calendar cd = Calendar.getInstance();
        Date d = cd.getTime();
        dto.setAffCreaTime(d);
        AfficheInfo aff = new AfficheInfo();
        this.dto2entity(dto, aff);
        this.afficheDAO.save((Object)aff);
    }

    @Override
    @Transactional
    public void removeAffiche(Long affId) {
        this.afficheDAO.delete(this.afficheDAO.findById(affId));
    }

    @Override
    @Transactional
    public void removeAffiches(Long[] affids) {
        this.afficheDAO.deleteByIds(affids);
    }

    @Override
    @Transactional
    public void mergeAffiche(AfficheDTO dto) {
        AfficheInfo aff = new AfficheInfo();
        Calendar cd = Calendar.getInstance();
        Date d = cd.getTime();
        dto.setAffCreaTime(d);
        this.dto2entity(dto, aff);
        this.afficheDAO.merge((Object)aff);
    }

    @Override
    @Transactional
    public List<AfficheDTO> findAfficheByName(String affTitle) {
        List<AfficheInfo> entitise = this.afficheDAO.findByName(affTitle);
        ArrayList<AfficheDTO> dtos = new ArrayList<AfficheDTO>();
        for (AfficheInfo aff : entitise) {
            AfficheDTO adto = this.entity2dto(aff);
            dtos.add(adto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public void updateAfficheInfo(AfficheDTO adto) {
        AfficheInfo entity = (AfficheInfo)((Object)this.afficheDAO.findById(adto.getAffId()));
        if (adto.getAffTitle() != null) {
            entity.setAffTitle(adto.getAffTitle());
        }
        if (adto.getAffContents() != null) {
            entity.setAffContents(adto.getAffContents());
        }
        if (adto.getAffCreaTime() != null) {
            entity.setAffCreaTime(adto.getAffCreaTime());
        }
        if (adto.getAffCreator() != null) {
            entity.setAffCreator(adto.getAffCreator());
        }
        if (adto.getAffStart() != null) {
            entity.setAffStart(adto.getAffStart());
        }
        if (adto.getAffEnd() != null) {
            entity.setAffEnd(adto.getAffEnd());
        }
    }
}

