/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.User;
import com.sinba.common.tools.dao.ICostDAO;
import com.sinba.common.tools.dao.IEventTaskDAO;
import com.sinba.common.tools.dto.CostDTO;
import com.sinba.common.tools.entity.Cost;
import com.sinba.common.tools.entity.EventTask;
import com.sinba.common.tools.service.ICostService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CostService
implements ICostService {
    @Autowired
    private ICostDAO costDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IEventTaskDAO eventTaskDAO;

    @Transactional
    public PageDTO findPagerCost(CostDTO dto, int start, int limit, String sidx, String sord) {
        PageDTO p = this.costDAO.findPagerCost(dto, start, limit, sidx, sord);
        List cost = p.getData();
        ArrayList<CostDTO> costDtos = new ArrayList<CostDTO>(cost.size());
        for (Cost entity : cost) {
            CostDTO costDTO = new CostDTO();
            CostDTO.entity2dto((Object)((Object)entity), (Object)((Object)costDTO));
            if (entity.getUsers() != null) {
                costDTO.setUserId(entity.getUsers().getUserId());
                costDTO.setUserName(entity.getUsers().getLoginName());
            }
            if (entity.getEventTask() != null) {
                costDTO.setTaskId(entity.getEventTask().getTaskId());
                costDTO.setTitle(entity.getEventTask().getTitle());
            }
            costDtos.add(costDTO);
        }
        p.setData(costDtos);
        return p;
    }

    @Transactional
    public void saveCost(CostDTO dto) {
        Cost cost = new Cost();
        CostDTO.dto2entity((Object)((Object)dto), (Object)((Object)cost));
        if (dto.getUserId() != null) {
            cost.setUsers((User)this.userDAO.findById((Serializable)dto.getUserId()));
        }
        if (dto.getTaskId() != null) {
            EventTask eventTask = new EventTask();
            eventTask = (EventTask)((Object)this.eventTaskDAO.findById(dto.getTaskId()));
            cost.setEventTask(eventTask);
            if (dto.getStatus() != null) {
                eventTask.setTaskStatus(dto.getStatus());
                this.eventTaskDAO.merge((Object)eventTask);
            }
        }
        this.costDAO.save((Object)cost);
    }

    @Transactional
    public void editCost(CostDTO dto) {
        Cost cost = new Cost();
        CostDTO.dto2entity((Object)((Object)dto), (Object)((Object)cost));
        if (dto.getUserId() != null) {
            cost.setUsers((User)this.userDAO.findById((Serializable)dto.getUserId()));
        }
        if (dto.getTaskId() != null) {
            EventTask eventTask = new EventTask();
            eventTask = (EventTask)((Object)this.eventTaskDAO.findById(dto.getTaskId()));
            cost.setEventTask(eventTask);
            if (dto.getStatus() != null) {
                eventTask.setTaskStatus(dto.getStatus());
                this.eventTaskDAO.merge((Object)eventTask);
            }
        }
        this.costDAO.merge((Object)cost);
    }

    @Transactional
    public void deleteCost(Long[] ids) {
        this.costDAO.deleteByIds(ids);
    }
}

