/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.config.attachment.dao.IAttachmentDAO;
import com.sinba.common.config.attachment.entity.Attachment;
import com.sinba.common.config.util.AppConfigUtils;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.User;
import com.sinba.common.tools.dao.EmailMessageQueryDTO;
import com.sinba.common.tools.dao.IEmailDAO;
import com.sinba.common.tools.dto.EmailConnectionDTO;
import com.sinba.common.tools.dto.EmailDTO;
import com.sinba.common.tools.dto.EmailMessageDTO;
import com.sinba.common.tools.dto.EmailServerDTO;
import com.sinba.common.tools.entity.EmailMessage;
import com.sinba.common.tools.service.IEmailServerService;
import com.sinba.common.tools.service.IEmailService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EmailService
implements IEmailService {
    private static final Logger LOGGER = Logger.getLogger(EmailService.class);
    @Autowired
    private IEmailDAO emailDAO;
    @Autowired
    private IAttachmentDAO attachmentDAO;
    @Autowired
    private IUserDAO userDAO;
    private Session session;
    @Autowired
    private IEmailServerService emailServerService;
    private String saveAttachPath = "";
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private String fileName;
    private StringBuffer bodytext = new StringBuffer();
    private String dateformat = "yyyy-MM-dd HH:mm:ss";
    public static final int SUCESS_CONN_ALL = 0;
    public static final int FAIL_CONN_POP3 = 1;
    public static final int FAIL_CONN_SMTP = 2;
    public static final int FAIL_CONN_POP3ANDSMTP = 3;
    private String saveDir;

    public boolean sendEmailConnTest(final EmailConnectionDTO dto) {
        Properties pros = new Properties();
        pros.setProperty("mail.transport.protocol", "smtp");
        pros.setProperty("mail.smtp.auth", "true");
        pros.setProperty("mail.host", dto.getSmtphost());
        pros.setProperty("mail.smtp.port", String.valueOf(dto.getSmtpport()));
        this.session = Session.getInstance((Properties)pros, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(dto.getUsername(), dto.getPassword());
            }
        });
        this.session.setDebug(true);
        try {
            Transport tran = this.session.getTransport("smtp");
            try {
                tran.connect();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            return tran.isConnected();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveEmailConnTest(EmailConnectionDTO dto) {
        Properties props = new Properties();
        props.put("mail.pop3.host", dto.getPop3host());
        if (dto.getPop3port() != 0) {
            props.put("mail.pop3.port", (Object)dto.getPop3port());
        }
        props.put("mail.pop3.auth", "true");
        Session session = Session.getInstance((Properties)props, null);
        Store store = null;
        try {
            store = session.getStore("pop3");
            store.connect(dto.getUsername(), dto.getPassword());
            Folder folder = store.getFolder("INBOX");
            folder.open(1);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != store && store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int emailConnTest(EmailConnectionDTO dto) {
        boolean pop3result = false;
        boolean stmpresult = false;
        int result = 0;
        pop3result = this.receiveEmailConnTest(dto);
        stmpresult = this.sendEmailConnTest(dto);
        if (!stmpresult) {
            result = 2;
        }
        if (!pop3result) {
            result = 1;
        }
        if (!stmpresult && !pop3result) {
            result = 3;
        }
        return result;
    }

    public void mailSmtpConnection() {
        EmailServerDTO emailServerDTO = this.emailServerService.findEmail();
        if (emailServerDTO != null) {
            final EmailConnectionDTO emailConnectionDto = new EmailConnectionDTO();
            emailConnectionDto.setSmtphost(emailServerDTO.getSmtpServerAddress());
            emailConnectionDto.setSmtpport(Integer.parseInt(emailServerDTO.getSmtpServerPort()));
            emailConnectionDto.setUsername(emailServerDTO.getUserName());
            emailConnectionDto.setPassword(emailServerDTO.getPassword());
            Properties pros = new Properties();
            if (emailConnectionDto.getSmtphost() != null && emailConnectionDto.getUsername() != null && emailConnectionDto.getPassword() != null) {
                pros.setProperty("mail.transport.protocol", "smtp");
                pros.setProperty("mail.smtp.auth", "true");
                pros.setProperty("mail.host", emailConnectionDto.getSmtphost());
                pros.setProperty("mail.smtp.port", String.valueOf(emailConnectionDto.getSmtpport()));
                this.session = Session.getInstance((Properties)pros, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(emailConnectionDto.getUsername(), emailConnectionDto.getPassword());
                    }
                });
                this.session.setDebug(true);
            } else {
                throw new ApplicationException("ERROR_EMAIL_ACCOUNT_ERROR\n");
            }
        }
    }

    public boolean sendMail(EmailDTO dto) {
        EmailServerDTO emailServerDTO = this.emailServerService.findEmail();
        if (emailServerDTO != null) {
            dto.setFrom(emailServerDTO.getUserName());
        }
        this.mailSmtpConnection();
        if (dto.getTo() != null) {
            if (dto.getReceiveAddress() != null) {
                dto.setReceiveAddress(dto.getReceiveAddress().replace(",", ";"));
                String[] receiveAddress = dto.getReceiveAddress().split(";");
                if (receiveAddress != null && receiveAddress.length > 0) {
                    for (String address : receiveAddress) {
                        dto.getTo().add(address);
                    }
                }
            }
        } else if (dto.getReceiveAddress() != null) {
            ArrayList<String> emails = new ArrayList<String>();
            dto.setReceiveAddress(dto.getReceiveAddress().replace(",", ";"));
            String[] receiveAddress = dto.getReceiveAddress().split(";");
            if (receiveAddress != null && receiveAddress.length > 0) {
                for (String address : receiveAddress) {
                    emails.add(address);
                }
            }
            if (emails != null && emails.size() > 0) {
                dto.setTo(emails);
            }
        }
        boolean result = false;
        String mailtype = "text/html;charset=GBK";
        try {
            if (dto == null) {
                return result;
            }
            MimeMessage msg = new MimeMessage(this.session);
            msg.setFrom((Address)new InternetAddress(dto.getFrom()));
            InternetAddress[] tos = new InternetAddress[dto.getTo().size()];
            for (int i = 0; i < dto.getTo().size(); ++i) {
                tos[i] = new InternetAddress(dto.getTo().get(i));
            }
            msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])tos);
            msg.setSubject(dto.getSubject());
            if (null == dto.getPicPath() && null == dto.getAffachmentPath()) {
                msg.setContent((Object)dto.getContent(), mailtype);
            } else {
                MimeMultipart multipart = new MimeMultipart("mixed");
                MimeBodyPart msgBodyPart = new MimeBodyPart();
                multipart.addBodyPart((BodyPart)msgBodyPart);
                if (dto.getAffachmentPath() != null) {
                    for (int i = 0; i < dto.getAffachmentPath().length; ++i) {
                        MimeBodyPart attBodyPart = new MimeBodyPart();
                        FileDataSource ds = new FileDataSource(new File(dto.getAffachmentPath()[i]));
                        attBodyPart.setDataHandler(new DataHandler((DataSource)ds));
                        attBodyPart.setFileName(MimeUtility.encodeText((String)ds.getName()));
                        multipart.addBodyPart((BodyPart)attBodyPart);
                    }
                    msg.setContent((Multipart)multipart);
                }
                msg.setContent((Object)dto.getContent(), mailtype);
            }
            EmailMessage emailMessage = this.mime2Entity(msg, "OUTBOX", dto.getFrom());
            Transport.send((Message)msg);
            this.saveEmailMessages(emailMessage);
            result = true;
        }
        catch (Exception e) {
            result = false;
            LOGGER.error((Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageDTO getEamilMessage(EmailConnectionDTO dto, int page1, int limit) {
        Properties props = new Properties();
        props.put("mail.pop3.host", dto.getPop3host());
        if (dto.getPop3port() != 0) {
            props.put("mail.pop3.port", (Object)dto.getPop3port());
        }
        props.put("mail.pop3.auth", "true");
        props.put("mail.mime.base64.ignoreerrors", "true");
        Session session = Session.getInstance((Properties)props, null);
        PageDTO page = new PageDTO();
        ArrayList<EmailDTO> dtos = new ArrayList<EmailDTO>();
        Store store = null;
        try {
            store = session.getStore("pop3");
            store.connect(dto.getUsername(), dto.getPassword());
            Folder folder = store.getFolder("INBOX");
            folder.open(1);
            Message[] messages = EmailService.reverse(folder.getMessages());
            int totalSize = messages.length;
            int start = (page1 - 1) * limit;
            int end = limit * page1 - 1;
            if (end >= totalSize) {
                end = totalSize - 1;
            }
            for (int i = start; i <= end; ++i) {
                MimeMessage message = (MimeMessage)messages[i];
                dtos.add(this.entity2Dto(message));
            }
            page.setTotalSize(totalSize);
            page.setData(dtos);
        }
        catch (Exception e) {
            e.printStackTrace();
            page.setData(null);
        }
        finally {
            if (null != store && store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
        return page;
    }

    public static Message[] reverse(Message[] data) {
        int length = data.length;
        Message temp = null;
        for (int i = 0; i < length / 2; ++i) {
            temp = data[i];
            data[i] = data[length - 1 - i];
            data[length - 1 - i] = temp;
        }
        return data;
    }

    private EmailDTO entity2Dto(MimeMessage message) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateformat);
        EmailDTO dto = new EmailDTO();
        try {
            try {
                this.getMailContent((Part)message);
                dto.setContent(this.getBodyText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dto.setMailId(message.getMessageNumber());
            dto.setSendDate(sdf.format(message.getSentDate()));
            dto.setDescription(message.getDescription());
            String subject = this.getSubject(message);
            dto.setSubject(subject);
            dto.setFromEmail(this.getFrom(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dto;
    }

    @Transactional
    private EmailMessageDTO entity2Dto(EmailMessage emailMessage) {
        EmailMessageDTO dto = new EmailMessageDTO();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)((Object)emailMessage));
            List<Attachment> attrs = emailMessage.getAttachment();
            if (attrs != null && attrs.size() > 0) {
                dto.setAffachment(attrs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dto;
    }

    private EmailMessage mime2Entity(MimeMessage message, String folderName, String userName) {
        EmailMessage dao = new EmailMessage();
        try {
            try {
                this.getMailContent((Part)message);
                dao.setContent(this.getBodyText());
            }
            catch (Exception e) {
                throw new ApplicationException("ERROR_SCANEMAILMESSAGE\n" + e);
            }
            dao.setDescription(message.getDescription());
            dao.setSubject(this.getSubject(message));
            if (this.isContainAttach((Part)message)) {
                String ATTACHMENT_PATH = AppConfigUtils.getInstance().getAttachmentPath();
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
                String fileFolder = fmt.format(new Date());
                this.saveDir = ATTACHMENT_PATH + "\\" + fileFolder;
                if (!new File(this.saveDir).isDirectory()) {
                    new File(this.saveDir).mkdir();
                }
                System.out.println(this.saveDir);
                this.attachments.clear();
                this.setAttachPath(this.saveDir);
                dao.setMailPath(this.saveDir);
                this.saveAttachMent((Part)message);
                dao.setAttachment(this.attachments);
            }
            userName = "<" + userName + ">";
            if (folderName.equals("INBOX")) {
                dao.setFolderName("INBOX");
                dao.setReceiveDate(message.getSentDate());
                dao.setFromUser(this.getFrom(message));
                dao.setToUser(userName);
            } else {
                dao.setFolderName("OUTBOX");
                dao.setToUser(this.getMailAddress(message, "TO"));
                dao.setCc(this.getMailAddress(message, "CC"));
                dao.setBcc(this.getMailAddress(message, "BCC"));
                dao.setSendDate(new Date());
                dao.setFromUser(userName);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("ERROR_SCANEMAILMESSAGE\n" + e);
        }
        return dao;
    }

    public String getBodyText() {
        return this.bodytext.toString();
    }

    public void getMailContent(Part part) throws Exception {
        this.bodytext = new StringBuffer();
        String contenttype = part.getContentType();
        int nameindex = contenttype.indexOf("name");
        boolean conname = false;
        if (nameindex != -1) {
            conname = true;
        }
        if (part.isMimeType("text/plain") && !conname) {
            String content = null;
            try {
                content = (String)part.getContent();
            }
            catch (Exception ex) {
                String charset = contenttype.substring(contenttype.indexOf("=") + 1);
                InputStream is = part.getInputStream();
                byte[] bs = new byte[is.available()];
                is.read(bs);
                content = new String(bs, charset).trim();
            }
            this.bodytext.append(content);
        } else if (part.isMimeType("text/html") && !conname) {
            String content = (String)part.getContent();
            if (contenttype.indexOf("charset") < 0) {
                InputStream is = part.getInputStream();
                byte[] bs = new byte[is.available()];
                is.read(bs);
                content = new String(bs, "GBK").trim();
            }
            this.bodytext.append(content);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int counts = multipart.getCount();
            for (int i = 0; i < counts; ++i) {
                this.getMailContent((Part)multipart.getBodyPart(i));
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.getMailContent((Part)part.getContent());
        }
    }

    public String getFrom(MimeMessage message) throws Exception {
        String personal;
        InternetAddress[] address = (InternetAddress[])message.getFrom();
        String from = address[0].getAddress();
        if (from == null) {
            from = "";
        }
        if ((personal = address[0].getPersonal()) == null) {
            personal = "";
        }
        String fromaddr = personal + "<" + from + ">";
        return fromaddr;
    }

    public String getMailAddress(MimeMessage mimeMessage, String type) throws Exception {
        String mailaddr = "";
        String addtype = type.toUpperCase();
        InternetAddress[] address = null;
        if (addtype.equals("TO") || addtype.equals("CC") || addtype.equals("BCC")) {
            address = addtype.equals("TO") ? (InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.TO) : (addtype.equals("CC") ? (InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.CC) : (InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.BCC));
            if (address != null) {
                for (int i = 0; i < address.length; ++i) {
                    String email = address[i].getAddress();
                    email = email == null ? "" : MimeUtility.decodeText((String)email);
                    String personal = address[i].getPersonal();
                    personal = personal == null ? "" : MimeUtility.decodeText((String)personal);
                    String compositeto = personal + "<" + email + ">";
                    mailaddr = mailaddr + "," + compositeto;
                }
                mailaddr = mailaddr.substring(1);
            }
        } else {
            throw new Exception("Error emailaddr type!");
        }
        return mailaddr;
    }

    public boolean isContainAttach(Part part) throws Exception {
        boolean attachflag = false;
        String contentType = part.getContentType();
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart mpart = mp.getBodyPart(i);
                String disposition = mpart.getDisposition();
                if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                    attachflag = true;
                    continue;
                }
                if (mpart.isMimeType("multipart/*")) {
                    attachflag = this.isContainAttach((Part)mpart);
                    continue;
                }
                String contype = mpart.getContentType();
                if (contype.toLowerCase().indexOf("application") != -1) {
                    attachflag = true;
                }
                if (contype.toLowerCase().indexOf("name") == -1) continue;
                attachflag = true;
            }
        } else if (part.isMimeType("message/rfc822")) {
            attachflag = this.isContainAttach((Part)part.getContent());
        }
        return attachflag;
    }

    public void saveAttachMent(Part part) throws Exception {
        String fileName = "";
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart mpart = mp.getBodyPart(i);
                String disposition = mpart.getDisposition();
                if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                    fileName = mpart.getFileName();
                    if (fileName.toLowerCase().indexOf("gb2312") != -1 || fileName.toLowerCase().indexOf("gbk") != -1) {
                        fileName = MimeUtility.decodeText((String)fileName);
                    }
                    this.saveFile(fileName, mpart.getInputStream());
                    continue;
                }
                if (mpart.isMimeType("multipart/*")) {
                    this.saveAttachMent((Part)mpart);
                    continue;
                }
                fileName = mpart.getFileName();
                if (fileName == null || fileName.toLowerCase().indexOf("GB2312") == -1 && fileName.toLowerCase().indexOf("gbk") == -1) continue;
                fileName = MimeUtility.decodeText((String)fileName);
                this.saveFile(fileName, mpart.getInputStream());
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.saveAttachMent((Part)part.getContent());
        }
    }

    public void setAttachPath(String attachpath) {
        this.saveAttachPath = attachpath;
    }

    public String getAttachPath() {
        return this.saveAttachPath;
    }

    @Transactional
    private void saveFile(String fileName, InputStream in) throws Exception {
        Attachment attachment = new Attachment();
        attachment.setAttachmentName(fileName);
        fileName = new Date().getTime() + fileName.substring(fileName.indexOf("."));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String fileFolder = fmt.format(new Date());
        attachment.setUrl(fileFolder + "\\" + fileName);
        this.attachments.add(attachment);
        String osName = System.getProperty("os.name");
        String storedir = this.getAttachPath();
        String separator = "";
        if (osName == null) {
            osName = "";
        }
        if (osName.toLowerCase().indexOf("win") != -1) {
            separator = "\\";
            if (storedir == null || storedir.equals("")) {
                storedir = "c:\\tmp";
            }
        } else {
            separator = "/";
            storedir = "/tmp";
        }
        File storefile = new File(storedir + separator + fileName);
        System.out.println("storefile's path: " + storefile.toString());
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int c;
            bos = new BufferedOutputStream(new FileOutputStream(storefile));
            bis = new BufferedInputStream(in);
            while ((c = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(c);
                ((BufferedOutputStream)bos).flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25!");
        }
        finally {
            bos.close();
            bis.close();
        }
    }

    @Transactional
    public String getSubject(MimeMessage mimeMessage) throws MessagingException {
        String subject = mimeMessage.getSubject();
        try {
            if (subject != null) {
                subject = MimeUtility.decodeText((String)mimeMessage.getSubject());
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return subject;
    }

    @Transactional
    private boolean getReceiveEmailMessage(EmailConnectionDTO dto) {
        Properties props = new Properties();
        props.put("mail.pop3.host", dto.getPop3host());
        if (dto.getPop3port() != 0) {
            props.put("mail.pop3.port", (Object)dto.getPop3port());
        }
        props.put("mail.pop3.auth", "true");
        Session session = Session.getInstance((Properties)props, null);
        PageDTO page = new PageDTO();
        ArrayList emailMessages = new ArrayList();
        Store store = null;
        try {
            store = session.getStore("pop3");
            store.connect(dto.getUsername(), dto.getPassword());
            Folder folder = store.getFolder("INBOX");
            folder.open(1);
            Message[] messages = EmailService.reverse(folder.getMessages());
            EmailMessage emailMessage = this.emailDAO.findLastestReceiveDate();
            for (int i = 0; i < messages.length; ++i) {
                MimeMessage message = (MimeMessage)messages[i];
                if (!message.getFolder().isOpen()) {
                    message.getFolder().open(2);
                }
                if (emailMessage != null && message.getSentDate() != null) {
                    if (!message.getSentDate().after(emailMessage.getReceiveDate())) continue;
                    this.saveEmailMessages(this.mime2Entity(message, "INBOX", dto.getUsername()));
                    continue;
                }
                this.saveEmailMessages(this.mime2Entity(message, "INBOX", dto.getUsername()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApplicationException("ERROR_SCANEMAILMESSAGE\n" + e);
        }
        finally {
            if (null != store && store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                    throw new ApplicationException("ERROR_SCANEMAILMESSAGE\n" + (Object)((Object)e));
                }
            }
        }
    }

    @Transactional
    public boolean saveReceiveMessages(EmailConnectionDTO dto) {
        return this.getReceiveEmailMessage(dto);
    }

    @Transactional
    public void saveEmailMessages(EmailMessage emailMessage) {
        ArrayList<Attachment> atts = null;
        if (emailMessage.getAttachment() != null) {
            atts = new ArrayList<Attachment>();
            for (int i = 0; i < emailMessage.getAttachment().size(); ++i) {
                Attachment attr = emailMessage.getAttachment().get(i);
                this.attachmentDAO.save(attr);
                atts.add(attr);
            }
        }
        emailMessage.setAttachment(atts);
        this.emailDAO.merge((Object)emailMessage);
    }

    @Transactional
    public PageDTO getEmailMessage(EmailMessageQueryDTO dto, int start, int limit, String sidx, String sord) {
        PageDTO p = this.emailDAO.findPager(dto, start, limit, sidx, sord);
        List entities = p.getData();
        ArrayList<EmailMessageDTO> dtos = new ArrayList<EmailMessageDTO>(entities.size());
        for (EmailMessage entity : entities) {
            EmailMessageDTO adto = this.entity2Dto(entity);
            dtos.add(adto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public EmailMessageDTO findById(Long id) {
        EmailMessage emailMessage = (EmailMessage)((Object)this.emailDAO.findById(id));
        EmailMessageDTO emailMessageDTO = new EmailMessageDTO();
        emailMessageDTO = this.entity2Dto(emailMessage);
        return emailMessageDTO;
    }

    @Transactional
    public void deleteEmailMessage(Long[] ids) {
        this.emailDAO.deleteByIds(ids);
    }

    public boolean sendMailByLoginName(String loginName, String title, String content) {
        User user;
        boolean result = false;
        EmailDTO emailDTO = new EmailDTO();
        if (loginName != null && !loginName.equals("") && (user = (User)this.userDAO.findUniqueBy("loginName", (Object)loginName)) != null && user.getEmail() != null) {
            ArrayList<String> toEmail = new ArrayList<String>();
            toEmail.add(user.getEmail());
            emailDTO.setTo(toEmail);
            emailDTO.setSubject(title);
            emailDTO.setContent(content);
            result = this.sendMail(emailDTO);
        }
        return result;
    }
}

