/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.tools.dao.IEventAttachmentDAO;
import com.sinba.common.tools.dto.EventAttachmentDTO;
import com.sinba.common.tools.entity.EventAttachment;
import com.sinba.common.tools.service.IEventAttachmentService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAttachmentService
implements IEventAttachmentService {
    @Autowired
    private IEventAttachmentDAO eventAttachmentDAO;

    @Override
    @Transactional
    public List<EventAttachmentDTO> findAllEventAttachment(EventAttachmentDTO dto) {
        List<EventAttachment> eas;
        ArrayList<EventAttachmentDTO> eventAttachmentDtos = new ArrayList<EventAttachmentDTO>();
        if (dto != null && (eas = this.eventAttachmentDAO.findAllEventAttachment(dto)) != null && eas.size() > 0) {
            for (EventAttachment ea : eas) {
                EventAttachmentDTO eventAttachmentDto = new EventAttachmentDTO();
                EventAttachmentDTO.entity2dto((Object)((Object)ea), (Object)((Object)eventAttachmentDto));
                eventAttachmentDtos.add(eventAttachmentDto);
            }
        }
        return eventAttachmentDtos;
    }

    @Override
    @Transactional
    public void deleteEventAttachment(Long[] ids) {
        this.eventAttachmentDAO.deleteByIds(ids);
    }

    @Override
    @Transactional
    public void saveEventAttachment(String attachmentStr, Long eno, String eventType) {
        if (attachmentStr != null && attachmentStr.indexOf("-s-") != -1) {
            String[] attrArr = attachmentStr.split("-s-");
            for (int i = 0; i < attrArr.length; ++i) {
                String url = attrArr[i].replace("\\", "/");
                if (url == null || url.equals("")) continue;
                String[] attrArrs = url.split("==");
                EventAttachment attr = new EventAttachment();
                attr.setUrl(attrArrs[1]);
                attr.setAttachmentName(attrArrs[0]);
                attr.setEno(eno);
                attr.setEventType(eventType);
                if (attr == null) continue;
                this.eventAttachmentDAO.save((Object)attr);
            }
        }
    }
}

