/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.eav.dao.IAttributesDAO;
import com.sinba.common.eav.entity.Attribute;
import com.sinba.common.eav.service.EavCommService;
import com.sinba.common.tools.dao.IEventEavDAO;
import com.sinba.common.tools.dto.EventEavDTO;
import com.sinba.common.tools.entity.EventEav;
import com.sinba.common.tools.service.IEventEavService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventEavService
implements IEventEavService {
    @Autowired
    private IEventEavDAO eventEavDAO;
    @Autowired
    private IAttributesDAO attributesDAO;
    @Autowired
    private EavCommService eavCommService;

    @Override
    @Transactional
    public void saveEventEav(EventEavDTO dto) {
        EventEav eventEav = new EventEav();
        eventEav.setEno(dto.getEno());
        eventEav.setEventType(dto.getEventType());
        if (dto.getAttrVals() != null) {
            for (String attrName : dto.getAttrVals().keySet()) {
                Attribute attr = (Attribute)this.attributesDAO.findUniqueBy("attrName", (Object)attrName);
                String attrRawVal = dto.getAttrVals().get(attrName);
                eventEav.getAttrVals().put(attr, this.eavCommService.getObjectByType(attr.getAttrType(), attr, attrRawVal));
            }
        }
        this.eventEavDAO.save((Object)eventEav);
    }

    @Override
    @Transactional
    public void editEventEav(EventEavDTO dto) {
        EventEav eventEav = (EventEav)((Object)this.eventEavDAO.findUniqueBy("eno", dto.getEno()));
        eventEav.setEno(dto.getEno());
        eventEav.setEventType(dto.getEventType());
        if (dto.getAttrVals() != null) {
            for (String attrName : dto.getAttrVals().keySet()) {
                Attribute attr = (Attribute)this.attributesDAO.findUniqueBy("attrName", (Object)attrName);
                String attrRawVal = dto.getAttrVals().get(attrName);
                eventEav.getAttrVals().put(attr, this.eavCommService.getObjectByType(attr.getAttrType(), attr, attrRawVal));
            }
        }
        this.eventEavDAO.merge((Object)eventEav);
    }

    @Override
    @Transactional
    public Map<String, String> findEventEav(EventEavDTO dto) {
        Map attributeVals = null;
        EventEav eventEav = (EventEav)((Object)this.eventEavDAO.findUniqueBy("eno", dto.getEno()));
        if (eventEav != null) {
            attributeVals = this.eavCommService.attributeValue2String(eventEav.getAttrVals());
        }
        return attributeVals;
    }
}

