/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.tools.dao.IEventTaskDAO;
import com.sinba.common.tools.dto.EventTaskDTO;
import com.sinba.common.tools.dto.EventTaskQueryDTO;
import com.sinba.common.tools.entity.EventTask;
import com.sinba.common.tools.service.IEventTaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EventTaskService
implements IEventTaskService {
    @Autowired
    private IEventTaskDAO eventTaskDAO;

    @Transactional
    public PageDTO findPagerEventTask(EventTaskQueryDTO queryDto, int start, int limit) {
        PageDTO p = this.eventTaskDAO.findPagerEventTask(queryDto, start, limit);
        List entities = p.getData();
        ArrayList<EventTaskDTO> dtos = new ArrayList<EventTaskDTO>(entities.size());
        for (EventTask entity : entities) {
            EventTaskDTO eventTaskDto = new EventTaskDTO();
            EventTaskDTO.entity2dto((Object)((Object)entity), (Object)((Object)eventTaskDto));
            dtos.add(eventTaskDto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public void saveEventTask(EventTaskDTO dto) {
        EventTask eventTask = new EventTask();
        EventTaskDTO.dto2entity((Object)((Object)dto), (Object)((Object)eventTask));
        eventTask.setCreateTime(new Date());
        this.eventTaskDAO.save((Object)eventTask);
        dto.setTaskId(eventTask.getTaskId());
    }

    @Transactional
    public void editEventTask(EventTaskDTO dto) {
        EventTask eventTask = new EventTask();
        EventTaskDTO.dto2entity((Object)((Object)dto), (Object)((Object)eventTask));
        this.eventTaskDAO.merge((Object)eventTask);
    }

    @Transactional
    public void deleteEventTask(Long[] ids) {
        this.eventTaskDAO.deleteByIds(ids);
    }
}

