/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.tools.dao.IInstantMessageDAO;
import com.sinba.common.tools.dto.InstantMessageDTO;
import com.sinba.common.tools.dto.InstantMessageQueryDTO;
import com.sinba.common.tools.entity.InstantMessage;
import com.sinba.common.tools.service.IInstantMessageService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantMessageService
implements IInstantMessageService {
    @Autowired
    private IInstantMessageDAO instantmessageDAO;

    @Override
    @Transactional
    public List<InstantMessageDTO> findAllInstantMessage() {
        List entites = this.instantmessageDAO.findAll();
        ArrayList<InstantMessageDTO> dtos = new ArrayList<InstantMessageDTO>(entites.size());
        for (InstantMessage entity : entites) {
            InstantMessageDTO dto = new InstantMessageDTO();
            InstantMessageService.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<InstantMessageDTO> findAllIMLikeTitle(String title) {
        List<InstantMessage> instantmessage = this.instantmessageDAO.findByKeyWord(title);
        ArrayList<InstantMessageDTO> dtos = new ArrayList<InstantMessageDTO>(instantmessage.size());
        for (InstantMessage entity : instantmessage) {
            InstantMessageDTO dto = new InstantMessageDTO();
            InstantMessageService.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public void saveInstantMessage(InstantMessageDTO dto) {
        InstantMessage entity = new InstantMessage();
        InstantMessageService.dto2entity(dto, entity);
        this.instantmessageDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public void removeInstantMessage(Long[] id) {
        this.instantmessageDAO.deleteByIds(id);
    }

    @Override
    @Transactional
    public void updateInstantMessage(InstantMessageDTO dto) {
        InstantMessage entity = (InstantMessage)((Object)this.instantmessageDAO.findById(dto.getImId()));
        if (dto.getTitle() != null) {
            entity.setTitle(dto.getTitle());
        }
        if (dto.getContent() != null) {
            entity.setContent(dto.getContent());
        }
        if (dto.getRemarks() != null) {
            entity.setRemarks(dto.getRemarks());
        }
        if (dto.getDescription() != null) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.getStatus() != null) {
            entity.setStatus(dto.getStatus());
        }
    }

    @Override
    @Transactional
    public PageDTO findPagerIM(InstantMessageQueryDTO immanageQueryDTO, int start, int limit, String sidx, String sord) {
        PageDTO p = this.instantmessageDAO.findPager(immanageQueryDTO, start, limit, sidx, sord);
        List instantmessage = p.getData();
        ArrayList<InstantMessageDTO> dtos = new ArrayList<InstantMessageDTO>(instantmessage.size());
        for (InstantMessage entity : instantmessage) {
            InstantMessageDTO dto = new InstantMessageDTO();
            InstantMessageService.entity2dto(entity, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public int findUnreadIM() {
        int sum = this.instantmessageDAO.findUnread();
        return sum;
    }

    public static void dto2entity(InstantMessageDTO dto, InstantMessage entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(InstantMessage entity, InstantMessageDTO dto) {
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    public InstantMessage findInstantMessageById(Long id) {
        return (InstantMessage)((Object)this.instantmessageDAO.findById(id));
    }
}

