/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.tools.dao.ISMSAccountDAO;
import com.sinba.common.tools.dto.SMSMessageDTO;
import com.sinba.common.tools.entity.SMSAccount;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SMSHelper {
    private String id;
    private String pwd;
    private String sendUrl;
    private String queryUrl;
    private Integer smsLength;
    private Integer mobileCount;
    @Autowired
    private ISMSAccountDAO smsAccountDAO;

    public void initData() {
        List accounts = this.smsAccountDAO.findAll();
        if (accounts.size() <= 0) {
            return;
        }
        SMSAccount account = (SMSAccount)((Object)accounts.get(0));
        this.id = account.getUid();
        this.pwd = account.getPwd();
        this.sendUrl = account.getSendUrl();
        this.queryUrl = account.getQueryUrl();
        this.smsLength = account.getSmsLength();
        this.mobileCount = account.getMoblieCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postData(String host, String id, String pwd, String to, String content, String bookTime) {
        HttpURLConnection httpconn = null;
        String result = "-20";
        StringBuilder sb = new StringBuilder();
        sb.append(host);
        if (id != null) {
            sb.append("id=").append(id);
        }
        if (pwd != null) {
            sb.append("&pwd=").append(pwd);
        }
        if (to != null) {
            sb.append("&to=").append(to);
        }
        if (content != null) {
            try {
                sb.append("&content=").append(URLEncoder.encode(content, "gb2312"));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        if (bookTime != null) {
            sb.append("&time=").append(bookTime);
        }
        try {
            URL url = new URL(sb.toString());
            httpconn = (HttpURLConnection)url.openConnection();
            BufferedReader rd = new BufferedReader(new InputStreamReader(httpconn.getInputStream()));
            result = rd.readLine();
            rd.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpconn != null) {
                httpconn.disconnect();
                httpconn = null;
            }
        }
        return result;
    }

    public SMSMessageDTO SendSms(String mobile, String content, String bookTime) {
        String[] contentPath;
        int i;
        String[] mobilePath;
        int length;
        this.initData();
        SMSMessageDTO dto = new SMSMessageDTO();
        dto.setSendCount(0);
        dto.setCostMoney(0.0);
        dto.setTotalMoney(0.0);
        String[] mobiles = mobile.split(",");
        if (mobiles.length > this.mobileCount) {
            length = mobiles.length / this.mobileCount;
            if (mobiles.length % this.mobileCount > 0) {
                ++length;
            }
            mobilePath = new String[length];
            for (i = 0; i < length; ++i) {
                StringBuffer sbMob = new StringBuffer();
                int jj = (i + 1) * this.mobileCount;
                if (jj > mobiles.length) {
                    jj = mobiles.length;
                }
                for (int j = i * this.mobileCount; j < jj; ++j) {
                    sbMob.append(mobiles[j]);
                    if (j >= jj - 1) continue;
                    sbMob.append(",");
                }
                mobilePath[i] = sbMob.toString();
            }
        } else {
            mobilePath = new String[]{mobile};
        }
        if (content.length() > this.smsLength) {
            length = content.length() / this.smsLength;
            if (content.length() % this.smsLength != 0) {
                ++length;
            }
            contentPath = new String[length];
            for (i = 0; i < length; ++i) {
                int ii = (i + 1) * this.smsLength;
                if (ii > content.length()) {
                    ii = content.length();
                }
                contentPath[i] = content.substring(i * this.smsLength, ii);
            }
        } else {
            contentPath = new String[]{content};
        }
        block3: for (int i2 = 0; i2 < mobilePath.length; ++i2) {
            for (int j = 0; j < contentPath.length; ++j) {
                SMSMessageDTO redto = this.switchMsg(this.postData(this.sendUrl, this.id, this.pwd, mobilePath[i2].trim(), contentPath[j].trim(), bookTime));
                dto.setSendCount(dto.getSendCount() + redto.getSendCount());
                dto.setCostMoney(dto.getCostMoney() + redto.getCostMoney());
                dto.setTotalMoney(redto.getTotalMoney());
                dto.setStateMsg(redto.getStateMsg());
                dto.setSid(redto.getSid());
                if (redto.getTotalMoney() <= 0.0 && redto.getCostMoney() <= 0.0) continue block3;
            }
        }
        return dto;
    }

    public SMSMessageDTO queryMoney() {
        this.initData();
        String host = this.queryUrl + "uid=" + this.id;
        String totalMoney = this.postData(host, null, this.pwd, null, null, null);
        SMSMessageDTO dto = new SMSMessageDTO();
        dto.setId(this.id);
        dto.setTotalMoney(Double.parseDouble(totalMoney));
        return dto;
    }

    public SMSMessageDTO switchMsg(String msgInput) {
        SMSMessageDTO dto = new SMSMessageDTO();
        if (msgInput.indexOf("/") != -1) {
            String[] arr = msgInput.split("/");
            if (arr.length > 0) {
                switch (Integer.parseInt(arr[0])) {
                    case 0: {
                        dto.setStateMsg("\u4fe1\u606f\u53d1\u9001\u6210\u529f\uff01");
                        break;
                    }
                    case -1: {
                        dto.setStateMsg("\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5145\u503c\uff01");
                        break;
                    }
                    case -2: {
                        dto.setStateMsg("\u60a8\u7684id\u6709\u9519\u8bef\uff01");
                        break;
                    }
                    case -3: {
                        dto.setStateMsg("\u60a8\u7684\u5bc6\u7801\u9519\u8bef\uff01");
                        break;
                    }
                    case -4: {
                        dto.setStateMsg("\u7a0b\u5e8f\u5185\u90e8\u9519\u8bef\uff01");
                        break;
                    }
                    case -5: {
                        dto.setStateMsg("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u5bf9\uff01");
                        break;
                    }
                    case -6: {
                        dto.setStateMsg("\u77ed\u4fe1\u5185\u5bb9\u7f16\u7801\u9519\u8bef\uff01");
                        break;
                    }
                    case -7: {
                        dto.setStateMsg("\u77ed\u4fe1\u5305\u542b\u654f\u611f\u5b57\u7b26\uff01");
                        break;
                    }
                    case -10: {
                        dto.setStateMsg("\u624b\u673a\u53f7\u7801\u91cf\u8fc7\u591a\uff01");
                    }
                }
            }
            if (arr.length > 1) {
                dto.setSendCount(Integer.parseInt(arr[1].replace("Send:", "")));
            }
            if (arr.length > 2) {
                dto.setCostMoney(Double.parseDouble(arr[2].replace("Consumption:", "")));
            }
            if (arr.length > 3) {
                dto.setTotalMoney(Double.parseDouble(arr[3].replace("Tmoney:", "")));
            }
            if (arr.length > 4) {
                dto.setSid(arr[4].replace("sid:", ""));
            }
        }
        return dto;
    }

    public SMSMessageDTO testConnection(String uname, String pwd) {
        this.initData();
        String host = "http://service.winic.org:8009/webservice/public/remoney.asp?uid=" + uname + "&pwd=" + pwd;
        String totalMoney = this.postData(host, null, null, null, null, null);
        SMSMessageDTO dto = new SMSMessageDTO();
        dto.setTotalMoney(Double.parseDouble(totalMoney));
        return dto;
    }
}

