/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.tools.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.tools.dao.ITaskDAO;
import com.sinba.common.tools.dto.TaskDTO;
import com.sinba.common.tools.dto.TaskQueryDTO;
import com.sinba.common.tools.entity.Task;
import com.sinba.common.tools.service.ITaskService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService
implements ITaskService {
    @Autowired
    private ITaskDAO taskDao;

    @Override
    @Transactional
    public PageDTO findPagerTask(TaskQueryDTO taskQueryDto, int start, int limit, String sidx, String sord) {
        PageDTO p = this.taskDao.findPagerTaskDAO(taskQueryDto, start, limit, sidx, sord);
        List entities = p.getData();
        ArrayList<TaskDTO> dtos = new ArrayList<TaskDTO>(entities.size());
        for (Task entity : entities) {
            TaskDTO adto = new TaskDTO();
            TaskDTO.entity2dto((Object)((Object)entity), (Object)((Object)adto));
            dtos.add(adto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public void editTask(TaskDTO taskDto) {
        Task task = (Task)((Object)this.taskDao.findById(Long.valueOf(taskDto.getTaskId())));
        this.dto2entity(taskDto, task);
        this.taskDao.merge((Object)task);
    }

    public void dto2entity(TaskDTO taskDto, Task task) {
        task.setAllDay(taskDto.isAllDay());
        task.setEndTime(taskDto.getEndTime());
        task.setStartTime(taskDto.getStartTime());
        task.setIntroduction(taskDto.getIntroduction());
        task.setTitle(taskDto.getTitle());
        task.setLocation(taskDto.getLocation());
        task.setOwner(taskDto.getOwner());
        task.setTaskStatus(taskDto.getTaskStatus());
    }

    @Override
    @Transactional
    public void saveTask(TaskDTO taskDto) {
        Task task = new Task();
        TaskDTO.dto2entity((Object)((Object)taskDto), (Object)((Object)task));
        this.taskDao.save((Object)task);
    }

    @Override
    @Transactional
    public void deleteTask(Long[] taskIds) {
        this.taskDao.deleteByIds(taskIds);
    }

    @Override
    @Transactional
    public List<Task> findAllTask(TaskQueryDTO taskQueryDto) {
        List<Task> taskList = this.taskDao.findMyAllTask(taskQueryDto.getOwner());
        return taskList;
    }
}

