/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.attachment.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.config.attachment.entity.Attachment;
import com.sinba.common.config.attachment.service.IAttachmentService;
import com.sinba.common.config.util.AppConfigUtils;
import com.sinba.common.exception.ApplicationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;

public class AttachmentAction
extends ActionSupport {
    @Autowired
    private IAttachmentService attachmentService;
    private Long aid;
    private Long downloadAttachmentId;
    private InputStream downloadStream;
    private String downloadFileName;
    private String downloadContentType;

    public String getDownloadContentType() {
        return this.downloadContentType;
    }

    public InputStream getDownloadStream() {
        return this.downloadStream;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public Long getDownloadAttachmentId() {
        return this.downloadAttachmentId;
    }

    public void setDownloadAttachmentId(Long downloadAttachmentId) {
        this.downloadAttachmentId = downloadAttachmentId;
    }

    public Long getAid() {
        return this.aid;
    }

    public void setAid(Long aid) {
        this.aid = aid;
    }

    public String deleteAttachment() {
        this.attachmentService.delete(this.aid);
        return "success";
    }

    public String download() {
        Attachment attachment = this.attachmentService.findAttachmentById(this.downloadAttachmentId);
        String fileName = AppConfigUtils.getInstance().getAttachmentPath() + "/" + attachment.getUrl();
        File file = new File(fileName);
        if (!file.exists()) {
            throw new ApplicationException("ERROR_ATTACHMENT_NOT_EXISTS\n");
        }
        try {
            this.downloadStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException("ERROR_ATTACHMENT_FAIL_READ\n");
        }
        try {
            this.downloadFileName = new String(attachment.getAttachmentName().getBytes(), "ISO_8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException((Exception)e);
        }
        this.downloadContentType = "application/zip";
        return "downloadSuccess";
    }

    public String delete() {
        Attachment attachment = this.attachmentService.findAttachmentById(this.downloadAttachmentId);
        String fileName = AppConfigUtils.getInstance().getAttachmentPath() + "/" + attachment.getUrl();
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        return null;
    }
}

