/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.basicConfig.service;

import com.sinba.common.config.basicConfig.dao.ICurrencyDAO;
import com.sinba.common.config.basicConfig.dto.CurrencyDTO;
import com.sinba.common.config.basicConfig.dto.CurrencyQueryDTO;
import com.sinba.common.config.basicConfig.entity.Currency;
import com.sinba.common.config.basicConfig.service.ICurrencyService;
import com.sinba.common.dto.PageDTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CurrencyService
implements ICurrencyService {
    @Autowired
    private ICurrencyDAO currencyDAO;

    @Override
    @Transactional
    public PageDTO findCurrencyByPager(CurrencyQueryDTO qdto) {
        PageDTO p = this.currencyDAO.findCurrencyByPage(qdto);
        List entities = p.getData();
        ArrayList<CurrencyDTO> dtos = new ArrayList<CurrencyDTO>(entities.size());
        for (Currency entity : entities) {
            CurrencyDTO dto = new CurrencyDTO();
            CurrencyDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public void saveOrUpdateCurrency(CurrencyDTO dto) {
        if (dto.getIsDefault() != null && dto.getIsDefault().booleanValue()) {
            List allCurrency = this.currencyDAO.findAll();
            for (Currency c : allCurrency) {
                c.setIsDefault(false);
            }
            this.currencyDAO.mergeAll(allCurrency);
        }
        Currency currency = null;
        currency = dto.getCno() != null ? (Currency)((Object)this.currencyDAO.findById(dto.getCno())) : new Currency();
        CurrencyDTO.dto2entity((Object)((Object)dto), (Object)((Object)currency));
        if (dto.getCno() != null) {
            this.currencyDAO.update((Object)currency);
        } else {
            this.currencyDAO.save((Object)currency);
            dto.setCno(currency.getCno());
        }
    }

    @Override
    @Transactional
    public void deleteCurrencys(Long[] cons) {
        this.currencyDAO.deleteByIds(cons);
    }

    @Override
    @Transactional
    public String findDefaultCurrency() {
        String defaultCurrency = "";
        List<Currency> currencys = this.currencyDAO.findDefaultCurrency();
        if (currencys != null && currencys.size() > 0) {
            defaultCurrency = currencys.get(0).getSign();
        }
        return defaultCurrency;
    }

    @Override
    @Transactional
    public CurrencyDTO findById(long cno) {
        CurrencyDTO dto = new CurrencyDTO();
        Currency currency = (Currency)((Object)this.currencyDAO.findById(Long.valueOf(cno)));
        if (currency != null) {
            CurrencyDTO.entity2dto((Object)((Object)currency), (Object)((Object)dto));
        }
        return dto;
    }
}

