/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.category.service;

import com.sinba.common.config.category.dao.IEventCategoryDAO;
import com.sinba.common.config.category.dto.CategoryTreeViewDTO;
import com.sinba.common.config.category.dto.EventCategoryDTO;
import com.sinba.common.config.category.entity.EventCategory;
import com.sinba.common.config.category.service.IEventCategoryService;
import com.sinba.common.exception.ApplicationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EventCategoryService
implements IEventCategoryService {
    @Autowired
    private IEventCategoryDAO categoryDAO;

    private static void dto2entity(EventCategoryDTO dto, EventCategory entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private static void entity2dto(EventCategory entity, EventCategoryDTO dto) {
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public void saveEventCategory(EventCategoryDTO ecDTO) {
        EventCategory ecEtity = new EventCategory();
        EventCategoryService.dto2entity(ecDTO, ecEtity);
        if (ecDTO.getParentEventId() != null) {
            EventCategory parentTree = (EventCategory)((Object)this.categoryDAO.findById(ecDTO.getParentEventId()));
            ecEtity.setParentEvent(parentTree);
        }
        this.categoryDAO.save((Object)ecEtity);
        ecDTO.setEventId(ecEtity.getEventId());
    }

    @Override
    @Transactional
    public List<CategoryTreeViewDTO> findEventCategorys(String CategoryName) {
        ArrayList<CategoryTreeViewDTO> listDTOs = new ArrayList<CategoryTreeViewDTO>();
        List<EventCategory> listEntity = this.categoryDAO.findTreeViews(CategoryName);
        for (EventCategory ec : listEntity) {
            CategoryTreeViewDTO ctDTO = new CategoryTreeViewDTO();
            CategoryTreeViewDTO.entity2dto(ec, ctDTO);
            listDTOs.add(ctDTO);
        }
        return listDTOs;
    }

    @Override
    @Transactional
    public EventCategoryDTO findEventCategoryById(long eventId) {
        EventCategoryDTO ecDTO = new EventCategoryDTO();
        EventCategory entity = (EventCategory)((Object)this.categoryDAO.findById(Long.valueOf(eventId)));
        if (entity != null) {
            EventCategoryService.entity2dto(entity, ecDTO);
            if (entity.getParentEvent() != null) {
                EventCategory sonTree = entity.getParentEvent();
                ecDTO.setParentEventId(sonTree.getEventId());
                ecDTO.setParentEventName(sonTree.getEventName());
            }
        }
        return ecDTO;
    }

    @Override
    @Transactional
    public void mergeEventCategory(EventCategoryDTO ecDTO) {
        EventCategory entity = (EventCategory)((Object)this.categoryDAO.findById(ecDTO.getEventId()));
        if (ecDTO.getEventName() != null) {
            entity.setEventName(ecDTO.getEventName());
        }
        if (ecDTO.getEventDescription() != null) {
            entity.setEventDescription(ecDTO.getEventDescription());
        }
        if (ecDTO.getParentEventId() != null) {
            EventCategory sonTree = entity.getParentEvent();
            entity.setParentEvent(sonTree);
        }
        this.categoryDAO.merge((Object)entity);
    }

    @Override
    @Transactional
    public void updateEventCategory(EventCategoryDTO ec) {
        EventCategory entity = (EventCategory)((Object)this.categoryDAO.findById(ec.getEventId()));
        if (ec.getEventId() != null) {
            entity.setEventId(ec.getEventId());
        }
        if (ec.getEventName() != null) {
            entity.setEventName(ec.getEventName());
        }
        if (ec.getEventDescription() != null) {
            entity.setEventDescription(ec.getEventDescription());
        }
        if (ec.getParentEventId() != null) {
            EventCategory tv = (EventCategory)((Object)this.categoryDAO.findById(ec.getParentEventId()));
            entity.setParentEvent(tv);
        }
    }

    @Override
    @Transactional
    public void removeEventCategory(Long treeId) {
        this.categoryDAO.delete(this.categoryDAO.findById(treeId));
    }

    @Override
    @Transactional
    public void changeParent(EventCategoryDTO ec) {
        EventCategory entity = (EventCategory)((Object)this.categoryDAO.findById(ec.getEventId()));
        EventCategory parent = (EventCategory)((Object)this.categoryDAO.findById(ec.getParentEventId()));
        entity.setParentEvent(parent);
        this.categoryDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public EventCategoryDTO copyCategory(EventCategoryDTO ec) {
        EventCategory parent = (EventCategory)((Object)this.categoryDAO.findById(ec.getParentEventId()));
        EventCategory entity = (EventCategory)((Object)this.categoryDAO.findById(ec.getEventId()));
        EventCategory copy = new EventCategory();
        copy.setEventName(entity.getEventName());
        copy.setEventDescription(entity.getEventDescription());
        copy.setParentEvent(parent);
        this.categoryDAO.save((Object)copy);
        this.setChildren(copy, entity);
        EventCategoryDTO dto = new EventCategoryDTO();
        EventCategoryService.entity2dto(copy, dto);
        return dto;
    }

    @Transactional
    public void setChildren(EventCategory parent, EventCategory children) {
        if (children.getParentChildren() != null && children.getParentChildren().size() > 0) {
            for (EventCategory ec : children.getParentChildren()) {
                EventCategory newChildren = new EventCategory();
                newChildren.setEventName(ec.getEventName());
                newChildren.setEventDescription(ec.getEventDescription());
                newChildren.setParentEvent(parent);
                this.categoryDAO.save((Object)newChildren);
                this.setChildren(newChildren, ec);
            }
        }
    }
}

