/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.dictionary.service;

import com.sinba.common.config.dictionary.dao.IDataDictionaryGroupDAO;
import com.sinba.common.config.dictionary.dto.DataDictionaryGroupDTO;
import com.sinba.common.config.dictionary.dto.DataDictionaryGroupQueryDTO;
import com.sinba.common.config.dictionary.entity.DataDictionaryGroup;
import com.sinba.common.config.dictionary.service.IDataDictionaryGroupService;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DataDictionaryGroupService
implements IDataDictionaryGroupService {
    @Autowired
    private IDataDictionaryGroupDAO dataDictionaryGroupDAO;

    @Override
    @Transactional
    public PageDTO findDictionaryGroupByPage(DataDictionaryGroupQueryDTO redto) {
        PageDTO pageDTO = this.dataDictionaryGroupDAO.findpager(redto);
        List lists = pageDTO.getData();
        ArrayList<DataDictionaryGroupDTO> ddGroupDTOs = new ArrayList<DataDictionaryGroupDTO>(lists.size());
        for (DataDictionaryGroup ddGroup : lists) {
            DataDictionaryGroupDTO ddGroupDTO = new DataDictionaryGroupDTO();
            ddGroupDTO.setGroupName(ddGroup.getGroupName());
            ddGroupDTO.setGroupNo(ddGroup.getGroupNo());
            ddGroupDTOs.add(ddGroupDTO);
        }
        pageDTO.setData(ddGroupDTOs);
        return pageDTO;
    }

    @Override
    @Transactional
    public void saveDataDictionaryGroup(DataDictionaryGroupDTO dto) {
        DataDictionaryGroup entity = new DataDictionaryGroup();
        entity.setGroupNo(dto.getGroupNo());
        entity.setGroupName(dto.getGroupName());
        if (dto.getGroupCode() != null) {
            entity.setGroupCode(dto.getGroupCode());
        }
        this.dataDictionaryGroupDAO.save((Object)entity);
        dto.setGroupNo(entity.getGroupNo());
    }

    @Override
    @Transactional
    public void removeDataDictionaryGroup(Long no) {
        this.dataDictionaryGroupDAO.delete(this.dataDictionaryGroupDAO.findById(no));
    }

    @Override
    @Transactional
    public void removeDataDictionaryGroups(Long[] nos) {
        this.dataDictionaryGroupDAO.deleteByIds(nos);
    }

    @Override
    @Transactional
    public DataDictionaryGroupDTO mergeDataDictionaryGroup(DataDictionaryGroupDTO dto) {
        DataDictionaryGroup entity = new DataDictionaryGroup();
        this.dto2entity(dto, entity);
        entity.getDatadicItems().addAll(((DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(entity.getGroupNo()))).getDatadicItems());
        entity = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void updateDataDictionaryGroup(DataDictionaryGroupDTO dto) {
        if (dto.getGroupNo() != null && dto.getGroupName() != null) {
            DataDictionaryGroup entity = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(dto.getGroupNo()));
            this.dto2entity(dto, entity);
            this.dataDictionaryGroupDAO.update((Object)entity);
        }
    }

    @Override
    @Transactional
    public void mergeAllDataDictionaryGroup(List<DataDictionaryGroupDTO> dtos) {
        ArrayList<DataDictionaryGroup> entities = new ArrayList<DataDictionaryGroup>();
        for (DataDictionaryGroupDTO dto : dtos) {
            DataDictionaryGroup entity = new DataDictionaryGroup();
            this.dto2entity(dto, entity);
            entities.add(entity);
        }
        this.dataDictionaryGroupDAO.mergeAll(entities);
    }

    @Override
    public DataDictionaryGroupDTO findDataDictionaryGroupById(Long no) {
        DataDictionaryGroup entity = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(no));
        DataDictionaryGroupDTO dto = new DataDictionaryGroupDTO();
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    public List<DataDictionaryGroupDTO> findDataDictionaryGroupByName(String name) {
        List entities = this.dataDictionaryGroupDAO.findBy("groupName", name);
        ArrayList<DataDictionaryGroupDTO> dtos = new ArrayList<DataDictionaryGroupDTO>(entities.size());
        for (DataDictionaryGroup entity : entities) {
            DataDictionaryGroupDTO dto = new DataDictionaryGroupDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<DataDictionaryGroupDTO> findAllDataDictionaryGroup() {
        List<DataDictionaryGroup> entities = this.dataDictionaryGroupDAO.findDataDictionaryGroups();
        ArrayList<DataDictionaryGroupDTO> dtos = new ArrayList<DataDictionaryGroupDTO>();
        for (DataDictionaryGroup entity : entities) {
            DataDictionaryGroupDTO dto = new DataDictionaryGroupDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    private void dto2entity(DataDictionaryGroupDTO dto, DataDictionaryGroup entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(DataDictionaryGroup entity, DataDictionaryGroupDTO dto) {
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }
}

