/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.dictionary.service;

import com.sinba.common.config.dictionary.dao.IDataDictionaryGroupDAO;
import com.sinba.common.config.dictionary.dao.IDataDictionaryItemsDAO;
import com.sinba.common.config.dictionary.dto.DataDictionaryItemsDTO;
import com.sinba.common.config.dictionary.dto.DataDictionaryQueryDTO;
import com.sinba.common.config.dictionary.entity.DataDictionaryGroup;
import com.sinba.common.config.dictionary.entity.DataDictionaryItems;
import com.sinba.common.config.dictionary.service.IDataDictionaryItemsService;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.excel.ExcelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DataDictionaryItemsService
implements IDataDictionaryItemsService {
    @Autowired
    private IDataDictionaryItemsDAO dataDictionaryItemsDAO;
    @Autowired
    private IDataDictionaryGroupDAO dataDictionaryGroupDAO;

    @Override
    @Transactional
    public void saveDataDictionaryItems(DataDictionaryItemsDTO dto) {
        DataDictionaryItems entity = new DataDictionaryItems();
        this.dto2entity(dto, entity);
        if (dto.getGroupCode() != null) {
            DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findUniqueBy("groupCode", dto.getGroupCode()));
            entity.setDatadicGroup(group);
            if (group.getDatadicItems() == null) {
                ArrayList<DataDictionaryItems> datadicItems = new ArrayList<DataDictionaryItems>();
                group.setDatadicItems(datadicItems);
            }
            group.getDatadicItems().add(entity);
        }
        this.dataDictionaryItemsDAO.save((Object)entity);
        dto.setDcode(entity.getDcode());
    }

    @Override
    @Transactional
    public void removeDataDictionaryItems(Long no) {
        this.dataDictionaryItemsDAO.delete(this.dataDictionaryItemsDAO.findById(no));
    }

    @Override
    @Transactional
    public boolean removeDataDictionaryItemses(Long[] nos) {
        DataDictionaryItems dataItems;
        Byte delete = 1;
        boolean result = true;
        for (Long id : nos) {
            dataItems = (DataDictionaryItems)((Object)this.dataDictionaryItemsDAO.findById(id));
            if (!dataItems.getDataFlag().toString().equals(delete.toString())) continue;
            result = false;
        }
        if (result) {
            this.dataDictionaryItemsDAO.deleteByIds(nos);
            for (Long id : nos) {
                dataItems = (DataDictionaryItems)((Object)this.dataDictionaryItemsDAO.findById(id));
                dataItems.setDatadicGroup(null);
                this.dataDictionaryItemsDAO.merge((Object)dataItems);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public DataDictionaryItemsDTO mergeDataDictionaryItems(DataDictionaryItemsDTO dto) {
        DataDictionaryItems entity = (DataDictionaryItems)((Object)this.dataDictionaryItemsDAO.findById(dto.getDcode()));
        this.dto2entity(dto, entity);
        if (null != dto.getGroupNo()) {
            DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(dto.getGroupNo()));
            entity.setDatadicGroup(group);
        }
        entity = (DataDictionaryItems)((Object)this.dataDictionaryItemsDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void updataDataDictionaryItems(DataDictionaryItemsDTO dto) {
        if (dto.getDcode() != null) {
            DataDictionaryItems entity = (DataDictionaryItems)((Object)this.dataDictionaryItemsDAO.findById(dto.getDcode()));
            if (dto.getDescription() == null) {
                dto.setDescription(entity.getDescription());
            }
            if (dto.getDflag() == null) {
                dto.setDflag(entity.getDflag());
            }
            if (dto.getDname() == null) {
                dto.setDname(entity.getDname());
            }
            if (dto.getGroupNo() == null) {
                dto.setGroupNo(entity.getDatadicGroup().getGroupNo());
            }
            if (dto.getRemark() == null) {
                dto.setRemark(entity.getRemark());
            }
            this.dto2entity(dto, entity);
            if (null != dto.getGroupNo()) {
                DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(dto.getGroupNo()));
                entity.setDatadicGroup(group);
                dto.setGroupName(entity.getDatadicGroup().getGroupName());
            }
            this.dataDictionaryItemsDAO.update((Object)entity);
        }
    }

    @Override
    @Transactional
    public void mergeAllDataDictionaryItem(List<DataDictionaryItemsDTO> dtos) {
        ArrayList<DataDictionaryItems> entities = new ArrayList<DataDictionaryItems>();
        for (DataDictionaryItemsDTO dto : dtos) {
            DataDictionaryItems entity = new DataDictionaryItems();
            this.dto2entity(dto, entity);
            if (null != dto.getGroupNo()) {
                DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(dto.getGroupNo()));
                entity.setDatadicGroup(group);
                dto.setGroupName(entity.getDatadicGroup().getGroupName());
            }
            entities.add(entity);
        }
        this.dataDictionaryItemsDAO.mergeAll(entities);
    }

    @Override
    public DataDictionaryItemsDTO findDataDictionaryItemById(Long no) {
        DataDictionaryItems entity = (DataDictionaryItems)((Object)this.dataDictionaryItemsDAO.findById(no));
        DataDictionaryItemsDTO dto = new DataDictionaryItemsDTO();
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    public DataDictionaryItemsDTO findDataDictionaryItemByName(String name) {
        List entities = this.dataDictionaryItemsDAO.findBy("dname", name);
        DataDictionaryItemsDTO dto = null;
        for (DataDictionaryItems entity : entities) {
            dto = new DataDictionaryItemsDTO();
            this.entity2dto(entity, dto);
        }
        return dto;
    }

    @Override
    @Transactional
    public PageDTO findDictionaryItemsByPage(DataDictionaryQueryDTO dataDictionaryQueryDTO, int start, int limit, String sidx, String sord) {
        PageDTO p = this.dataDictionaryItemsDAO.findPager(dataDictionaryQueryDTO, start, limit, sidx, sord);
        List entities = p.getData();
        ArrayList<DataDictionaryItemsDTO> dtos = new ArrayList<DataDictionaryItemsDTO>(entities.size());
        for (DataDictionaryItems entity : entities) {
            DataDictionaryItemsDTO dto = new DataDictionaryItemsDTO();
            this.entity2dto(entity, dto);
            if (entity.getDatadicGroup() != null && entity.getDatadicGroup().getGroupCode() != null) {
                dto.setGroupCode(entity.getDatadicGroup().getGroupCode());
            }
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<DataDictionaryItemsDTO> findDataDictionaryItemByGroupNo(Long no) {
        DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findById(no));
        List<DataDictionaryItems> entities = group.getDatadicItems();
        ArrayList<DataDictionaryItemsDTO> dtos = new ArrayList<DataDictionaryItemsDTO>();
        for (DataDictionaryItems entity : entities) {
            DataDictionaryItemsDTO dto = new DataDictionaryItemsDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<DataDictionaryItemsDTO> findDictionaryItemByGroupCode(String code) {
        DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findUniqueBy("groupCode", code));
        List<DataDictionaryItems> entities = group.getDatadicItems();
        ArrayList<DataDictionaryItemsDTO> dtos = new ArrayList<DataDictionaryItemsDTO>();
        for (DataDictionaryItems entity : entities) {
            if (entity.getDataFlag() == 99) continue;
            DataDictionaryItemsDTO dto = new DataDictionaryItemsDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    private void dto2entity(DataDictionaryItemsDTO dto, DataDictionaryItems entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(DataDictionaryItems entity, DataDictionaryItemsDTO dto) {
        if (entity.getDatadicGroup() != null) {
            Long groupNo = entity.getDatadicGroup().getGroupNo();
            String groupName = entity.getDatadicGroup().getGroupName();
            dto.setGroupNo(groupNo);
            dto.setGroupName(groupName);
        }
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public InputStream exportDataDictionaryItems(DataDictionaryQueryDTO dataDictionaryQueryDTO, int start, int limit, String sidx, String sord) throws Exception {
        String sheetName = "\u6570\u636e\u5b57\u5178";
        String[] colNames = new String[]{"\u540d\u79f0", "\u63cf\u8ff0", "\u5907\u6ce8"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        PageDTO p = this.dataDictionaryItemsDAO.findPager(dataDictionaryQueryDTO, start, limit, sidx, sord);
        if (p != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            for (DataDictionaryItems item : entities) {
                data.add(new String[]{item.getDname(), item.getDescription(), item.getRemark()});
            }
            try {
                return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    @Override
    public Integer importDataDictionaryItems(DataDictionaryQueryDTO dataDictionaryQueryDTO) {
        block7: {
            File importFile = dataDictionaryQueryDTO.getImportFile();
            String sheetName = "\u6570\u636e\u5b57\u5178";
            List data = null;
            try {
                data = ExcelUtil.readSheet((String)sheetName, (InputStream)new FileInputStream(importFile));
            }
            catch (Exception e) {
                return -1;
            }
            try {
                if (data == null || data.size() <= 0) break block7;
                int count = 0;
                try {
                    for (String[] rowData : data) {
                        DataDictionaryItems entity = new DataDictionaryItems();
                        entity.setDname(rowData[0].toString());
                        entity.setDescription(rowData[1].toString());
                        entity.setRemark(rowData[2].toString());
                        DataDictionaryGroup group = (DataDictionaryGroup)((Object)this.dataDictionaryGroupDAO.findUniqueBy("groupCode", dataDictionaryQueryDTO.getGroupCode()));
                        entity.setDatadicGroup(group);
                        this.dataDictionaryItemsDAO.save((Object)entity);
                        ++count;
                    }
                }
                catch (Exception e) {
                    return -2;
                }
                return count;
            }
            catch (Exception e) {
                return -2;
            }
        }
        return 0;
    }
}

