/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.onlinelog.aop;

import com.sinba.common.config.onlinelog.dto.ADTO;
import com.sinba.common.config.onlinelog.entity.UserOptLog;
import com.sinba.common.config.onlinelog.service.IUserOptLogServiceUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Aspect
public class UserOptLogAspect {
    public static final String EXP_EDP = " && ! within(com.sinba.itsm.onlinelog.service.UserOptLogAspect)";
    public static final String EDP = "execution(* com.sinba..*Service.*(..))";
    private static final Logger LOGGER = Logger.getLogger(UserOptLogAspect.class);
    @Autowired
    private IUserOptLogServiceUtil useroptlogService;

    @Pointcut(value="execution(* com.sinba..*Service.*(..))")
    private void serviceMethod() {
    }

    public String getUsername() {
        String username = "Unknown user";
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        }
        return username;
    }

    public Long getDtoId(Object[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Long dtoId = null;
        if (args.length == 1) {
            Object arg = args[0];
            ADTO adto = arg.getClass().getAnnotation(ADTO.class);
            if (adto != null) {
                String idName = adto.id();
                dtoId = (Long)PropertyUtils.getSimpleProperty((Object)arg, (String)idName);
            } else if (arg instanceof Long) {
                dtoId = (Long)arg;
            }
        }
        return dtoId;
    }

    @After(value="execution(* com.sinba..*Service.*(..))")
    public void logUserOpt(JoinPoint jp) {
        String methodName = jp.getSignature().getName();
        String resourceName = jp.getTarget().getClass().getName();
        if (resourceName.endsWith("Service")) {
            int s = resourceName.lastIndexOf(".") + 1;
            int e = resourceName.lastIndexOf("Service");
            resourceName = resourceName.substring(s, e);
        }
        Long dtoId = null;
        try {
            dtoId = this.getDtoId(jp.getArgs());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UserOptLog log = new UserOptLog();
        log.setUserName(this.getUsername());
        log.setTime(new Date());
        log.setMethodName(methodName);
        log.setResourceName(resourceName);
        log.setResourceId(dtoId);
        this.useroptlogService.saveUserOptLog(log);
    }
}

