/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.onlinelog.dao;

import com.sinba.common.config.onlinelog.dao.IUserOnlineLogDAO;
import com.sinba.common.config.onlinelog.dto.UserOnlineLogQueryDTO;
import com.sinba.common.config.onlinelog.entity.UserOnlineLog;
import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.util.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class UserOnlineLogDAO
extends BaseDAOImplHibernate<UserOnlineLog>
implements IUserOnlineLogDAO {
    @Override
    public UserOnlineLog findBySessionId(String sid) {
        return (UserOnlineLog)super.findUniqueBy("sessionId", (Object)sid);
    }

    @Override
    public PageDTO findPager(UserOnlineLogQueryDTO useronlinelogQueryDTO, int start, int limit) {
        DetachedCriteria dc = DetachedCriteria.forClass(UserOnlineLog.class);
        dc.addOrder(Order.desc((String)"offlineTime"));
        if (useronlinelogQueryDTO != null) {
            if (useronlinelogQueryDTO.getOnlineTimeStart() != null) {
                dc.add((Criterion)Restrictions.gt((String)"onlineTime", (Object)useronlinelogQueryDTO.getOnlineTimeStart()));
            }
            if (useronlinelogQueryDTO.getOnlineTimeEnd() != null) {
                dc.add((Criterion)Restrictions.lt((String)"onlineTime", (Object)useronlinelogQueryDTO.getOnlineTimeEnd()));
            }
            if (useronlinelogQueryDTO.getOfflineTimeStart() != null) {
                dc.add((Criterion)Restrictions.gt((String)"offlineTime", (Object)useronlinelogQueryDTO.getOfflineTimeStart()));
            }
            if (useronlinelogQueryDTO.getOfflineTimeEnd() != null) {
                dc.add((Criterion)Restrictions.lt((String)"offlineTime", (Object)useronlinelogQueryDTO.getOfflineTimeEnd()));
            }
            if (StringUtils.hasText((String)useronlinelogQueryDTO.getUserName())) {
                dc.add((Criterion)Restrictions.like((String)"userName", (String)useronlinelogQueryDTO.getUserName(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        dc.addOrder(Order.desc((String)"id"));
        return super.findPageByCriteria(dc, start, limit);
    }
}

