/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.onlinelog.service;

import com.sinba.common.config.onlinelog.dao.IUserOnlineLogDAO;
import com.sinba.common.config.onlinelog.dto.UserOnlineLogDTO;
import com.sinba.common.config.onlinelog.dto.UserOnlineLogQueryDTO;
import com.sinba.common.config.onlinelog.entity.UserOnlineLog;
import com.sinba.common.config.onlinelog.service.IUserOnlineLogService;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class UserOnlineLogService
implements IUserOnlineLogService {
    @Autowired
    private IUserOnlineLogDAO useronlinelogDAO;

    @Override
    @Transactional
    public String getUserName(String sessionId) {
        UserOnlineLog entity = this.useronlinelogDAO.findBySessionId(sessionId);
        if (entity != null) {
            return entity.getUserName();
        }
        return null;
    }

    @Override
    @Transactional
    public void online(UserOnlineLogDTO dto) {
        UserOnlineLog entity = new UserOnlineLog();
        UserOnlineLogService.dto2entity(dto, entity);
        this.useronlinelogDAO.save(entity);
    }

    @Override
    @Transactional
    public void offline(String sessionId) {
        UserOnlineLog entity = this.useronlinelogDAO.findBySessionId(sessionId);
        if (entity != null) {
            Date date = new Date();
            entity.setOfflineTime(date);
            this.useronlinelogDAO.save(entity);
        }
    }

    @Override
    public PageDTO findUserOnlineByPager(UserOnlineLogQueryDTO useronlinelogQueryDTO, int start, int limit) {
        PageDTO p = this.useronlinelogDAO.findPager(useronlinelogQueryDTO, start, limit);
        List useronlinelog = p.getData();
        ArrayList<UserOnlineLogDTO> dtos = new ArrayList<UserOnlineLogDTO>(useronlinelog.size());
        for (UserOnlineLog entity : useronlinelog) {
            UserOnlineLogDTO dto = new UserOnlineLogDTO();
            UserOnlineLogService.entity2dto(entity, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    private static void dto2entity(UserOnlineLogDTO dto, UserOnlineLog entity) {
        try {
            BeanUtils.copyProperties((Object)entity, (Object)dto);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private static void entity2dto(UserOnlineLog entity, UserOnlineLogDTO dto) {
        try {
            BeanUtils.copyProperties((Object)dto, (Object)entity);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }
}

