/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.onlinelog.service;

import com.sinba.common.config.onlinelog.dao.UserOptLogDAO;
import com.sinba.common.config.onlinelog.dto.UserOptLogDTO;
import com.sinba.common.config.onlinelog.dto.UserOptLogQueryDTO;
import com.sinba.common.config.onlinelog.entity.UserOptLog;
import com.sinba.common.config.onlinelog.service.IUserOptLogServiceUtil;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class UserOptLogServiceUtil
implements IUserOptLogServiceUtil {
    @Autowired
    private UserOptLogDAO useroptlogDAO;

    @Override
    @Transactional
    public PageDTO findUserOptLogByPager(UserOptLogQueryDTO useroptlogQueryDTO, int start, int limit) {
        PageDTO p = this.useroptlogDAO.findPager(useroptlogQueryDTO, start, limit);
        List useroptlog = p.getData();
        ArrayList<UserOptLogDTO> dtos = new ArrayList<UserOptLogDTO>(useroptlog.size());
        for (UserOptLog entity : useroptlog) {
            UserOptLogDTO dto = new UserOptLogDTO();
            UserOptLogServiceUtil.entity2dto(entity, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public void saveUserOptLog(UserOptLog entity) {
        this.useroptlogDAO.save(entity);
    }

    @Override
    @Transactional
    public void saveUserOptLog(UserOptLogDTO dto) {
        System.out.println(dto.getUserName());
        UserOptLog entity = new UserOptLog();
        UserOptLogServiceUtil.dto2entity(dto, entity);
        this.useroptlogDAO.save(entity);
    }

    public static void dto2entity(UserOptLogDTO dto, UserOptLog entity) {
        try {
            BeanUtils.copyProperties((Object)entity, (Object)dto);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(UserOptLog entity, UserOptLogDTO dto) {
        try {
            BeanUtils.copyProperties((Object)dto, (Object)entity);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }
}

