/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.register.service;

import com.sinba.common.exception.ApplicationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RegisterService {
    private static String REG_FILE_PATH = RegisterService.class.getResource("/").getPath() + "com/sinba/itsm/config/updatelevel/action/UpdateLevelUtils.smcf";
    public static boolean overdue = false;
    public static final Integer DUE_DAY = 30;
    public static Integer usedDay = -2;
    private SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Boolean initTag = false;

    public RegisterService() {
        REG_FILE_PATH = REG_FILE_PATH.replace("%20", " ");
        if (!initTag.booleanValue()) {
            this.checkRegister();
            initTag = true;
        }
    }

    public void checkRegister() {
        List<String> regInfo = RegisterService.encodeRegisterInfo();
        if (regInfo == null || regInfo.size() < 3) {
            overdue = true;
        } else {
            try {
                String startTimeString = regInfo.get(0);
                String endTimeString = regInfo.get(1);
                Date endTime = this.fmt.parse(endTimeString);
                usedDay = Integer.parseInt(regInfo.get(2));
                if ("2011-05-01 12:28:38".equals(startTimeString) && "2011-05-07 23:12:33".equals(endTimeString) && -1 == usedDay) {
                    this.initRegisterInfo();
                    return;
                }
                if (usedDay > DUE_DAY) {
                    overdue = true;
                    return;
                }
                if (endTime.before(new Date())) {
                    overdue = true;
                    regInfo.set(2, DUE_DAY + "");
                    this.writeFile(regInfo);
                    return;
                }
                if (initTag.booleanValue()) {
                    regInfo.set(2, usedDay + 1 + "");
                    this.writeFile(regInfo);
                }
            }
            catch (Exception ex) {
                overdue = true;
                throw new ApplicationException("REG_FILE_CONTENT_ERROR\n::" + REG_FILE_PATH + "\n" + ex);
            }
        }
    }

    public void initRegisterInfo() {
        String regDate = this.fmt.format(new Date());
        GregorianCalendar overdueDateCl = new GregorianCalendar();
        overdueDateCl.setTime(new Date());
        overdueDateCl.set(5, overdueDateCl.get(5) + DUE_DAY);
        String overdueDate = this.fmt.format(overdueDateCl.getTime());
        ArrayList<String> initStr = new ArrayList<String>();
        initStr.add(regDate);
        initStr.add(overdueDate);
        initStr.add("0");
        this.writeFile(initStr);
    }

    public String encode(String str) {
        BASE64Encoder b = new BASE64Encoder();
        return b.encode(str.getBytes());
    }

    public static String decode(String str) throws Exception {
        BASE64Decoder bd = new BASE64Decoder();
        byte[] bt = bd.decodeBuffer(str);
        return new String(bt);
    }

    public void writeFile(List<String> strList) {
        try {
            File f = new File(REG_FILE_PATH);
            f.delete();
            BufferedWriter output = new BufferedWriter(new FileWriter(f));
            for (String s : strList) {
                output.write(this.encode(s) + "\n");
            }
            output.close();
        }
        catch (Exception e) {
            throw new ApplicationException("WRITE_REG_FILE_ERROR\n::" + REG_FILE_PATH);
        }
    }

    public static List<String> encodeRegisterInfo() {
        try {
            ArrayList<String> strList = new ArrayList<String>();
            BufferedReader in = new BufferedReader(new FileReader(new File(REG_FILE_PATH)));
            String line = null;
            while ((line = in.readLine()) != null) {
                strList.add(RegisterService.decode(line));
            }
            return strList;
        }
        catch (Exception ex) {
            throw new ApplicationException("READ_REG_FILE_ERROR\n" + ex);
        }
    }
}

