/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.config.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.struts2.ServletActionContext;

public class AppConfigUtils
extends Properties {
    private static AppConfigUtils instance = new AppConfigUtils();

    protected AppConfigUtils() {
        InputStream inp = AppConfigUtils.class.getResourceAsStream("/config.properties");
        try {
            if (inp != null) {
                this.load(inp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static AppConfigUtils getInstance() {
        return instance;
    }

    public static String getPhysicPath(String relativePath) {
        String physicPath = null;
        if (relativePath == null) {
            relativePath = "";
        }
        if (new File(relativePath).isAbsolute()) {
            physicPath = relativePath;
        } else {
            ServletContext servletContext = null;
            try {
                servletContext = ServletActionContext.getServletContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            physicPath = servletContext != null ? servletContext.getRealPath(relativePath) : AppConfigUtils.class.getResource("/").getPath() + relativePath;
        }
        File file = new File(physicPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        physicPath = physicPath.replace("%20", " ");
        return physicPath;
    }

    public String getConfigPath(String paramName, String defaultPath) {
        String basePath = "";
        if (instance != null && instance.containsKey(paramName)) {
            basePath = instance.getProperty(paramName);
        }
        if (StringUtils.isEmpty((String)basePath)) {
            basePath = defaultPath;
        }
        basePath = AppConfigUtils.getPhysicPath(basePath);
        basePath = basePath.replace("%20", " ");
        return basePath;
    }

    public String getDroolsFilePath() {
        String basePath = this.getConfigPath("droolsPath", "drools/drl");
        return basePath;
    }

    public String getImagePath() {
        String basePath = this.getConfigPath("imagePath", "/upload/images");
        return basePath;
    }

    public String getAttachmentPath() {
        String basePath = this.getConfigPath("attachmentPath", "attachments/");
        return basePath;
    }

    public String getReportPath() {
        String basePath = this.getConfigPath("jasperPath", "/jasper");
        return basePath;
    }

    public String getEmailAttachementPath() {
        return this.getAttachmentPath() + "email/";
    }

    public String getKnowledgeAttachementPath() {
        return this.getAttachmentPath() + "knowledge/";
    }

    public String getCIAttachementPath() {
        return this.getAttachmentPath() + "ci/";
    }

    public String getRequestAttachementPath() {
        return this.getAttachmentPath() + "request/";
    }

    public String getProblemAttachementPath() {
        return this.getAttachmentPath() + "problem/";
    }

    public String getChangeAttachementPath() {
        return this.getAttachmentPath() + "change/";
    }
}

