/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.eav.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.eav.dto.AttributesDTO;
import com.sinba.common.eav.dto.AttrsQueryDTO;
import com.sinba.common.eav.service.IAttributesService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesAction
extends ActionSupport {
    @Autowired
    private IAttributesService attributesService;
    private AttributesDTO attributesDTO;
    private AttrsQueryDTO attrsQueryDTO;
    private PageDTO attrsDto;
    private Long[] attrsIds;
    private int page = 1;
    private int rows = 10;
    private String entityType;
    private List<AttributesDTO> attributesDTOs;

    public AttributesDTO getAttributesDTO() {
        return this.attributesDTO;
    }

    public void setAttributesDTO(AttributesDTO attributesDTO) {
        this.attributesDTO = attributesDTO;
    }

    public AttrsQueryDTO getAttrsQueryDTO() {
        return this.attrsQueryDTO;
    }

    public void setAttrsQueryDTO(AttrsQueryDTO attrsQueryDTO) {
        this.attrsQueryDTO = attrsQueryDTO;
    }

    public PageDTO getAttrsDto() {
        return this.attrsDto;
    }

    public void setAttrsDto(PageDTO attrsDto) {
        this.attrsDto = attrsDto;
    }

    public Long[] getAttrsIds() {
        return this.attrsIds;
    }

    public void setAttrsIds(Long[] attrsIds) {
        this.attrsIds = attrsIds;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public List<AttributesDTO> getAttributesDTOs() {
        return this.attributesDTOs;
    }

    public void setAttributesDTOs(List<AttributesDTO> attributesDTOs) {
        this.attributesDTOs = attributesDTOs;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String find() {
        int start = (this.page - 1) * this.rows;
        this.attrsDto = this.attributesService.findPagerAttributes(this.attrsQueryDTO, start, this.rows);
        this.attrsDto.setRows(this.rows);
        this.attrsDto.setPage(this.page);
        return "success";
    }

    public String save() {
        this.attributesService.saveAttributes(this.attributesDTO);
        return "success";
    }

    public String update() {
        this.attributesService.updateAttributes(this.attributesDTO);
        return "success";
    }

    public String delete() {
        this.attributesService.deteleAttributes(this.attrsIds);
        return "success";
    }

    public String findAttributesByEavNo() {
        this.attributesDTOs = this.attributesService.findAttributesByEavNo(this.attrsQueryDTO.getEavNo());
        return "attributesDTOs";
    }

    public String findAttributesByEntityType() {
        this.attributesDTOs = this.attributesService.findAttributesByEntityType(this.entityType);
        return "attributesDTOs";
    }
}

