/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.eav.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.eav.dao.IAttributesDAO;
import com.sinba.common.eav.dao.IEavEntityDAO;
import com.sinba.common.eav.dto.AttributesDTO;
import com.sinba.common.eav.dto.AttrsQueryDTO;
import com.sinba.common.eav.entity.Attribute;
import com.sinba.common.eav.entity.EavEntity;
import com.sinba.common.eav.service.IAttributesService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesService
implements IAttributesService {
    @Autowired
    private IAttributesDAO attributesDAO;
    @Autowired
    private IEavEntityDAO eavEntityDAO;

    @Override
    @Transactional
    public PageDTO findPagerAttributes(AttrsQueryDTO attrsQueryDTO, int start, int limit) {
        PageDTO p = this.attributesDAO.findPager(attrsQueryDTO, start, limit);
        List attributes = p.getData();
        ArrayList<AttributesDTO> dtos = new ArrayList<AttributesDTO>(attributes.size());
        for (Attribute attr : attributes) {
            AttributesDTO attributesDTO = new AttributesDTO();
            attributesDTO.setAttrAsName(attr.getAttrAsName());
            attributesDTO.setAttrName(attr.getAttrName());
            attributesDTO.setAttrNo(attr.getAttrNo());
            attributesDTO.setAttrType(attr.getAttrType());
            attributesDTO.setLength(attr.getLength());
            attributesDTO.setEavNo(attr.getEavEntity().getEavNo());
            dtos.add(attributesDTO);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public void saveAttributes(AttributesDTO attributesDTO) {
        Attribute attributes = new Attribute();
        AttributesDTO.dto2entity((Object)((Object)attributesDTO), (Object)((Object)attributes));
        attributes.setAttrName("eav_" + new Date().getTime());
        EavEntity eavEntity = new EavEntity();
        eavEntity.setEavNo(attributesDTO.getEavNo());
        attributes.setEavEntity(eavEntity);
        this.attributesDAO.save((Object)attributes);
        attributesDTO.setAttrNo(attributes.getAttrNo());
    }

    @Override
    @Transactional
    public void updateAttributes(AttributesDTO attributesDTO) {
        if (attributesDTO.getAttrNo() != null) {
            Attribute attributes = (Attribute)((Object)this.attributesDAO.findById(attributesDTO.getAttrNo()));
            AttributesDTO.dto2entity((Object)((Object)attributesDTO), (Object)((Object)attributes));
            EavEntity eavEntity = new EavEntity();
            eavEntity.setEavNo(attributesDTO.getEavNo());
            attributes.setEavEntity(eavEntity);
            this.attributesDAO.update((Object)attributes);
        }
    }

    @Override
    @Transactional
    public void deteleAttributes(Long[] attrIds) {
        for (Long id : attrIds) {
            Attribute at = (Attribute)((Object)this.attributesDAO.findById(id));
            at.setEavEntity(null);
            this.attributesDAO.merge((Object)at);
        }
    }

    @Override
    @Transactional
    public List<AttributesDTO> findAttributesByEavNo(Long eavNo) {
        List<Attribute> list = this.attributesDAO.findByEavNo(eavNo);
        ArrayList<AttributesDTO> attributesDTOs = new ArrayList<AttributesDTO>();
        for (Attribute attr : list) {
            AttributesDTO attributesDTO = new AttributesDTO();
            AttributesDTO.entity2dto((Object)((Object)attr), (Object)((Object)attributesDTO));
            attributesDTOs.add(attributesDTO);
        }
        return attributesDTOs;
    }

    @Override
    @Transactional
    public List<AttributesDTO> findAttributesByEntityType(String entityType) {
        EavEntity eavEntity;
        ArrayList<AttributesDTO> attributesDTOs = new ArrayList<AttributesDTO>();
        if (entityType != null && !entityType.equals("") && (eavEntity = (EavEntity)((Object)this.eavEntityDAO.findUniqueBy("entityType", entityType))) != null) {
            List<Attribute> list = this.attributesDAO.findByEavNo(eavEntity.getEavNo());
            for (Attribute attr : list) {
                AttributesDTO attributesDTO = new AttributesDTO();
                AttributesDTO.entity2dto((Object)((Object)attr), (Object)((Object)attributesDTO));
                attributesDTOs.add(attributesDTO);
            }
        }
        return attributesDTOs;
    }

    @Override
    @Transactional
    public AttributesDTO findById(Long attrNo) {
        AttributesDTO dto = new AttributesDTO();
        Attribute entity = (Attribute)((Object)this.attributesDAO.findById(attrNo));
        AttributesDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        if (entity.getEavEntity() != null) {
            dto.setEavNo(entity.getEavEntity().getEavNo());
        }
        return dto;
    }
}

