/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.eav.service;

import com.sinba.common.eav.entity.Attribute;
import com.sinba.common.eav.entity.AttributeValue;
import com.sinba.common.eav.entity.AttributeValueDate;
import com.sinba.common.eav.entity.AttributeValueDouble;
import com.sinba.common.eav.entity.AttributeValueInteger;
import com.sinba.common.eav.entity.AttributeValueLob;
import com.sinba.common.eav.entity.AttributeValueString;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EavCommService {
    public AttributeValue getObjectByType(String type, Attribute attr, String attrRawVal) {
        AttributeValue attrValue = null;
        if (type.equals("String")) {
            AttributeValueString attrValue1 = new AttributeValueString();
            attrValue1.setAttribute(attr);
            attrValue1.setAttrValue(attrRawVal);
            attrValue = attrValue1;
        } else if (type.equals("Date")) {
            AttributeValueDate attrValueDate = new AttributeValueDate();
            attrValueDate.setAttribute(attr);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                String str = sdf.format(DateFormat.getDateInstance().parse(attrRawVal));
                Date cDate = sdf.parse(str);
                attrValueDate.setAttrValue(cDate);
            }
            catch (ParseException e) {
                // empty catch block
            }
            attrValue = attrValueDate;
        } else if (type.equals("Double")) {
            AttributeValueDouble attrValueDouble = new AttributeValueDouble();
            attrValueDouble.setAttribute(attr);
            try {
                attrValueDouble.setAttrValue(Double.parseDouble(attrRawVal));
            }
            catch (Exception e) {
                // empty catch block
            }
            attrValue = attrValueDouble;
        } else if (type.equals("Integer")) {
            AttributeValueInteger attributeValueIntegers = new AttributeValueInteger();
            attributeValueIntegers.setAttribute(attr);
            try {
                attributeValueIntegers.setAttrValue(Integer.parseInt(attrRawVal));
            }
            catch (Exception e) {
                // empty catch block
            }
            attrValue = attributeValueIntegers;
        } else if (type.equals("Lob")) {
            AttributeValueLob attributeValueLobs = new AttributeValueLob();
            attributeValueLobs.setAttribute(attr);
            attributeValueLobs.setAttrValue(attrRawVal);
            attrValue = attributeValueLobs;
        }
        return attrValue;
    }

    public Map<String, String> attributeValue2String(Map<Attribute, AttributeValue> attrVals) {
        HashMap<String, String> attributeVals = new HashMap<String, String>();
        String attrVal = null;
        if (attrVals != null) {
            for (Attribute attr : attrVals.keySet()) {
                AttributeValueLob attrValueLob;
                if (attr.getAttrType().equals("String")) {
                    AttributeValueString attrValue1 = (AttributeValueString)attrVals.get((Object)attr);
                    if (attrValue1.getAttrValue() != null) {
                        attrVal = attrValue1.getAttrValue();
                    }
                } else if (attr.getAttrType().equals("Date")) {
                    AttributeValueDate attrValueDate = (AttributeValueDate)attrVals.get((Object)attr);
                    if (attrValueDate.getAttrValue() != null) {
                        attrVal = attrValueDate.getAttrValue().toString();
                    }
                } else if (attr.getAttrType().equals("Double")) {
                    AttributeValueDouble attrValueDouble = (AttributeValueDouble)attrVals.get((Object)attr);
                    if (attrValueDouble.getAttrValue() != null) {
                        attrVal = attrValueDouble.getAttrValue().toString();
                    }
                } else if (attr.getAttrType().equals("Integer")) {
                    AttributeValueInteger attrValueInteger = (AttributeValueInteger)attrVals.get((Object)attr);
                    if (attrValueInteger.getAttrValue() != null) {
                        attrVal = attrValueInteger.getAttrValue().toString();
                    }
                } else if (attr.getAttrType().equals("Lob") && (attrValueLob = (AttributeValueLob)attrVals.get((Object)attr)).getAttrValue() != null) {
                    attrVal = attrValueLob.getAttrValue();
                }
                attributeVals.put(attr.getAttrName(), attrVal);
            }
        }
        return attributeVals;
    }
}

