/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.eav.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.eav.dao.IEavEntityDAO;
import com.sinba.common.eav.dto.EavEntityDTO;
import com.sinba.common.eav.entity.EavEntity;
import com.sinba.common.eav.service.IEavEntityService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EavEntityService
implements IEavEntityService {
    @Autowired
    private IEavEntityDAO eavEntityDAO;

    @Transactional
    public PageDTO findPagerEavEntity(int start, int limit, String sidx, String sord) {
        PageDTO pageDTO = this.eavEntityDAO.findPager(start, limit, sidx, sord);
        List eavEntitys = pageDTO.getData();
        ArrayList<EavEntityDTO> dtos = new ArrayList<EavEntityDTO>(eavEntitys.size());
        for (EavEntity entity : eavEntitys) {
            EavEntityDTO dto = new EavEntityDTO();
            dto.setEavNo(entity.getEavNo());
            dto.setEavName(entity.getEavName());
            dto.setEntityType(entity.getEntityType());
            dto.setDesc(entity.getDescription());
            dto.setAttributes(null);
            dtos.add(dto);
        }
        pageDTO.setData(dtos);
        return pageDTO;
    }

    @Transactional
    public boolean saveEavEntity(EavEntityDTO eavEntityDTO) {
        EavEntity eavEntity = new EavEntity();
        EavEntityDTO.dto2entity((Object)((Object)eavEntityDTO), (Object)((Object)eavEntity));
        eavEntity.setDescription(eavEntityDTO.getDesc());
        try {
            this.eavEntityDAO.save((Object)eavEntity);
            eavEntityDTO.setEavNo(eavEntity.getEavNo());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Transactional
    public boolean deleteEavEntity(Long[] eavNos) {
        boolean result = true;
        this.eavEntityDAO.deleteByIds(eavNos);
        return result;
    }

    public boolean updateEavEntity(EavEntityDTO eavEntityDTO) {
        EavEntity eavEntity = (EavEntity)((Object)this.eavEntityDAO.findById(eavEntityDTO.getEavNo()));
        EavEntityDTO.dto2entity((Object)((Object)eavEntityDTO), (Object)((Object)eavEntity));
        eavEntity.setDescription(eavEntityDTO.getDesc());
        try {
            this.eavEntityDAO.update((Object)eavEntity);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Transactional
    public EavEntityDTO findByEntityType(Long eavNo) {
        EavEntity eavEntity;
        EavEntityDTO eavEntityDTO = new EavEntityDTO();
        if (eavNo != null && (eavEntity = (EavEntity)((Object)this.eavEntityDAO.findById(eavNo))) != null) {
            eavEntityDTO.setEavNo(eavEntity.getEavNo());
            eavEntityDTO.setEavName(eavEntity.getEavName());
            eavEntityDTO.setEntityType(eavEntity.getEntityType());
        }
        return eavEntityDTO;
    }

    @Transactional
    public EavEntityDTO findById(Long eavNo) {
        EavEntityDTO dto = new EavEntityDTO();
        EavEntity entity = (EavEntity)((Object)this.eavEntityDAO.findById(eavNo));
        EavEntityDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        dto.setDesc(entity.getDescription());
        return dto;
    }
}

