/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.metadata;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import org.compass.core.config.binding.metadata.ClassMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistClassMetaData
implements ClassMetaData {
    private ClassFile classFile;
    private AnnotationsAttribute visible;
    private AnnotationsAttribute invisible;

    public JavassistClassMetaData(ClassFile classFile) {
        this.classFile = classFile;
        this.visible = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        this.invisible = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
    }

    @Override
    public String getClassName() {
        return this.classFile.getName();
    }

    @Override
    public boolean isInterface() {
        return this.classFile.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this.classFile.isAbstract();
    }

    @Override
    public boolean isConcrete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndependent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEnclosingClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getEnclosingClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSuperClass() {
        return this.classFile.getSuperclass() != null;
    }

    @Override
    public String getSuperClassName() {
        return this.classFile.getSuperclass();
    }

    @Override
    public String[] getInterfaceNames() {
        return this.classFile.getInterfaces();
    }

    @Override
    public Set<String> getAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        for (Annotation ann : this.visible.getAnnotations()) {
            types.add(ann.getTypeName());
        }
        return types;
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        if (this.visible != null && this.visible.getAnnotation(annotationType) != null) {
            return true;
        }
        return this.invisible != null && this.invisible.getAnnotation(annotationType) != null;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMetaAnnotation(String metaAnnotationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        throw new UnsupportedOperationException();
    }
}

