/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.support.AbstractResourceMapping;

public class CascadingMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (!(aliasMapping instanceof AbstractResourceMapping)) continue;
            AbstractResourceMapping resourceMapping = (AbstractResourceMapping)aliasMapping;
            ArrayList<Mapping> cascades = new ArrayList<Mapping>();
            Iterator<Mapping> it = resourceMapping.mappingsIt();
            while (it.hasNext()) {
                AbstractCollectionMapping cm;
                Mapping m = it.next();
                if (m instanceof CascadeMapping) {
                    cascades.add(m);
                    continue;
                }
                if (!(m instanceof AbstractCollectionMapping) || !((cm = (AbstractCollectionMapping)m).getElementMapping() instanceof CascadeMapping)) continue;
                cascades.add(cm.getElementMapping());
            }
            if (cascades.size() > 0) {
                resourceMapping.setCascades(cascades.toArray(new CascadeMapping[cascades.size()]));
                continue;
            }
            resourceMapping.setCascades(null);
        }
        return compassMapping;
    }
}

