/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ContextResourcePropertyConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicConverter<T>
implements ContextResourcePropertyConverter<T> {
    @Override
    public boolean marshall(Resource resource, T root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (root == null && !this.handleNulls(resourcePropertyMapping, context)) {
            return false;
        }
        String sValue = root instanceof String && context.getResourceFactory().isNullValue((String)root) ? (String)root : this.toString(root, resourcePropertyMapping, context);
        Property p = this.createProperty(sValue, resourcePropertyMapping, context);
        this.doSetBoost(p, root, resourcePropertyMapping, context);
        resource.addProperty(p);
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    @Override
    public T unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (resourcePropertyMapping.getStore() == Property.Store.NO) {
            return null;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null) {
            return null;
        }
        return this.fromString(p.getStringValue(), resourcePropertyMapping, context);
    }

    protected Property createProperty(String value, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return context.getResourceFactory().createProperty(value, resourcePropertyMapping);
    }

    protected boolean handleNulls(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.hasNullValue() || context.handleNulls();
    }

    protected String getNullValue(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.getNullValue();
    }

    protected boolean isNullValue(String value, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        if (value == null) {
            return true;
        }
        if (resourcePropertyMapping.hasNullValue()) {
            return resourcePropertyMapping.getNullValue().equals(value);
        }
        return value.length() == 0;
    }

    protected void doSetBoost(Property property, T root, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        property.setBoost(resourcePropertyMapping.getBoost());
    }

    @Override
    public String toString(T o, ResourcePropertyMapping resourcePropertyMapping) {
        return this.toString(o, resourcePropertyMapping, null);
    }

    @Override
    public String toString(T o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        String sValue;
        if (o != null) {
            if (o instanceof String) {
                try {
                    sValue = this.doToString(o, resourcePropertyMapping, context);
                }
                catch (ClassCastException e) {
                    sValue = (String)o;
                }
            } else {
                sValue = this.doToString(o, resourcePropertyMapping, context);
            }
        } else {
            sValue = this.getNullValue(resourcePropertyMapping, context);
        }
        return sValue;
    }

    protected String doToString(T o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return o.toString();
    }

    @Override
    public T fromString(String str, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        return this.fromString(str, resourcePropertyMapping, null);
    }

    @Override
    public T fromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        if (this.isNullValue(str, resourcePropertyMapping, context)) {
            return null;
        }
        return this.doFromString(str, resourcePropertyMapping, context);
    }

    protected abstract T doFromString(String var1, ResourcePropertyMapping var2, MarshallingContext var3) throws ConversionException;

    @Override
    public boolean canNormalize() {
        return false;
    }

    @Override
    public Property.Index suggestIndex() {
        return null;
    }

    @Override
    public Property.TermVector suggestTermVector() {
        return null;
    }

    @Override
    public Property.Store suggestStore() {
        return null;
    }

    @Override
    public Boolean suggestOmitNorms() {
        return null;
    }

    @Override
    public Boolean suggestOmitTf() {
        return null;
    }
}

