/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.dynamic;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractBasicConverter;
import org.compass.core.converter.basic.FormatConverter;
import org.compass.core.converter.dynamic.DynamicConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractDynamicConverter
extends AbstractBasicConverter
implements DynamicConverter {
    private FormatConverter formatConverter;
    private Class type;

    public DynamicConverter copy() {
        try {
            DynamicConverter converter = (DynamicConverter)this.getClass().newInstance();
            converter.setType(this.getType());
            converter.setFormatConverter(this.formatConverter);
            return converter;
        }
        catch (Exception e) {
            throw new ConversionException("This should not happen", e);
        }
    }

    public void setFormatConverter(FormatConverter formatConverter) {
        this.formatConverter = formatConverter;
    }

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (root == null) {
            return false;
        }
        Object value = this.evaluate(root, resourcePropertyMapping);
        if (value == null) {
            if (resourcePropertyMapping.hasNullValue()) {
                this.addProperty(resourcePropertyMapping.getNullValue(), resourcePropertyMapping, root, context, resource);
            }
            return false;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                this.addProperty(Array.get(value, i), resourcePropertyMapping, root, context, resource);
            }
        } else if (value instanceof Collection) {
            Collection colValues = (Collection)value;
            Iterator it = colValues.iterator();
            while (it.hasNext()) {
                this.addProperty(it.next(), resourcePropertyMapping, root, context, resource);
            }
        } else {
            this.addProperty(value, resourcePropertyMapping, root, context, resource);
        }
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    protected void addProperty(Object value, ResourcePropertyMapping resourcePropertyMapping, Object root, MarshallingContext context, Resource resource) {
        String sValue = this.formatConverter == null ? value.toString() : this.formatConverter.toString(value, resourcePropertyMapping);
        this.addProperty(sValue, resourcePropertyMapping, root, context, resource);
    }

    private void addProperty(String value, ResourcePropertyMapping resourcePropertyMapping, Object root, MarshallingContext context, Resource resource) {
        Property p = context.getResourceFactory().createProperty(value, resourcePropertyMapping);
        this.doSetBoost(p, root, resourcePropertyMapping, context);
        resource.addProperty(p);
    }

    protected abstract Object evaluate(Object var1, ResourcePropertyMapping var2) throws ConversionException;

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        return null;
    }

    protected Object doFromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        return null;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Property.Index suggestIndex() {
        if (this.formatConverter != null) {
            return this.formatConverter.suggestIndex();
        }
        return super.suggestIndex();
    }

    public Property.TermVector suggestTermVector() {
        if (this.formatConverter != null) {
            return this.formatConverter.suggestTermVector();
        }
        return super.suggestTermVector();
    }

    public Property.Store suggestStore() {
        if (this.formatConverter != null) {
            return this.formatConverter.suggestStore();
        }
        return super.suggestStore();
    }

    public Boolean suggestOmitNorms() {
        if (this.formatConverter != null) {
            return this.formatConverter.suggestOmitNorms();
        }
        return super.suggestOmitNorms();
    }

    public Boolean suggestOmitTf() {
        if (this.formatConverter != null) {
            return this.formatConverter.suggestOmitTf();
        }
        return super.suggestOmitTf();
    }
}

