/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.accessor.Getter;
import org.compass.core.accessor.Setter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.CollectionResourceWrapper;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.engine.utils.ResourceHelper;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.OsemMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.proxy.extractor.ProxyExtractorHelper;
import org.compass.core.util.reflection.ReflectionConstructor;
import org.compass.core.util.reflection.ReflectionFactory;

public class ClassMappingConverter
implements ResourceMappingConverter,
CompassConfigurable {
    public static final String ROOT_CLASS_MAPPING_KEY = "$rcmk";
    public static final String DISABLE_INTERNAL_MAPPINGS = "$dim";
    private static final Object DISABLE_INTERNAL_MAPPINGS_MARK = new Object();
    public static final String DISABLE_UID_MARSHALLING = "$disableUID";
    private Map<String, ReflectionConstructor> cachedConstructors = new ConcurrentHashMap<String, ReflectionConstructor>();
    private ProxyExtractorHelper proxyExtractorHelper;

    public void configure(CompassSettings settings) throws CompassException {
        this.proxyExtractorHelper = new ProxyExtractorHelper();
        this.proxyExtractorHelper.configure(settings);
    }

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        if (root instanceof Resource) {
            Resource rootResource = (Resource)root;
            resource.copy(rootResource);
            ((InternalResource)resource).addUID();
            return true;
        }
        Object disableInternalMappings = context.getAttribute(DISABLE_INTERNAL_MAPPINGS);
        boolean store = this.doMarshall(resource, root, mapping, context);
        context.setAttribute(DISABLE_INTERNAL_MAPPINGS, disableInternalMappings);
        return store;
    }

    protected boolean doMarshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        Object marshalled;
        ClassMapping classMapping = (ClassMapping)mapping;
        root = this.proxyExtractorHelper.initializeProxy(root);
        Object disableInternalMapings = context.getAttribute(DISABLE_INTERNAL_MAPPINGS);
        if (classMapping.isRoot()) {
            this.doSetBoost(resource, root, classMapping, context);
            context.setAttribute(ROOT_CLASS_MAPPING_KEY, classMapping);
            context.setAttribute(DISABLE_INTERNAL_MAPPINGS, null);
        } else if (!classMapping.isSupportUnmarshall()) {
            context.setAttribute(DISABLE_INTERNAL_MAPPINGS, DISABLE_INTERNAL_MAPPINGS_MARK);
        }
        if (root == null) {
            if (!classMapping.isSupportUnmarshall()) {
                return false;
            }
            if (!context.handleNulls()) {
                return false;
            }
            if (classMapping.getIdMappings().length == 0) {
                throw new ConversionException("Component mapping [" + classMapping.getAlias() + "] used within a collection/array and has null value, in such cases please define at least one id mapping on it");
            }
            boolean store = false;
            for (ResourcePropertyMapping id : classMapping.getResourceIdMappings()) {
                store |= id.getConverter().marshall(resource, context.getResourceFactory().getNullValue(), id, context);
            }
            return store;
        }
        if (classMapping.isPoly() && classMapping.getPolyClass() == null && (classMapping.isSupportUnmarshall() || classMapping.isRoot())) {
            this.storePolyClass(resource, root, classMapping, context);
        }
        if (classMapping.isSupportUnmarshall() && root.getClass().isEnum()) {
            this.storeEnumName(resource, root, classMapping, context);
        }
        if (classMapping.getIdMappings().length > 0) {
            IdsAliasesObjectKey idObjKey = new IdsAliasesObjectKey(classMapping, root);
            if (!idObjKey.hasNullId) {
                marshalled = context.getMarshalled(idObjKey);
                if (marshalled != null) {
                    if (!classMapping.isSupportUnmarshall()) {
                        return true;
                    }
                    if (classMapping.isFilterDuplicates().booleanValue()) {
                        Mapping[] ids = classMapping.getIdMappings();
                        boolean store = false;
                        for (int i = 0; i < ids.length; ++i) {
                            store |= ids[i].getConverter().marshall(resource, idObjKey.idsValues[i], ids[i], context);
                        }
                        return store;
                    }
                } else {
                    context.setMarshalled(idObjKey, root);
                    if (!classMapping.isSupportUnmarshall()) {
                        context.setMarshalled(new IdentityAliasedObjectKey(classMapping.getAlias(), root), root);
                    }
                }
            }
        } else if (!classMapping.isSupportUnmarshall()) {
            IdentityAliasedObjectKey key = new IdentityAliasedObjectKey(classMapping.getAlias(), root);
            marshalled = context.getMarshalled(key);
            if (marshalled != null) {
                return true;
            }
            context.setMarshalled(key, root);
        }
        boolean store = false;
        Iterator<Mapping> mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            Object value;
            context.setAttribute("current", root);
            OsemMapping m = (OsemMapping)mappingsIt.next();
            if (m.hasAccessors()) {
                Getter getter = ((ObjectMapping)m).getGetter();
                value = getter.get(root);
            } else {
                value = root;
            }
            store |= m.getConverter().marshall(resource, value, m, context);
        }
        if (classMapping.isRoot() && !context.hasAttribute(DISABLE_UID_MARSHALLING)) {
            ((InternalResource)resource).addUID();
        }
        context.setAttribute(DISABLE_INTERNAL_MAPPINGS, disableInternalMapings);
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        Property[] propIds;
        ClassMapping classMapping = (ClassMapping)mapping;
        ResourceKey resourceKey = null;
        if (classMapping.isRoot()) {
            if (!classMapping.isSupportUnmarshall()) {
                Object obj = this.constructObjectForUnmarshalling(classMapping, resource, context);
                for (Mapping id : classMapping.getIdMappings()) {
                    Object idValue = id.getConverter().unmarshall(resource, id, context);
                    if (idValue == null) {
                        return null;
                    }
                    if (((ObjectMapping)id).getSetter() == null) continue;
                    ((ObjectMapping)id).getSetter().set(obj, idValue);
                }
                return obj;
            }
            resourceKey = ((InternalResource)resource).getResourceKey();
            Object cached = context.getUnmarshalled(resourceKey);
            if (cached != null) {
                return cached;
            }
        } else if (classMapping.getIdMappings().length > 0 && (propIds = ResourceHelper.toIds(resource, classMapping, false)) != null) {
            resourceKey = new ResourceKey((ResourceMapping)classMapping, propIds);
            Object cached = context.getUnmarshalled(resourceKey);
            if (cached != null) {
                return cached;
            }
            boolean nullClass = true;
            for (Property propId : propIds) {
                if (context.getResourceFactory().isNullValue(propId.getStringValue())) continue;
                nullClass = false;
            }
            if (nullClass) {
                return null;
            }
            if (resource instanceof CollectionResourceWrapper) {
                CollectionResourceWrapper colWrapper = (CollectionResourceWrapper)resource;
                for (ResourcePropertyMapping id : classMapping.getResourceIdMappings()) {
                    colWrapper.rollbackGetProperty(id.getPath().getPath());
                }
            }
        }
        if (!classMapping.isSupportUnmarshall()) {
            return null;
        }
        Object obj = this.constructObjectForUnmarshalling(classMapping, resource, context);
        context.setAttribute("current", obj);
        if (resourceKey != null) {
            context.setUnmarshalled(resourceKey, obj);
            if (classMapping.isRoot()) {
                context.getSession().getFirstLevelCache().set(resourceKey, obj);
            }
        }
        boolean isNullClass = true;
        Iterator<Mapping> mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            context.setAttribute("current", obj);
            OsemMapping m = (OsemMapping)mappingsIt.next();
            if (m.hasAccessors()) {
                Object value;
                Setter setter = ((ObjectMapping)m).getSetter();
                if (setter == null || (value = m.getConverter().unmarshall(resource, m, context)) == null) continue;
                setter.set(obj, value);
                if (!m.controlsObjectNullability()) continue;
                isNullClass = false;
                continue;
            }
            m.getConverter().unmarshall(resource, m, context);
        }
        if (isNullClass) {
            return null;
        }
        return obj;
    }

    protected Object constructObjectForUnmarshalling(ClassMapping classMapping, Resource resource, MarshallingContext context) throws ConversionException {
        Object obj;
        Class clazz = classMapping.getClazz();
        ReflectionConstructor constructor = classMapping.getConstructor();
        if (classMapping.isPoly()) {
            if (classMapping.getPolyClass() != null) {
                clazz = classMapping.getPolyClass();
                constructor = classMapping.getPolyConstructor();
            } else {
                Property pClassName = resource.getProperty(classMapping.getClassPath().getPath());
                if (pClassName == null) {
                    return null;
                }
                String className = pClassName.getStringValue();
                if (className == null) {
                    return null;
                }
                constructor = this.cachedConstructors.get(className);
                if (constructor == null) {
                    try {
                        clazz = ClassUtils.forName(className, context.getSession().getCompass().getSettings().getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConversionException("Failed to create class [" + className + "] for unmarshalling", e);
                    }
                    constructor = ReflectionFactory.getDefaultConstructor(context.getSession().getCompass().getSettings(), clazz);
                    this.cachedConstructors.put(className, constructor);
                }
            }
        }
        if (clazz.isEnum()) {
            Property pEnumName = resource.getProperty(classMapping.getEnumNamePath().getPath());
            if (pEnumName == null) {
                return null;
            }
            String name = pEnumName.getStringValue();
            if (name == null) {
                return null;
            }
            obj = Enum.valueOf(clazz, name);
        } else {
            try {
                obj = constructor.newInstance();
            }
            catch (Exception e) {
                throw new ConversionException("Failed to create class [" + clazz.getName() + "] for unmarshalling", e);
            }
        }
        return obj;
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        boolean stored = false;
        Mapping[] ids = classMapping.getIdMappings();
        if (classMapping.getClazz().isAssignableFrom(id.getClass())) {
            for (Mapping rpId : ids) {
                ObjectMapping objectMapping = (ObjectMapping)rpId;
                stored |= this.convertId(classMapping, idResource, objectMapping.getGetter().get(id), rpId, context);
            }
        } else if (id instanceof Object[]) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load class with [" + Array.getLength(id) + "] mappings while has ids mappings of [" + ids.length + "]");
            }
            for (int i = 0; i < ids.length; ++i) {
                stored |= this.convertId(classMapping, idResource, Array.get(id, i), ids[i], context);
            }
        } else if (ids.length == 1) {
            stored = this.convertId(classMapping, idResource, id, ids[0], context);
        } else {
            String type = id.getClass().getName();
            throw new ConversionException("Cannot marshall ids, not supported id object type [" + type + "] and value [" + id + "], or you have not defined ids in the mapping files");
        }
        if (!context.hasAttribute(DISABLE_UID_MARSHALLING)) {
            ((InternalResource)idResource).addUID();
        }
        return stored;
    }

    private boolean convertId(ResourceMapping resourceMapping, Resource resource, Object root, Mapping mapping, MarshallingContext context) {
        ResourcePropertyConverter converter;
        if (root == null) {
            throw new ConversionException("Trying to marshall a null id [" + mapping.getName() + "] for alias [" + resourceMapping.getAlias() + "]");
        }
        if (root instanceof String && mapping instanceof ResourcePropertyMapping && mapping.getConverter() instanceof ResourcePropertyConverter && (converter = (ResourcePropertyConverter)mapping.getConverter()).canNormalize()) {
            root = converter.fromString((String)root, (ResourcePropertyMapping)mapping);
        }
        return mapping.getConverter().marshall(resource, root, mapping, context);
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        Mapping[] ids = classMapping.getIdMappings();
        Object[] idsValues = new Object[ids.length];
        if (id instanceof Resource) {
            Resource resource = (Resource)id;
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = ids[i].getConverter().unmarshall(resource, ids[i], context);
                if (idsValues[i] != null) continue;
                return null;
            }
        } else if (classMapping.getClazz().isAssignableFrom(id.getClass())) {
            for (int i = 0; i < ids.length; ++i) {
                ObjectMapping objectMapping = (ObjectMapping)ids[i];
                idsValues[i] = objectMapping.getGetter().get(id);
            }
        } else if (id instanceof Object[]) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load class with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = Array.get(id, i);
            }
        } else if (ids.length == 1) {
            idsValues[0] = id;
        } else {
            String type = id.getClass().getName();
            throw new ConversionException("Cannot marshall ids, not supported id object type [" + type + "] and value [" + id + "], or you have not defined ids in the mapping files");
        }
        return idsValues;
    }

    protected void doSetBoost(Resource resource, Object root, ClassMapping classMapping, MarshallingContext context) throws ConversionException {
        resource.setBoost(classMapping.getBoost());
    }

    protected void storePolyClass(Resource resource, Object root, ClassMapping classMapping, MarshallingContext context) {
        String className = this.getPolyClassName(root);
        Property p = context.getResourceFactory().createProperty(classMapping.getClassPath().getPath(), className, Property.Store.YES, Property.Index.NOT_ANALYZED);
        p.setOmitNorms(true);
        p.setOmitTf(true);
        resource.addProperty(p);
    }

    protected void storeEnumName(Resource resource, Object root, ClassMapping classMapping, MarshallingContext context) {
        String name = ((Enum)root).name();
        Property p = context.getResourceFactory().createProperty(classMapping.getEnumNamePath().getPath(), name, Property.Store.YES, Property.Index.NOT_ANALYZED);
        p.setOmitNorms(true);
        p.setOmitTf(true);
        resource.addProperty(p);
    }

    protected String getPolyClassName(Object root) {
        return this.proxyExtractorHelper.getTargetClass(root).getName();
    }

    protected static final class IdsAliasesObjectKey {
        private String alias;
        private Object[] idsValues;
        private boolean hasNullId;
        private int hashCode = Integer.MIN_VALUE;

        public IdsAliasesObjectKey(ClassMapping classMapping, Object value) {
            this.alias = classMapping.getAlias();
            Mapping[] ids = classMapping.getIdMappings();
            this.idsValues = new Object[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                OsemMapping m = (OsemMapping)ids[i];
                this.idsValues[i] = m.hasAccessors() ? ((ObjectMapping)m).getGetter().get(value) : value;
                if (this.idsValues[i] != null) continue;
                this.hasNullId = true;
            }
        }

        public Object[] getIdsValues() {
            return this.idsValues;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdsAliasesObjectKey)) {
                return false;
            }
            IdsAliasesObjectKey key = (IdsAliasesObjectKey)other;
            if (!key.alias.equals(this.alias)) {
                return false;
            }
            for (int i = 0; i < this.idsValues.length; ++i) {
                if (key.idsValues[i].equals(this.idsValues[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == Integer.MIN_VALUE) {
                this.hashCode = this.getHashCode();
            }
            return this.hashCode;
        }

        private int getHashCode() {
            int result = this.alias.hashCode();
            for (Object idValue : this.idsValues) {
                result = 29 * result + idValue.hashCode();
            }
            return result;
        }

        public boolean isHasNullId() {
            return this.hasNullId;
        }
    }

    protected static final class IdentityAliasedObjectKey {
        private String alias;
        private Integer objHashCode;
        private Object value;
        private int hashCode = Integer.MIN_VALUE;

        public IdentityAliasedObjectKey(String alias, Object value) {
            this.alias = alias;
            this.value = value;
            this.objHashCode = System.identityHashCode(value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdentityAliasedObjectKey)) {
                return false;
            }
            IdentityAliasedObjectKey idObjKey = (IdentityAliasedObjectKey)other;
            return idObjKey.value == this.value && idObjKey.alias.equals(this.alias);
        }

        public int hashCode() {
            if (this.hashCode == Integer.MIN_VALUE) {
                this.hashCode = 13 * this.objHashCode.hashCode() + this.alias.hashCode();
            }
            return this.hashCode;
        }
    }
}

