/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.engine;

import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.engine.SearchEngineTermFrequencies;

public interface SearchEngine {
    public SearchEngineFactory getSearchEngineFactory();

    public void setReadOnly();

    public boolean isReadOnly();

    public boolean onlyReadOperations();

    public void begin() throws SearchEngineException;

    public void prepare() throws SearchEngineException;

    public void commit(boolean var1) throws SearchEngineException;

    public boolean isWithinTransaction() throws SearchEngineException;

    public void rollback() throws SearchEngineException;

    public void flush() throws SearchEngineException;

    public void flushCommit(String ... var1) throws SearchEngineException;

    public boolean wasRolledBack() throws SearchEngineException;

    public boolean wasCommitted() throws SearchEngineException;

    public void close() throws SearchEngineException;

    public SearchEngineQueryBuilder queryBuilder() throws SearchEngineException;

    public SearchEngineQueryFilterBuilder queryFilterBuilder() throws SearchEngineException;

    public SearchEngineAnalyzerHelper analyzerHelper();

    public void create(Resource var1) throws SearchEngineException;

    public void save(Resource var1) throws SearchEngineException;

    public void delete(Resource var1) throws SearchEngineException;

    public void delete(SearchEngineQuery var1) throws SearchEngineException;

    public Resource load(Resource var1) throws SearchEngineException;

    public Resource get(Resource var1) throws SearchEngineException;

    public SearchEngineTermFrequencies termFreq(String[] var1, int var2, SearchEngineInternalSearch var3);

    public SearchEngineInternalSearch internalSearch(String[] var1, String[] var2) throws SearchEngineException;
}

