/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.similarity;

import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Similarity;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.lucene.engine.similarity.SimilarityFactory;
import org.compass.core.util.ClassUtils;

public class LuceneSimilarityManager
implements CompassConfigurable {
    private Similarity indexSimilarity;
    private Similarity searchSimilarity;

    public void configure(CompassSettings settings) throws CompassException {
        String defaultType = settings.getSetting("compass.engine.similarity.default.type", DefaultSimilarity.class.getName());
        this.indexSimilarity = this.createSimilarity(settings.getSetting("compass.engine.similarity.index.type", defaultType), settings);
        this.searchSimilarity = this.createSimilarity(settings.getSetting("compass.engine.similarity.search.type", defaultType), settings);
    }

    public Similarity getIndexSimilarity() {
        return this.indexSimilarity;
    }

    public Similarity getSearchSimilarity() {
        return this.searchSimilarity;
    }

    private Similarity createSimilarity(String type, CompassSettings settings) {
        Object similarityInstance;
        Class similarityClass;
        try {
            similarityClass = ClassUtils.forName(type, settings.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to create class of type [" + type + "]", e);
        }
        try {
            similarityInstance = similarityClass.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create instance of type [" + type + "]", e);
        }
        if (similarityInstance instanceof SimilarityFactory) {
            if (similarityInstance instanceof CompassConfigurable) {
                ((CompassConfigurable)similarityInstance).configure(settings);
            }
            similarityInstance = ((SimilarityFactory)similarityInstance).createSimilarity();
        }
        if (!(similarityInstance instanceof Similarity)) {
            throw new ConfigurationException("Type [" + type + "] is not an instance of Similarity");
        }
        if (similarityInstance instanceof CompassConfigurable) {
            ((CompassConfigurable)similarityInstance).configure(settings);
        }
        return (Similarity)similarityInstance;
    }
}

