/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.async;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.TransactionProcessor;
import org.compass.core.lucene.engine.transaction.TransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.async.AsyncTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.CommitCallable;
import org.compass.core.lucene.engine.transaction.support.PrepareCommitCallable;
import org.compass.core.lucene.engine.transaction.support.ResourceHashing;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJobs;
import org.compass.core.transaction.context.TransactionalCallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTransactionProcessorFactory
implements TransactionProcessorFactory,
CompassConfigurable,
SearchEngineFactoryAware {
    private static Log logger = LogFactory.getLog(AsyncTransactionProcessorFactory.class);
    private CompassSettings settings;
    private LuceneSearchEngineFactory searchEngineFactory;
    private LuceneSearchEngineIndexManager indexManager;
    private boolean processBeforeClose;
    private int concurrencyLevel;
    private long addTimeout;
    private int batchJobsSize;
    private long batchJobTimeout;
    private int nonBlockingBatchSize;
    private ResourceHashing hashing;
    private BlockingQueue<TransactionJobs> jobsToProcess;
    private Future pollingProcessorFuture;
    private volatile PollingProcessor pollingProcessor;
    private volatile boolean closed = false;

    @Override
    public void setSearchEngineFactory(SearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = (LuceneSearchEngineFactory)searchEngineFactory;
        this.indexManager = this.searchEngineFactory.getLuceneIndexManager();
    }

    @Override
    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
        this.jobsToProcess = new ArrayBlockingQueue<TransactionJobs>(settings.getSettingAsInt("compass.transaction.processor.async.backlog", 10), true);
        this.addTimeout = settings.getSettingAsTimeInMillis("compass.transaction.processor.async.addTimeout", 10000L);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async Transaction Processor will wait for [" + this.addTimeout + "ms] if backlog is full"));
        }
        this.batchJobsSize = settings.getSettingAsInt("compass.transaction.processor.async.batchJobSize", 5);
        this.batchJobTimeout = settings.getSettingAsTimeInMillis("compass.transaction.processor.async.batchJobSize", 100L);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async Transaction Processor blocking batch size is [" + this.batchJobsSize + "] with timeout of [" + this.batchJobTimeout + "ms]"));
        }
        this.nonBlockingBatchSize = settings.getSettingAsInt("compass.transaction.processor.async.nonBlockingBatchJobSize", 5);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async Transaction Processor non blocking batch size is [" + this.nonBlockingBatchSize + "]"));
        }
        this.processBeforeClose = settings.getSettingAsBoolean("compass.transaction.processor.async.processBeforeClose", true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async Transaction Processor process before close is set to [" + this.processBeforeClose + "]"));
        }
        this.concurrencyLevel = settings.getSettingAsInt("compass.transaction.processor.async.concurrencyLevel", 5);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async Transaction Processor will use [" + this.concurrencyLevel + "] concrrent threads to process transactions"));
        }
        this.hashing = ResourceHashing.fromName(settings.getSetting("compass.transaction.processor.async.hashing", "uid"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async Transaction Processor uses [" + (Object)((Object)this.hashing) + "] based hashing for concurrent processing"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting Async polling transaction processor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.processBeforeClose && this.pollingProcessor != null) {
            while (!this.jobsToProcess.isEmpty()) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        if (this.pollingProcessor != null) {
            try {
                this.pollingProcessor.close();
                this.pollingProcessorFuture.cancel(true);
                while (!this.pollingProcessor.isDone()) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                this.pollingProcessor = null;
                this.pollingProcessorFuture = null;
            }
        }
    }

    @Override
    public TransactionProcessor create(LuceneSearchEngine searchEngine) {
        return new AsyncTransactionProcessor(searchEngine, this);
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    public boolean remove(TransactionJobs jobs) throws SearchEngineException {
        return this.jobsToProcess.remove(jobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TransactionJobs jobs) throws SearchEngineException {
        if (this.pollingProcessor == null) {
            AsyncTransactionProcessorFactory asyncTransactionProcessorFactory = this;
            synchronized (asyncTransactionProcessorFactory) {
                if (this.pollingProcessor == null) {
                    this.pollingProcessor = new PollingProcessor();
                    this.pollingProcessorFuture = this.searchEngineFactory.getExecutorManager().submit(this.pollingProcessor);
                }
            }
        }
        try {
            boolean offered = this.jobsToProcess.offer(jobs, this.addTimeout, TimeUnit.MILLISECONDS);
            if (!offered) {
                throw new SearchEngineException("Failed to add jobs [" + System.identityHashCode(jobs) + "], queue is full and nothing empties it");
            }
        }
        catch (InterruptedException e) {
            throw new SearchEngineException("Failed to add jobs [" + System.identityHashCode(jobs) + "], interrupted", e);
        }
    }

    private void process(TransactionJobs jobs) throws InterruptedException {
        int i;
        HashSet<String> subIndexes = new HashSet<String>();
        List[] concurrentJobsToProcess = new List[this.concurrencyLevel];
        for (i = 0; i < concurrentJobsToProcess.length; ++i) {
            concurrentJobsToProcess[i] = new ArrayList();
        }
        this.addConcurrentJobsToProcess(concurrentJobsToProcess, subIndexes, jobs);
        for (i = 0; i < this.batchJobsSize && (jobs = this.jobsToProcess.poll(this.batchJobTimeout, TimeUnit.MILLISECONDS)) != null; ++i) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Batching additional Jobs [" + System.identityHashCode(jobs) + "]"));
            }
            this.addConcurrentJobsToProcess(concurrentJobsToProcess, subIndexes, jobs);
        }
        ArrayList nonBlockingDrainToList = new ArrayList();
        if (this.jobsToProcess.drainTo(nonBlockingDrainToList, this.nonBlockingBatchSize) > 0) {
            for (TransactionJobs transactionJobs : nonBlockingDrainToList) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Batching additional Jobs [" + System.identityHashCode(transactionJobs) + "]"));
                }
                this.addConcurrentJobsToProcess(concurrentJobsToProcess, subIndexes, transactionJobs);
            }
        }
        boolean failure = false;
        HashMap<String, IndexWriter> writers = new HashMap<String, IndexWriter>();
        for (String subIndex : subIndexes) {
            try {
                IndexWriter writer = this.indexManager.getIndexWritersManager().openIndexWriter(this.settings, subIndex);
                this.indexManager.getIndexWritersManager().trackOpenIndexWriter(subIndex, writer);
                writers.put(subIndex, writer);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to open index writer for sub index [" + subIndex + "]"), (Throwable)e);
                failure = true;
                break;
            }
        }
        if (failure) {
            this.closeWriters(writers);
            return;
        }
        ArrayList processCallables = new ArrayList();
        for (List list : concurrentJobsToProcess) {
            if (list.isEmpty()) continue;
            processCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new TransactionJobProcessor(list, writers)));
        }
        try {
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(processCallables, 1);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to index", (Throwable)e);
            failure = true;
        }
        if (failure) {
            this.rollbackWriters(writers);
            return;
        }
        ArrayList prepareCallables = new ArrayList();
        for (Map.Entry entry : writers.entrySet()) {
            prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new PrepareCommitCallable((String)entry.getKey(), (IndexWriter)entry.getValue())));
        }
        try {
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
        }
        catch (Exception e) {
            logger.warn((Object)"Faield to prepare commit", (Throwable)e);
            failure = true;
        }
        if (failure) {
            this.rollbackWriters(writers);
            return;
        }
        ArrayList commitCallables = new ArrayList();
        for (Map.Entry entry : writers.entrySet()) {
            commitCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new CommitCallable(this.indexManager, (String)entry.getKey(), (IndexWriter)entry.getValue(), this.isClearCacheOnCommit())));
        }
        try {
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(commitCallables, 1);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to commit", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWriters(Map<String, IndexWriter> writers) {
        for (Map.Entry<String, IndexWriter> entry : writers.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Failed to close transaction for sub index [" + entry.getKey() + "] since it is alreayd closed"));
            }
            catch (IOException e) {
                Directory dir = this.searchEngineFactory.getLuceneIndexManager().getStore().openDirectory(entry.getKey());
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        IndexWriter.unlock((Directory)dir);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                logger.warn((Object)("Failed to close index writer for sub index [" + entry.getKey() + "]"), (Throwable)e);
            }
            finally {
                this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().trackCloseIndexWriter(entry.getKey(), entry.getValue());
            }
        }
        writers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackWriters(Map<String, IndexWriter> writers) {
        SearchEngineException exception = null;
        for (Map.Entry<String, IndexWriter> entry : writers.entrySet()) {
            try {
                entry.getValue().rollback();
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Failed to abort transaction for sub index [" + entry.getKey() + "] since it is alreayd closed"));
            }
            catch (IOException e) {
                Directory dir = this.searchEngineFactory.getLuceneIndexManager().getStore().openDirectory(entry.getKey());
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        IndexWriter.unlock((Directory)dir);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                exception = new SearchEngineException("Failed to rollback transaction for sub index [" + entry.getKey() + "]", e);
            }
            finally {
                this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().trackCloseIndexWriter(entry.getKey(), entry.getValue());
            }
        }
        writers.clear();
    }

    private void addConcurrentJobsToProcess(List<TransactionJob>[] concurrentJobsToProcess, Set<String> subIndexes, TransactionJobs jobs) {
        subIndexes.addAll(jobs.getSubIndexes());
        for (TransactionJob job : jobs.getJobs()) {
            concurrentJobsToProcess[this.hashing.hash(job) % this.concurrencyLevel].add(job);
        }
    }

    protected boolean isClearCacheOnCommit() {
        return this.settings.getSettingAsBoolean("compass.transaction.clearCacheOnCommit", true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransactionJobProcessor
    implements Callable {
        private final List<TransactionJob> jobsToProcess;
        private final Map<String, IndexWriter> writers;

        private TransactionJobProcessor(List<TransactionJob> jobsToProcess, Map<String, IndexWriter> writers) {
            this.jobsToProcess = jobsToProcess;
            this.writers = writers;
        }

        public Object call() throws Exception {
            for (TransactionJob job : this.jobsToProcess) {
                IndexWriter writer = this.writers.get(job.getSubIndex());
                job.execute(writer, AsyncTransactionProcessorFactory.this.searchEngineFactory);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PollingProcessor
    implements Callable<Object> {
        private volatile boolean closed = false;
        private volatile boolean done = false;

        private PollingProcessor() {
        }

        public void close() {
            this.closed = true;
        }

        public boolean isDone() {
            return this.done;
        }

        @Override
        public Object call() throws Exception {
            while (!this.closed) {
                try {
                    TransactionJobs jobs = (TransactionJobs)AsyncTransactionProcessorFactory.this.jobsToProcess.poll(10L, TimeUnit.SECONDS);
                    if (jobs == null) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Procesing jobs [" + System.identityHashCode(jobs) + "]"));
                    }
                    AsyncTransactionProcessorFactory.this.process(jobs);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)"Procesing jobs done");
                }
                catch (InterruptedException e) {
                    if (this.closed) break;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)"Polling for transaction jobs interrupted", (Throwable)e);
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)"Exception while processing job", (Throwable)e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Async polling transaction processor thread stopped");
            }
            this.done = true;
            return null;
        }
    }
}

