/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.readcommitted;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.readcommitted.TransIndex;
import org.compass.core.lucene.engine.transaction.support.job.DeleteByQueryTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.DeleteTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;

public class TransIndexManager
implements CompassConfigurable {
    private final boolean concurrent;
    private final LuceneSearchEngineFactory searchEngineFactory;
    private CompassSettings settings;
    private final Map<String, TransIndex> transIndexMap;

    public TransIndexManager(LuceneSearchEngineFactory searchEngineFactory, boolean concurrent) {
        this.searchEngineFactory = searchEngineFactory;
        this.concurrent = concurrent;
        this.transIndexMap = concurrent ? new ConcurrentHashMap<String, TransIndex>() : new HashMap<String, TransIndex>();
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
    }

    public void processJob(TransactionJob job) throws Exception {
        if ((job instanceof DeleteTransactionJob || job instanceof DeleteByQueryTransactionJob) && !this.transIndexMap.containsKey(job.getSubIndex())) {
            return;
        }
        this.getTransIndex(job.getSubIndex()).processJob(job);
    }

    public IndexReader getReader(String subIndex) throws IOException {
        return this.transIndexMap.get(subIndex).getReader();
    }

    public IndexSearcher getSearcher(String subIndex) throws IOException {
        return this.transIndexMap.get(subIndex).getSearcher();
    }

    public Directory getDirectory(String subIndex) {
        return this.transIndexMap.get(subIndex).getDirectory();
    }

    public boolean hasTransactions() {
        return !this.transIndexMap.isEmpty();
    }

    public boolean hasTransIndex(String subIndex) {
        return this.transIndexMap.containsKey(subIndex);
    }

    public void commit() throws IOException {
        for (TransIndex transIndex : this.transIndexMap.values()) {
            transIndex.commit();
        }
    }

    public void rollback() throws IOException {
        for (TransIndex transIndex : this.transIndexMap.values()) {
            transIndex.rollback();
        }
    }

    public void commit(String subIndex) throws IOException {
        this.transIndexMap.get(subIndex).commit();
    }

    public void rollback(String subIndex) throws IOException {
        this.transIndexMap.get(subIndex).rollback();
    }

    public void close(String subIndex) throws IOException {
        TransIndex transIndex = this.transIndexMap.remove(subIndex);
        if (transIndex != null) {
            transIndex.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransIndex getTransIndex(String subIndex) {
        TransIndex transIndex = this.transIndexMap.get(subIndex);
        if (transIndex == null) {
            if (this.concurrent) {
                Map<String, TransIndex> map = this.transIndexMap;
                synchronized (map) {
                    transIndex = this.transIndexMap.get(subIndex);
                    if (transIndex == null) {
                        transIndex = new TransIndex(this.searchEngineFactory, subIndex, this.concurrent);
                        transIndex.configure(this.settings);
                        this.transIndexMap.put(subIndex, transIndex);
                    }
                }
            } else {
                transIndex = new TransIndex(this.searchEngineFactory, subIndex, this.concurrent);
                transIndex.configure(this.settings);
                this.transIndexMap.put(subIndex, transIndex);
            }
        }
        return transIndex;
    }
}

