/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.compass.core.Property;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.all.AllAnalyzer;
import org.compass.core.lucene.support.FieldHelper;
import org.compass.core.mapping.AllMapping;
import org.compass.core.mapping.BoostPropertyMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalResource;

public class ResourceEnhancer {
    public static Result enahanceResource(InternalResource resource) {
        LuceneResource luceneResource = (LuceneResource)resource;
        LuceneSearchEngineFactory searchEngineFactory = luceneResource.getSearchEngineFactory();
        ResourceEnhancer.applyBoostIfNeeded(resource, searchEngineFactory);
        ResourceEnhancer.addExtendedProeprty(resource, searchEngineFactory);
        Analyzer analyzer = searchEngineFactory.getAnalyzerManager().getAnalyzerByResource(resource);
        Document document = luceneResource.getDocument();
        analyzer = ResourceEnhancer.addAllProperty(document, resource, analyzer, searchEngineFactory);
        return new Result(analyzer, document);
    }

    private static void applyBoostIfNeeded(InternalResource resource, SearchEngineFactory searchEngineFactory) {
        BoostPropertyMapping boostPropertyMapping = resource.getResourceMapping().getBoostPropertyMapping();
        if (boostPropertyMapping == null) {
            return;
        }
        float boostValue = boostPropertyMapping.getDefaultBoost();
        String boostPropertyName = boostPropertyMapping.getBoostResourcePropertyName();
        String sBoostValue = resource.getValue(boostPropertyName);
        if (!searchEngineFactory.getResourceFactory().isNullValue(sBoostValue)) {
            boostValue = Float.parseFloat(sBoostValue);
        }
        resource.setBoost(boostValue);
    }

    private static void addExtendedProeprty(InternalResource resource, LuceneSearchEngineFactory searchEngineFactory) {
        String extendedAliasProperty = searchEngineFactory.getExtendedAliasProperty();
        resource.removeProperties(extendedAliasProperty);
        ResourceMapping resourceMapping = resource.getResourceMapping();
        for (int i = 0; i < resourceMapping.getExtendedAliases().length; ++i) {
            LuceneProperty extendedAliasProp = (LuceneProperty)searchEngineFactory.getResourceFactory().createProperty(extendedAliasProperty, resourceMapping.getExtendedAliases()[i], Property.Store.NO, Property.Index.NOT_ANALYZED);
            extendedAliasProp.getField().setOmitNorms(true);
            extendedAliasProp.getField().setOmitTf(true);
            resource.addProperty(extendedAliasProp);
        }
    }

    private static Analyzer addAllProperty(Document document, InternalResource resource, Analyzer analyzer, LuceneSearchEngineFactory searchEngineFactory) throws SearchEngineException {
        AllAnalyzer allAnalyzer = new AllAnalyzer(analyzer, resource, searchEngineFactory);
        AllMapping allMapping = resource.getResourceMapping().getAllMapping();
        Field allField = new Field(allMapping.getProperty(), allAnalyzer.createAllTokenStream(), FieldHelper.getFieldTermVector(allMapping.getTermVector()));
        allField.setOmitNorms(allMapping.isOmitNorms().booleanValue());
        allField.setOmitTf(allMapping.isOmitTf().booleanValue());
        document.add((Fieldable)allField);
        return allAnalyzer;
    }

    public static class Result {
        private final Analyzer analyzer;
        private final Document document;

        public Result(Analyzer analyzer, Document document) {
            this.analyzer = analyzer;
            this.document = document;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

