/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.AllMapping;
import org.compass.core.mapping.BoostPropertyMapping;
import org.compass.core.mapping.Cascade;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceAnalyzerController;
import org.compass.core.mapping.ResourceIdMappingProvider;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.internal.DefaultAllMapping;
import org.compass.core.mapping.internal.InternalResourceMapping;
import org.compass.core.mapping.internal.PostProcessingMapping;
import org.compass.core.mapping.support.AbstractMultipleMapping;

public abstract class AbstractResourceMapping
extends AbstractMultipleMapping
implements InternalResourceMapping,
AliasMapping,
PostProcessingMapping {
    private String alias;
    private SubIndexHash subIndexHash;
    private String[] extendedAliases = new String[0];
    private String[] extendingAliases = new String[0];
    private String analyzer;
    private float boost = 1.0f;
    private boolean isRoot = true;
    private AllMapping allMapping = new DefaultAllMapping();
    private SpellCheck spellCheck = SpellCheck.NA;
    private String uidProperty;
    private Mapping[] idMappings;
    private ResourcePropertyMapping[] idPropertyMappings;
    private CascadeMapping[] cascades;
    private Map<String, ResourcePropertyMapping[]> resourcePropertyMappingsByNameMap;
    private Map<PropertyPath, ResourcePropertyMapping> resourcePropertyMappingsByPathMap;
    private String[] resourcePropertyNames;
    private boolean hasSpecificAnalyzerPerResourceProperty;
    private ResourceAnalyzerController analyzerController;
    private BoostPropertyMapping boostPropertyMapping;

    public Mapping[] getIdMappings() {
        if (this.idMappings == null) {
            this.buildResourceIds();
        }
        return this.idMappings;
    }

    public AllMapping getAllMapping() {
        return this.allMapping;
    }

    public void setAllMapping(AllMapping allMapping) {
        this.allMapping = allMapping;
    }

    public SpellCheck getSpellCheck() {
        return this.spellCheck;
    }

    public void setSpellCheck(SpellCheck spellCheck) {
        this.spellCheck = spellCheck;
    }

    public ResourcePropertyMapping[] getResourceIdMappings() {
        if (this.idPropertyMappings == null) {
            this.buildResourceIds();
        }
        return this.idPropertyMappings;
    }

    protected void copy(AbstractResourceMapping resourceMapping) {
        super.copy(resourceMapping);
        this.shallowCopy(resourceMapping);
    }

    public void shallowCopy(AbstractResourceMapping resourceMapping) {
        super.shallowCopy(resourceMapping);
        resourceMapping.setAlias(this.getAlias());
        resourceMapping.setSubIndexHash(this.getSubIndexHash());
        resourceMapping.setExtendedAliases(this.getExtendedAliases());
        resourceMapping.setExtendingAliases(this.getExtendingAliases());
        resourceMapping.setRoot(this.isRoot());
        resourceMapping.setBoost(this.getBoost());
        resourceMapping.setAnalyzer(this.getAnalyzer());
        resourceMapping.setUIDPath(this.getUIDPath());
        resourceMapping.setAllMapping(this.getAllMapping().copy());
        resourceMapping.setSpellCheck(this.getSpellCheck());
        if (this.boostPropertyMapping != null) {
            resourceMapping.boostPropertyMapping = (BoostPropertyMapping)this.boostPropertyMapping.copy();
        }
        if (this.analyzerController != null) {
            resourceMapping.analyzerController = (ResourceAnalyzerController)this.analyzerController.copy();
        }
    }

    public void postProcess() throws MappingException {
        this.doPostProcess();
        this.buildResourcePropertyMap();
        this.buildAnalyzerSpecificFlag();
        this.buildResourceIds();
    }

    protected abstract void doPostProcess() throws MappingException;

    private void buildResourceIds() {
        ArrayList<Mapping> resourceIds = new ArrayList<Mapping>();
        ArrayList<ResourcePropertyMapping> resourceIdPropertyMappings = new ArrayList<ResourcePropertyMapping>();
        Iterator<Mapping> it = this.mappingsIt();
        while (it.hasNext()) {
            ResourcePropertyMapping[] tempPropertyIds;
            Mapping[] tempIds;
            Mapping mapping = it.next();
            if (!(mapping instanceof ResourceIdMappingProvider)) continue;
            for (Mapping tempId : tempIds = ((ResourceIdMappingProvider)((Object)mapping)).getIdMappings()) {
                if (tempId == null) continue;
                resourceIds.add(tempId);
            }
            for (ResourcePropertyMapping tempPropertyId : tempPropertyIds = ((ResourceIdMappingProvider)((Object)mapping)).getResourceIdMappings()) {
                if (tempPropertyId == null) continue;
                resourceIdPropertyMappings.add(tempPropertyId);
            }
        }
        this.idMappings = resourceIds.toArray(new Mapping[resourceIds.size()]);
        this.idPropertyMappings = resourceIdPropertyMappings.toArray(new ResourcePropertyMapping[resourceIdPropertyMappings.size()]);
    }

    private void buildResourcePropertyMap() {
        ArrayList propertyList;
        ResourcePropertyMapping[] resourcePropertyMappings;
        this.resourcePropertyMappingsByPathMap = new HashMap<PropertyPath, ResourcePropertyMapping>();
        HashMap<String, ArrayList> tempMap = new HashMap<String, ArrayList>();
        for (ResourcePropertyMapping resourcePropertyMapping : resourcePropertyMappings = this.getResourcePropertyMappings()) {
            this.resourcePropertyMappingsByPathMap.put(resourcePropertyMapping.getPath(), resourcePropertyMapping);
            propertyList = (ArrayList)tempMap.get(resourcePropertyMapping.getName());
            if (propertyList == null) {
                propertyList = new ArrayList();
                tempMap.put(resourcePropertyMapping.getName(), propertyList);
            }
            propertyList.add(resourcePropertyMapping);
        }
        this.resourcePropertyNames = new String[tempMap.size()];
        int i = 0;
        this.resourcePropertyMappingsByNameMap = new HashMap<String, ResourcePropertyMapping[]>();
        for (Map.Entry entry : tempMap.entrySet()) {
            String propertyName = (String)entry.getKey();
            this.resourcePropertyNames[i++] = propertyName;
            propertyList = (ArrayList)entry.getValue();
            this.resourcePropertyMappingsByNameMap.put(propertyName, propertyList.toArray(new ResourcePropertyMapping[propertyList.size()]));
        }
    }

    private void buildAnalyzerSpecificFlag() {
        for (String propertyName : this.resourcePropertyMappingsByNameMap.keySet()) {
            ResourcePropertyMapping[] mappings = this.resourcePropertyMappingsByNameMap.get(propertyName);
            if (mappings[0].getAnalyzer() == null || this.analyzer != null && this.analyzer.equals(mappings[0].getAnalyzer())) continue;
            this.hasSpecificAnalyzerPerResourceProperty = true;
        }
    }

    public int addMapping(Mapping mapping) {
        if (mapping instanceof ResourceAnalyzerController) {
            this.analyzerController = (ResourceAnalyzerController)mapping;
        }
        if (mapping instanceof BoostPropertyMapping) {
            this.boostPropertyMapping = (BoostPropertyMapping)mapping;
        }
        return super.addMapping(mapping);
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings(String propertyName) {
        return this.resourcePropertyMappingsByNameMap.get(propertyName);
    }

    public ResourcePropertyMapping getResourcePropertyMapping(String propertyName) {
        ResourcePropertyMapping[] retVal = this.getResourcePropertyMappings(propertyName);
        if (retVal == null) {
            return null;
        }
        return retVal[0];
    }

    public ResourcePropertyMapping getResourcePropertyMappingByPath(PropertyPath path) {
        return this.resourcePropertyMappingsByPathMap.get(path);
    }

    public CascadeMapping[] getCascadeMappings() {
        return this.cascades;
    }

    public boolean operationAllowed(Cascade cascade) {
        if (this.isRoot()) {
            return true;
        }
        if (this.cascades == null || this.cascades.length == 0) {
            return false;
        }
        for (CascadeMapping cascade1 : this.cascades) {
            if (!cascade1.shouldCascade(cascade)) continue;
            return true;
        }
        return false;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String[] getExtendedAliases() {
        return this.extendedAliases;
    }

    public void setExtendedAliases(String[] extendedMappings) {
        this.extendedAliases = extendedMappings;
    }

    public void setUIDPath(String uid) {
        this.uidProperty = uid;
    }

    public String getUIDPath() {
        return this.uidProperty;
    }

    public float getBoost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public SubIndexHash getSubIndexHash() {
        return this.subIndexHash;
    }

    public void setSubIndexHash(SubIndexHash subIndexHash) {
        this.subIndexHash = subIndexHash;
    }

    public boolean hasSpecificAnalyzerPerResourceProperty() {
        return this.hasSpecificAnalyzerPerResourceProperty;
    }

    public ResourceAnalyzerController getAnalyzerController() {
        return this.analyzerController;
    }

    public void setAnalyzerController(ResourceAnalyzerController analyzerController) {
        this.analyzerController = analyzerController;
    }

    public BoostPropertyMapping getBoostPropertyMapping() {
        return this.boostPropertyMapping;
    }

    public void setBoostPropertyMapping(BoostPropertyMapping boostPropertyMapping) {
        this.boostPropertyMapping = boostPropertyMapping;
    }

    public String[] getResourcePropertyNames() {
        return this.resourcePropertyNames;
    }

    public String[] getExtendingAliases() {
        return this.extendingAliases;
    }

    public void setExtendingAliases(String[] extendingAliases) {
        this.extendingAliases = extendingAliases;
    }

    public void setCascades(CascadeMapping[] cascades) {
        this.cascades = cascades;
    }
}

