/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SystemPropertyUtils {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private static final Log logger = LogFactory.getLog(SystemPropertyUtils.class);

    public static String resolvePlaceholders(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(text);
        int startIndex = text.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.toString().indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                int nextIndex;
                block9: {
                    String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                    nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                    try {
                        String propVal = System.getProperty(placeholder);
                        if (propVal == null) {
                            propVal = System.getenv(placeholder);
                        }
                        if (propVal != null) {
                            buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                            nextIndex = startIndex + propVal.length();
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property nor environment variable found"));
                        }
                    }
                    catch (Throwable ex) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex));
                    }
                }
                startIndex = buf.toString().indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

